/*
 * Decompiled with CFR 0.152.
 */
package com.credibledoc.plantuml.link;

import com.credibledoc.plantuml.exception.PlantumlRuntimeException;
import com.credibledoc.plantuml.tooltip.TooltipService;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.net.URLCodec;

public class LinkService {
    private static final String SEARCH_PARAMETER = "?search=";
    private static final String LAST_DIGIT = "(.*\\d+)\\D*$";
    private static final Pattern PATTERN = Pattern.compile("(.*\\d+)\\D*$");
    private static final String SPACE_URL_REPLACEMENT = "%20";
    private static final String PLUS = "+";
    private static final LinkService instance = new LinkService();

    public static LinkService getInstance() {
        return instance;
    }

    private String generateSearchParam(String line) {
        try {
            String encodedWithPluses;
            int len = Math.min(line.length(), 30);
            String truncated = line.substring(0, len);
            Matcher matcher = PATTERN.matcher(truncated);
            if (matcher.find()) {
                String dateTimeString = matcher.group(1);
                encodedWithPluses = new URLCodec().encode(dateTimeString, StandardCharsets.UTF_8.name());
            } else {
                encodedWithPluses = new URLCodec().encode(truncated, StandardCharsets.UTF_8.name());
            }
            String encoded = encodedWithPluses.replace(PLUS, SPACE_URL_REPLACEMENT);
            return SEARCH_PARAMETER + encoded;
        }
        catch (UnsupportedEncodingException e) {
            throw new PlantumlRuntimeException(e);
        }
    }

    public String generateLink(String text, String multilineJoined, String reportDocumentLinkResource) {
        return "[[" + reportDocumentLinkResource + this.generateSearchParam(multilineJoined) + " " + TooltipService.getInstance().generateTooltip(multilineJoined) + " " + text + "]]";
    }

    public String generateLink(String text, String searchParam, String reportDocumentLinkResource, String tooltip) {
        return "[[" + reportDocumentLinkResource + this.generateSearchParam(searchParam) + " " + TooltipService.getInstance().generateTooltip(tooltip) + " " + text + "]]";
    }
}

