/*
 * Decompiled with CFR 0.152.
 */
package com.credibledoc.plantuml.svggenerator;

import com.credibledoc.plantuml.exception.PlantumlRuntimeException;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SourceStringReader;
import net.sourceforge.plantuml.core.DiagramDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class SvgGeneratorService {
    private static final String FORBIDDEN_SEQUENCE_FOR_XML_DOCUMENT = "[#";
    private static final String ENDUML = "@enduml";
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final String STARTUML = "@startuml";
    private static final Logger logger = LoggerFactory.getLogger(SvgGeneratorService.class);
    private static final String TAG_G_SVG = "</g></svg>";
    private static final SvgGeneratorService instance = new SvgGeneratorService();

    private SvgGeneratorService() {
    }

    public static SvgGeneratorService getInstance() {
        return instance;
    }

    public String generateSvgFromPlantUml(String plantUml) {
        return this.generateSvgFromPlantUml(plantUml, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String generateSvgFromPlantUml(boolean printWarningAndPlantUml, String plantUml, boolean formatSvg) {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            String string;
            if (!plantUml.trim().startsWith(STARTUML)) {
                plantUml = STARTUML + LINE_SEPARATOR + plantUml;
            }
            if (!plantUml.trim().endsWith(ENDUML)) {
                plantUml = plantUml + LINE_SEPARATOR + ENDUML;
            }
            SourceStringReader reader = new SourceStringReader(plantUml);
            FileFormatOption fileFormatOption = new FileFormatOption(FileFormat.SVG);
            DiagramDescription diagramDescription = reader.outputImage((OutputStream)os, fileFormatOption);
            logger.info("DiagramDescription: {}", (Object)diagramDescription.getDescription());
            String svg = os.toString(StandardCharsets.UTF_8.name());
            if (printWarningAndPlantUml) {
                String warningMessage = "!WARNING! Original strings (double dash) has been replaced with '- -' (dash+space+dash) in this comment, because the string (double dash) is not permitted within comments. And link parameters, for example ?search=... have also been REMOVED from the comment, because they are not readable for humans.";
                svg = svg.replace(TAG_G_SVG, LINE_SEPARATOR + "<!--" + LINE_SEPARATOR + "!WARNING! Original strings (double dash) has been replaced with '- -' (dash+space+dash) in this comment, because the string (double dash) is not permitted within comments. And link parameters, for example ?search=... have also been REMOVED from the comment, because they are not readable for humans." + LINE_SEPARATOR + "<img uml=\"" + LINE_SEPARATOR + this.escape(plantUml) + LINE_SEPARATOR + "\"/>" + LINE_SEPARATOR + "-->" + TAG_G_SVG);
            }
            if (plantUml.contains(FORBIDDEN_SEQUENCE_FOR_XML_DOCUMENT)) {
                formatSvg = false;
            }
            if (formatSvg) {
                string = this.formatSvg(svg);
                return string;
            }
            string = svg;
            return string;
        }
        catch (Exception e) {
            throw new PlantumlRuntimeException("PlantUML: " + plantUml, e);
        }
    }

    public String generateSvgFromPlantUml(String plantUml, boolean formatSvg) {
        return this.generateSvgFromPlantUml(false, plantUml, formatSvg);
    }

    private String formatSvg(String svg) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            StreamResult result = new StreamResult(new StringWriter());
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            dbf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource inputSource = new InputSource(new StringReader(svg));
            Document document = db.parse(inputSource);
            DOMSource source = new DOMSource(document);
            transformer.transform(source, result);
            String formattedSvg = result.getWriter().toString();
            if (logger.isTraceEnabled()) {
                logger.trace(formattedSvg);
            }
            return formattedSvg;
        }
        catch (Exception e) {
            throw new PlantumlRuntimeException("Cannot format the svg source. Source svg: " + svg, e);
        }
    }

    private String escape(String plantUml) {
        return plantUml.replace("--", "- -").replaceAll("\\?search=.*\\s", " ");
    }
}

