/*
 * Decompiled with CFR 0.152.
 */
package com.credibledoc.substitution.reporting.markdown;

import com.credibledoc.plantuml.exception.PlantumlRuntimeException;
import com.credibledoc.plantuml.svggenerator.SvgGeneratorService;
import com.credibledoc.substitution.core.configuration.Configuration;
import com.credibledoc.substitution.core.context.SubstitutionContext;
import com.credibledoc.substitution.core.exception.SubstitutionRuntimeException;
import com.credibledoc.substitution.core.placeholder.Placeholder;
import com.credibledoc.substitution.core.replacement.ReplacementType;
import com.credibledoc.substitution.core.resource.ResourceService;
import com.credibledoc.substitution.reporting.placeholder.PlaceholderToReportDocumentService;
import com.credibledoc.substitution.reporting.reportdocument.ReportDocument;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkdownService {
    private static final Logger logger = LoggerFactory.getLogger(MarkdownService.class);
    private static final String SLASH = "/";
    private static final String IMAGE_DIRECTORY_NAME = "img";
    private static final String SVG_FILE_EXTENSION = ".svg";
    private static final String SVG_TAG_BEGIN = "![";
    private static final String SVG_TAG_MIDDLE = "](";
    private static final String SVG_TAG_END = "?sanitize=true)";
    private static final String SYNTAX_ERROR_GENERATED_KEYWORD = "Syntax Error?";
    private static final String IGNORE_SYNTAX_ERROR_PLACEHOLDER_PARAMETER = "ignoreSyntaxError";
    private static final MarkdownService instance = new MarkdownService();

    public static MarkdownService getInstance() {
        return instance;
    }

    public String generateDiagram(Placeholder placeholder, String plantUml, SubstitutionContext substitutionContext) {
        ResourceService resourceService = ResourceService.getInstance();
        String placeholderResourceRelativePath = resourceService.generatePlaceholderResourceRelativePath(placeholder.getResource(), substitutionContext);
        Configuration configuration = substitutionContext.getConfiguration();
        File mdFile = new File(configuration.getTargetDirectory() + placeholderResourceRelativePath);
        File directory = mdFile.getParentFile();
        File imageDirectory = new File(directory, IMAGE_DIRECTORY_NAME);
        this.createDirectoryIfNotExists(imageDirectory);
        if (plantUml == null) {
            ReportDocument reportDocument = PlaceholderToReportDocumentService.getInstance().getReportDocument(placeholder);
            plantUml = String.join((CharSequence)System.lineSeparator(), reportDocument.getCacheLines());
        }
        String placeholderDescription = placeholder.getDescription();
        if (plantUml.isEmpty()) {
            return "Cannot generate diagram because source content not found. PlaceholderDescription: '" + placeholderDescription + "'.";
        }
        boolean replaceFilterId = "true".equals(substitutionContext.getConfiguration().getReplaceFilterId());
        return this.generateSvgFileAndTagForMarkdown(mdFile, imageDirectory, plantUml, placeholder, replaceFilterId);
    }

    private String generateSvgFileAndTagForMarkdown(File mdFile, File imageDirectory, String plantUml, Placeholder placeholder, boolean replaceFilterId) {
        try {
            boolean ignoreSyntaxError;
            String svg = SvgGeneratorService.getInstance().generateSvgFromPlantUml(plantUml);
            if (replaceFilterId) {
                svg = this.replaceFilterId(svg);
            }
            File svgFile = new File(imageDirectory, mdFile.getName() + "_" + placeholder.getId() + SVG_FILE_EXTENSION);
            try (FileOutputStream outputStream = new FileOutputStream(svgFile);){
                ((OutputStream)outputStream).write(svg.getBytes());
            }
            logger.debug("File created: {}", (Object)svgFile.getAbsolutePath());
            boolean bl = ignoreSyntaxError = placeholder.getParameters().containsKey(IGNORE_SYNTAX_ERROR_PLACEHOLDER_PARAMETER) && ((String)placeholder.getParameters().get(IGNORE_SYNTAX_ERROR_PLACEHOLDER_PARAMETER)).equals("false");
            if (!ignoreSyntaxError && svg.contains(SYNTAX_ERROR_GENERATED_KEYWORD)) {
                throw new PlantumlRuntimeException("SVG contains 'Syntax Error?' substring. SVG: '" + svg + "'. " + System.lineSeparator() + placeholder);
            }
            if (placeholder.getParameters().get("targetFormat") != null) {
                ReplacementType replacementType = ReplacementType.valueOf((String)((String)placeholder.getParameters().get("targetFormat")));
                if (ReplacementType.HTML_EMBEDDED == replacementType) {
                    return svg;
                }
                throw new SubstitutionRuntimeException("Unknown " + ReplacementType.class.getSimpleName() + " value " + replacementType);
            }
            return SVG_TAG_BEGIN + placeholder.getDescription() + SVG_TAG_MIDDLE + imageDirectory.getName() + SLASH + svgFile.getName() + SVG_TAG_END;
        }
        catch (Exception e) {
            throw new SubstitutionRuntimeException((Throwable)e);
        }
    }

    private String replaceFilterId(String svg) {
        int beginFilter = svg.indexOf("<filter ");
        if (beginFilter == -1) {
            return svg;
        }
        String beginIdPattern = " id=\"";
        int beginId = svg.indexOf(beginIdPattern, beginFilter);
        if (beginId == -1) {
            return svg;
        }
        int endId = svg.indexOf("\" ", beginId + beginIdPattern.length());
        String oldId = svg.substring(beginId + beginIdPattern.length(), endId);
        return svg.replace(oldId, "1");
    }

    private void createDirectoryIfNotExists(File directory) {
        if (!directory.exists()) {
            boolean created = directory.mkdirs();
            if (!created) {
                throw new SubstitutionRuntimeException("Cannot create a new directory '" + directory.getAbsolutePath() + "'");
            }
            logger.info("The new directory created '{}'", (Object)directory.getAbsolutePath());
        }
    }
}

