/*
 * Decompiled with CFR 0.152.
 */
package com.credibledoc.substitution.reporting.replacement;

import com.credibledoc.combiner.file.FileService;
import com.credibledoc.substitution.core.configuration.Configuration;
import com.credibledoc.substitution.core.content.Content;
import com.credibledoc.substitution.core.content.ContentGenerator;
import com.credibledoc.substitution.core.content.ContentGeneratorService;
import com.credibledoc.substitution.core.context.SubstitutionContext;
import com.credibledoc.substitution.core.exception.SubstitutionRuntimeException;
import com.credibledoc.substitution.core.pair.Pair;
import com.credibledoc.substitution.core.placeholder.Placeholder;
import com.credibledoc.substitution.core.placeholder.PlaceholderService;
import com.credibledoc.substitution.core.resource.ResourceService;
import com.credibledoc.substitution.core.resource.ResourceType;
import com.credibledoc.substitution.core.resource.TemplateResource;
import com.credibledoc.substitution.core.template.TemplateService;
import com.credibledoc.substitution.core.tracking.Trackable;
import com.credibledoc.substitution.reporting.markdown.MarkdownService;
import com.credibledoc.substitution.reporting.reportdocument.creator.ReportDocumentCreator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplacementService {
    private static final Logger logger = LoggerFactory.getLogger(ReplacementService.class);
    public static final String CONTENT_REPLACED = "Content replaced. ";
    private static final ReplacementService instance = new ReplacementService();

    public static ReplacementService getInstance() {
        return instance;
    }

    public void insertContentIntoTemplate(TemplateResource templateResource, SubstitutionContext substitutionContext) {
        try {
            List templatePlaceholders = PlaceholderService.getInstance().parsePlaceholders(templateResource, substitutionContext);
            File generatedFile = this.getTargetFile(templateResource, substitutionContext);
            if (templatePlaceholders.isEmpty()) {
                Files.copy(templateResource.getFile().toPath(), generatedFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                return;
            }
            String replacedContent = this.replaceContent(templateResource, templatePlaceholders, substitutionContext);
            try (FileOutputStream outputStream = new FileOutputStream(generatedFile);){
                ((OutputStream)outputStream).write(replacedContent.getBytes());
            }
            logger.trace("File generated. '{}'", (Object)generatedFile.getAbsolutePath());
        }
        catch (Exception exception) {
            throw new SubstitutionRuntimeException((Throwable)exception);
        }
    }

    public File getTargetFile(TemplateResource templateResource, SubstitutionContext substitutionContext) {
        ResourceService resourceService = ResourceService.getInstance();
        String placeholderResourceRelativePath = resourceService.generatePlaceholderResourceRelativePath(templateResource, substitutionContext);
        Configuration configuration = substitutionContext.getConfiguration();
        File generatedFile = new File(configuration.getTargetDirectory() + placeholderResourceRelativePath);
        File generatedFileDirectory = generatedFile.getParentFile();
        this.createDirectoryIfNotExists(generatedFileDirectory);
        return generatedFile;
    }

    private String replaceContent(TemplateResource templateResource, List<String> templatePlaceholders, SubstitutionContext substitutionContext) {
        String replacedContent = TemplateService.getInstance().getTemplateContent(templateResource, StandardCharsets.UTF_8.name());
        String lineEnding = FileService.findLineEnding((String)replacedContent);
        int position = 1;
        for (String templatePlaceholder : templatePlaceholders) {
            Placeholder placeholder = PlaceholderService.getInstance().parseJsonFromPlaceholder(templatePlaceholder, templateResource, substitutionContext);
            placeholder.setId(Integer.toString(position++));
            String contentForReplacement = this.generateContent(placeholder, substitutionContext);
            String normalizedContent = contentForReplacement.replaceAll("\r\n|\n|\r", lineEnding);
            replacedContent = replacedContent.replace(templatePlaceholder, normalizedContent);
            String json = PlaceholderService.getInstance().writePlaceholderToJson(placeholder);
            logger.trace("{}{}", (Object)CONTENT_REPLACED, (Object)json);
        }
        return replacedContent;
    }

    private String generateContent(Placeholder placeholder, SubstitutionContext substitutionContext) {
        try {
            Class<?> placeholderClass = Class.forName(placeholder.getClassName());
            if (ReportDocumentCreator.class.isAssignableFrom(placeholderClass)) {
                String generatedTag = this.findPlaceholderAndGenerateDiagram(placeholder, substitutionContext);
                if (generatedTag != null) {
                    return generatedTag;
                }
            } else if (ContentGenerator.class.isAssignableFrom(placeholderClass)) {
                return this.processContentGenerator(placeholder, substitutionContext, placeholderClass);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SubstitutionRuntimeException("PlaceholderClass cannot be found. Placeholder className: '" + placeholder.getClassName() + "', placeholder: " + placeholder, (Throwable)classNotFoundException);
        }
        throw new SubstitutionRuntimeException("Cannot generate a content for the placeholder: " + placeholder + "'");
    }

    private String processContentGenerator(Placeholder placeholder, SubstitutionContext substitutionContext, Class<? extends ContentGenerator> placeholderClass) {
        ContentGenerator contentGenerator = ContentGeneratorService.getInstance().getContentGenerator(placeholderClass);
        Content content = contentGenerator.generate(placeholder, substitutionContext);
        if (contentGenerator instanceof Trackable && !ResourceService.getInstance().isLocatedInJar()) {
            Trackable trackable = (Trackable)contentGenerator;
            List paths = trackable.getFragmentPaths();
            for (Path path : paths) {
                Pair pair = new Pair((Object)path, (Object)placeholder.getResource().getFile().toPath());
                List pairs = substitutionContext.getTrackableRepository().getPairs();
                if (pairs.contains(pair)) continue;
                pairs.add(pair);
            }
        }
        if (content.getPlantUmlContent() != null) {
            String svg = MarkdownService.getInstance().generateDiagram(placeholder, content.getPlantUmlContent(), substitutionContext);
            if (content.getMarkdownContent() != null) {
                return svg + content.getMarkdownContent();
            }
            return svg;
        }
        return content.getMarkdownContent();
    }

    private String findPlaceholderAndGenerateDiagram(Placeholder placeholder, SubstitutionContext substitutionContext) {
        for (Placeholder nextPlaceholder : substitutionContext.getPlaceholderRepository().getPlaceholders()) {
            if (!nextPlaceholder.getResource().equals((Object)placeholder.getResource()) || !nextPlaceholder.getId().equals(placeholder.getId())) continue;
            return MarkdownService.getInstance().generateDiagram(nextPlaceholder, null, substitutionContext);
        }
        return null;
    }

    private void createDirectoryIfNotExists(File directory) {
        if (!directory.exists()) {
            boolean created = directory.mkdirs();
            if (!created) {
                throw new SubstitutionRuntimeException("Cannot create a new directory '" + directory.getAbsolutePath() + "'");
            }
            logger.info("The new directory created '{}'", (Object)directory.getAbsolutePath());
        }
    }

    public void replace(SubstitutionContext substitutionContext) {
        List<TemplateResource> templateResources = this.copyResourcesToTargetDirectory(substitutionContext);
        for (TemplateResource templateResource : templateResources) {
            this.insertContentIntoTemplate(templateResource, substitutionContext);
        }
    }

    public List<TemplateResource> copyResourcesToTargetDirectory(SubstitutionContext substitutionContext) {
        try {
            ArrayList<TemplateResource> result = new ArrayList<TemplateResource>();
            Configuration configuration = substitutionContext.getConfiguration();
            ResourceService resourceService = ResourceService.getInstance();
            List allResources = resourceService.getResources(null, configuration.getTemplatesResource());
            TemplateService templateService = TemplateService.getInstance();
            PlaceholderService placeholderService = PlaceholderService.getInstance();
            logger.info("Templates will be copied to the target directory. Templates number: {}. Target directory: '{}'.", (Object)allResources.size(), (Object)configuration.getTargetDirectory());
            for (TemplateResource templateResource : allResources) {
                String targetFileAbsolutePath;
                String targetFileRelativePath;
                List placeholders = placeholderService.parsePlaceholders(templateResource, substitutionContext);
                if (!placeholders.isEmpty()) {
                    result.add(templateResource);
                }
                if (templateResource.getType() == ResourceType.FILE) {
                    targetFileRelativePath = resourceService.generatePlaceholderResourceRelativePath(templateResource, substitutionContext);
                    targetFileAbsolutePath = configuration.getTargetDirectory() + targetFileRelativePath;
                    logger.trace("Resource will be copied to file. Resource: '{}'. TargetFileAbsolutePath: '{}'", (Object)templateResource, (Object)targetFileAbsolutePath);
                    Path targetPath = Paths.get(targetFileAbsolutePath, new String[0]);
                    Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
                    Files.copy(templateResource.getFile().toPath(), targetPath, StandardCopyOption.REPLACE_EXISTING);
                    continue;
                }
                if (templateResource.getType() == ResourceType.CLASSPATH) {
                    if (!this.containsDotInName(templateResource.getPath())) continue;
                    targetFileRelativePath = resourceService.generatePlaceholderResourceRelativePath(templateResource, substitutionContext);
                    targetFileAbsolutePath = configuration.getTargetDirectory() + targetFileRelativePath;
                    logger.trace("Resource will be copied to file. Resource: '{}'. TargetFileAbsolutePath: '{}'", (Object)templateResource, (Object)targetFileAbsolutePath);
                    File file = templateService.exportResource(templateResource.getPath(), targetFileAbsolutePath);
                    logger.trace("Resource copied to file: '{}'", (Object)file.getAbsolutePath());
                    continue;
                }
                throw new IllegalArgumentException("Unknown ResourceType " + templateResource.getType());
            }
            return result;
        }
        catch (Exception e) {
            throw new SubstitutionRuntimeException((Throwable)e);
        }
    }

    private boolean containsDotInName(String resource) {
        int index = resource.lastIndexOf(47);
        if (index == -1) {
            index = 0;
        }
        String fileName = resource.substring(index);
        return fileName.contains(".");
    }
}

