/*
 * Decompiled with CFR 0.152.
 */
package com.credibledoc.substitution.reporting.reportdocument;

import com.credibledoc.substitution.core.exception.SubstitutionRuntimeException;
import com.credibledoc.substitution.reporting.report.Report;
import com.credibledoc.substitution.reporting.reportdocument.ReportDocument;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReportDocumentList<E>
extends ArrayList<E> {
    private final Map<Report, List<ReportDocument>> map = new HashMap<Report, List<ReportDocument>>();

    @Override
    public boolean add(Object object) {
        if (!(object instanceof ReportDocument)) {
            throw new SubstitutionRuntimeException("Expected " + ReportDocument.class.getCanonicalName() + " but found " + object.getClass().getCanonicalName());
        }
        ReportDocument reportDocument = (ReportDocument)object;
        if (reportDocument.getReport() == null) {
            throw new SubstitutionRuntimeException("Report is mandatory for ReportDocument: " + reportDocument);
        }
        List<ReportDocument> list = this.map.get(reportDocument.getReport());
        if (list == null) {
            list = new ArrayList<ReportDocument>();
            list.add(reportDocument);
            this.map.put(reportDocument.getReport(), list);
            return super.add(reportDocument);
        }
        if (list.contains(reportDocument)) {
            return false;
        }
        list.add(reportDocument);
        return super.add(reportDocument);
    }

    @Override
    public boolean addAll(Collection collection) {
        for (Object object : collection) {
            this.add(object);
        }
        return super.addAll(collection);
    }

    public List<ReportDocument> get(Report report) {
        return this.map.get(report);
    }
}

