/*
 * Decompiled with CFR 0.152.
 */
package com.credibledoc.substitution.reporting.reportdocument;

import com.credibledoc.combiner.node.file.NodeFile;
import com.credibledoc.combiner.node.file.NodeFileTreeSet;
import com.credibledoc.substitution.core.exception.SubstitutionRuntimeException;
import com.credibledoc.substitution.reporting.context.ReportingContext;
import com.credibledoc.substitution.reporting.report.Report;
import com.credibledoc.substitution.reporting.reportdocument.ReportDocument;
import com.credibledoc.substitution.reporting.reportdocument.ReportDocumentList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class ReportDocumentService {
    private static final ReportDocumentService instance = new ReportDocumentService();

    public static ReportDocumentService getInstance() {
        return instance;
    }

    public void addReportDocument(ReportDocument reportDocument, ReportingContext reportingContext) {
        if (reportDocument.getReport() == null) {
            throw new SubstitutionRuntimeException("Report cannot be empty in ReportDocument. ReportDocument: " + reportDocument);
        }
        reportingContext.getReportDocumentRepository().getReportDocuments().add((Object)reportDocument);
    }

    public void addAll(Collection<ReportDocument> reportDocuments, ReportingContext reportingContext) {
        for (ReportDocument reportDocument : reportDocuments) {
            this.addReportDocument(reportDocument, reportingContext);
        }
    }

    public void addReportDocumentForAddition(ReportDocument reportDocument, ReportingContext reportingContext) {
        if (reportDocument.getReport() == null) {
            throw new SubstitutionRuntimeException("Report is mandatory for ReportDocument: " + reportDocument);
        }
        reportingContext.getReportDocumentRepository().getReportDocumentsForAddition().add(reportDocument);
    }

    public void mergeReportDocumentsForAddition(ReportingContext reportingContext) {
        ReportDocumentList<ReportDocument> reportDocuments = reportingContext.getReportDocumentRepository().getReportDocuments();
        List<ReportDocument> reportDocumentsForAddition = reportingContext.getReportDocumentRepository().getReportDocumentsForAddition();
        reportDocuments.addAll(reportDocumentsForAddition);
        reportDocumentsForAddition.clear();
    }

    public List<ReportDocument> getReportDocuments(Report report, ReportingContext reportingContext) {
        ReportDocumentList<ReportDocument> reportDocuments = reportingContext.getReportDocumentRepository().getReportDocuments();
        return reportDocuments.get(report);
    }

    public Set<NodeFile> getNodeFiles(List<ReportDocument> reportDocuments) {
        NodeFileTreeSet nodeFiles = new NodeFileTreeSet();
        for (ReportDocument reportDocument : reportDocuments) {
            Set<NodeFile> nodeFilesSet = reportDocument.getNodeFiles();
            nodeFiles.addAll(nodeFilesSet);
        }
        return nodeFiles;
    }
}

