/*
 * Decompiled with CFR 0.152.
 */
package com.credibledoc.substitution.reporting.reportdocument.creator;

import com.credibledoc.combiner.context.CombinerContext;
import com.credibledoc.combiner.file.FileService;
import com.credibledoc.combiner.file.FileWithSources;
import com.credibledoc.combiner.node.file.NodeFile;
import com.credibledoc.combiner.node.file.NodeFileService;
import com.credibledoc.combiner.node.log.NodeLog;
import com.credibledoc.combiner.node.log.NodeLogService;
import com.credibledoc.combiner.tactic.Tactic;
import com.credibledoc.enricher.context.EnricherContext;
import com.credibledoc.substitution.core.context.SubstitutionContext;
import com.credibledoc.substitution.core.exception.SubstitutionRuntimeException;
import com.credibledoc.substitution.core.placeholder.Placeholder;
import com.credibledoc.substitution.core.placeholder.PlaceholderService;
import com.credibledoc.substitution.core.resource.TemplateResource;
import com.credibledoc.substitution.reporting.context.ReportingContext;
import com.credibledoc.substitution.reporting.placeholder.PlaceholderToReportDocumentService;
import com.credibledoc.substitution.reporting.report.Report;
import com.credibledoc.substitution.reporting.reportdocument.ReportDocument;
import com.credibledoc.substitution.reporting.reportdocument.creator.ReportDocumentCreator;
import com.credibledoc.substitution.reporting.reportdocument.creator.ReportDocumentCreatorRepository;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportDocumentCreatorService {
    private static final Logger logger = LoggerFactory.getLogger(ReportDocumentCreatorService.class);
    private static final String SOURCE_FILE_RELATIVE_PATH_PLACEHOLDER_PARAMETER = "sourceFileRelativePath";
    private static final ReportDocumentCreatorService instance = new ReportDocumentCreatorService();

    public static ReportDocumentCreatorService getInstance() {
        return instance;
    }

    public void addReportDocumentCreators(Collection<ReportDocumentCreator> reportDocumentCreators, ReportingContext reportingContext) {
        HashMap map = new HashMap();
        for (ReportDocumentCreator reportDocumentCreator : reportDocumentCreators) {
            map.put(reportDocumentCreator.getClass(), reportDocumentCreator);
        }
        reportingContext.getReportDocumentCreatorRepository().getMap().putAll(map);
    }

    public void createReportDocuments(CombinerContext combinerContext, ReportingContext reportingContext, SubstitutionContext substitutionContext, EnricherContext enricherContext, List<TemplateResource> templateResources) {
        TemplateResource lastTemplateResource = null;
        String lastTemplatePlaceholder = null;
        ReportDocumentCreatorRepository reportDocumentCreatorRepository = reportingContext.getReportDocumentCreatorRepository();
        try {
            PlaceholderService placeholderService = PlaceholderService.getInstance();
            Iterator<TemplateResource> iterator = templateResources.iterator();
            while (iterator.hasNext()) {
                TemplateResource templateResource;
                lastTemplateResource = templateResource = iterator.next();
                List placeholders = placeholderService.parsePlaceholders(templateResource, substitutionContext);
                int position = 1;
                Iterator iterator2 = placeholders.iterator();
                while (iterator2.hasNext()) {
                    String templatePlaceholder;
                    lastTemplatePlaceholder = templatePlaceholder = (String)iterator2.next();
                    Placeholder placeholder = placeholderService.parseJsonFromPlaceholder(templatePlaceholder, templateResource, substitutionContext);
                    placeholder.setId(Integer.toString(position++));
                    Class<?> placeholderClass = Class.forName(placeholder.getClassName());
                    ReportDocumentCreator reportDocumentCreator = reportDocumentCreatorRepository.getMap().get(placeholderClass);
                    if (reportDocumentCreator == null || !ReportDocumentCreator.class.isAssignableFrom(placeholderClass)) continue;
                    this.createReportDocumentForPlaceholder(placeholder, reportDocumentCreator, combinerContext, substitutionContext, reportingContext, enricherContext);
                }
            }
            logger.info("Report documents created");
        }
        catch (ClassNotFoundException e) {
            throw new SubstitutionRuntimeException("Class defined in the placeholder cannot be found, templateResource: '" + lastTemplateResource + "', templatePlaceholder: '" + lastTemplatePlaceholder + "'.", (Throwable)e);
        }
        catch (Exception e) {
            throw new SubstitutionRuntimeException((Throwable)e);
        }
    }

    private void createReportDocumentForPlaceholder(Placeholder placeholder, ReportDocumentCreator reportDocumentCreator, CombinerContext combinerContext, SubstitutionContext substitutionContext, ReportingContext reportingContext, EnricherContext enricherContext) {
        ReportDocument reportDocument = reportDocumentCreator.prepareReportDocument(enricherContext);
        PlaceholderToReportDocumentService.getInstance().putPlaceholderToReportDocument(placeholder, reportDocument);
        substitutionContext.getPlaceholderRepository().getPlaceholders().add(placeholder);
        if (placeholder.getParameters() != null && placeholder.getParameters().get(SOURCE_FILE_RELATIVE_PATH_PLACEHOLDER_PARAMETER) != null) {
            File file = new File((String)placeholder.getParameters().get(SOURCE_FILE_RELATIVE_PATH_PLACEHOLDER_PARAMETER));
            FileWithSources fileWithSources = new FileWithSources();
            fileWithSources.setFile(file);
            fileWithSources.getSources().add(file);
            if (!file.exists()) {
                logger.info("File doesn't exist. Report will not be created. File: '{}'", (Object)file.getAbsolutePath());
            } else {
                logger.trace("File will be parsed: {}", (Object)file.getAbsolutePath());
                this.prepareReport(fileWithSources, reportDocument, combinerContext, reportingContext);
            }
        }
        reportingContext.getReportDocumentRepository().getReportDocuments().add((Object)reportDocument);
    }

    private void prepareReport(FileWithSources fileWithSources, ReportDocument reportDocument, CombinerContext combinerContext, ReportingContext reportingContext) {
        Report report = new Report();
        reportingContext.getReportRepository().addReports(Collections.singletonList(report));
        reportDocument.setReport(report);
        FileService fileService = FileService.getInstance();
        Tactic tactic = fileService.findTactic(fileWithSources.getFile(), combinerContext);
        Date date = fileService.findDate(fileWithSources.getFile(), tactic);
        NodeLogService nodeLogService = NodeLogService.getInstance();
        NodeLog nodeLog = nodeLogService.createNodeLog(fileWithSources, combinerContext, tactic);
        nodeLog.setTactic(tactic);
        NodeFile nodeFile = NodeFileService.getInstance().createNodeFile(date, fileWithSources, combinerContext, nodeLog);
        reportDocument.getNodeFiles().add(nodeFile);
        nodeLogService.findNodeLogs(tactic, combinerContext).add(nodeLog);
        logger.info("Report prepared. Report: {}", (Object)report.hashCode());
    }
}

