/*
 * Decompiled with CFR 0.152.
 */
package com.credibledoc.substitution.reporting.tracking;

import com.credibledoc.substitution.core.context.SubstitutionContext;
import com.credibledoc.substitution.core.exception.SubstitutionRuntimeException;
import com.credibledoc.substitution.core.pair.Pair;
import com.credibledoc.substitution.core.resource.ResourceService;
import com.credibledoc.substitution.core.resource.TemplateResource;
import com.credibledoc.substitution.reporting.replacement.ReplacementService;
import com.credibledoc.substitution.reporting.tracking.TrackingResult;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackingService {
    private static final Logger logger = LoggerFactory.getLogger(TrackingService.class);
    private final WatchService watchService = FileSystems.getDefault().newWatchService();
    private final Map<WatchKey, Path> map = new HashMap<WatchKey, Path>();
    private final SubstitutionContext substitutionContext;
    private final Map<Path, Set<Path>> fragmentDependencyMap;

    public TrackingService(SubstitutionContext substitutionContext) throws IOException {
        this.substitutionContext = substitutionContext;
        this.fragmentDependencyMap = new HashMap<Path, Set<Path>>();
    }

    private void addFromRepository() {
        try {
            HashSet<Path> toRegister = new HashSet<Path>();
            for (Pair pair : this.substitutionContext.getTrackableRepository().getPairs()) {
                Path fragmentPath = (Path)pair.getLeft();
                Path templatePath = (Path)pair.getRight();
                if (this.fragmentDependencyMap.containsKey(fragmentPath)) {
                    this.fragmentDependencyMap.get(fragmentPath).add(templatePath);
                } else {
                    HashSet<Path> value = new HashSet<Path>();
                    value.add(templatePath);
                    this.fragmentDependencyMap.put(fragmentPath, value);
                }
                toRegister.add(fragmentPath.getParent());
                Path parent = fragmentPath.getParent().getParent();
                if (parent == null) continue;
                toRegister.add(parent);
            }
            for (Path path : toRegister) {
                this.register(path);
            }
        }
        catch (Exception e) {
            throw new SubstitutionRuntimeException((Throwable)e);
        }
    }

    public void track() throws IOException, InterruptedException {
        this.addFromRepository();
        ResourceService resourceService = ResourceService.getInstance();
        String templatesResource = this.substitutionContext.getConfiguration().getTemplatesResource();
        File templatesDir = resourceService.findTemplatesDir(templatesResource);
        Path path = templatesDir.toPath();
        this.registerAll(path);
        this.processEvents();
    }

    private void processEvents() throws IOException, InterruptedException {
        WatchKey key;
        TrackingResult trackingResult;
        while (TrackingResult.FAILED != (trackingResult = this.processWatchKey(key = this.watchService.take()))) {
        }
    }

    private TrackingResult processWatchKey(WatchKey watchKey) throws IOException {
        Path dir = this.map.get(watchKey);
        if (dir == null) {
            logger.error("WatchKey not recognized.");
            return TrackingResult.FAILED;
        }
        for (WatchEvent<?> event : watchKey.pollEvents()) {
            this.processEvent(dir, event);
        }
        boolean valid = watchKey.reset();
        if (!valid) {
            logger.trace("WatchKey will be deleted '{}'", (Object)dir);
            this.map.remove(watchKey);
            if (this.map.isEmpty()) {
                return TrackingResult.SUCCESSFUL;
            }
        }
        return TrackingResult.SUCCESSFUL;
    }

    private void processEvent(Path dir, WatchEvent<?> event) throws IOException {
        boolean fragmentDeleted;
        WatchEvent.Kind<?> kind = event.kind();
        if (kind == StandardWatchEventKinds.OVERFLOW) {
            logger.error("WatchKey OVERFLOW");
            return;
        }
        WatchEvent<?> ev = event;
        Path name = (Path)ev.context();
        Path path = dir.resolve(name);
        logger.trace("WatchEvent.Kind: {}, {}", kind, (Object)path);
        boolean bl = fragmentDeleted = kind == StandardWatchEventKinds.ENTRY_DELETE && this.isFragment(path);
        if (!path.toString().endsWith("~") && fragmentDeleted) {
            this.deleteFragment(path);
            return;
        }
        if (kind == StandardWatchEventKinds.ENTRY_DELETE && (Files.isDirectory(path, new LinkOption[0]) || this.map.containsValue(path))) {
            this.deleteDir(path);
        }
        if (kind == StandardWatchEventKinds.ENTRY_CREATE && Files.isDirectory(path, new LinkOption[0])) {
            this.createDir(path);
        }
        if (!path.toString().endsWith("~") && Files.isRegularFile(path, new LinkOption[0])) {
            this.processFile(kind, path);
        }
    }

    private boolean isFragment(Path path) {
        String templatesResource = this.substitutionContext.getConfiguration().getTemplatesResource();
        Path templatesPath = ResourceService.getInstance().findTemplatesDir(templatesResource).toPath();
        String templatesPathNormalized = templatesPath.toAbsolutePath().normalize().toString();
        String pathNormalized = path.toAbsolutePath().normalize().toString();
        return !pathNormalized.startsWith(templatesPathNormalized);
    }

    private void processFile(WatchEvent.Kind<?> kind, Path path) {
        try {
            ReplacementService replacementService = ReplacementService.getInstance();
            boolean isFragment = this.isFragment(path);
            if (isFragment && this.fragmentDependencyMap.containsKey(path)) {
                for (Path templatePath : this.fragmentDependencyMap.get(path)) {
                    TemplateResource templateResource = new TemplateResource(templatePath);
                    replacementService.insertContentIntoTemplate(templateResource, this.substitutionContext);
                }
            }
            if (!isFragment) {
                TemplateResource templateResource = new TemplateResource(path);
                if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
                    File generatedFile = replacementService.getTargetFile(templateResource, this.substitutionContext);
                    logger.trace("File will be deleted '{}'", (Object)generatedFile.getAbsolutePath());
                    Files.deleteIfExists(generatedFile.toPath());
                } else {
                    replacementService.insertContentIntoTemplate(templateResource, this.substitutionContext);
                }
            }
        }
        catch (Exception e) {
            logger.trace(e.getMessage(), (Throwable)e);
        }
    }

    private void deleteFragment(Path path) {
        try {
            ReplacementService replacementService = ReplacementService.getInstance();
            boolean isFragment = this.isFragment(path);
            if (isFragment) {
                for (Path nextKey : this.getChildrenFragmentTemplates(path)) {
                    TemplateResource templateResource = new TemplateResource(nextKey);
                    replacementService.insertContentIntoTemplate(templateResource, this.substitutionContext);
                }
            }
        }
        catch (Exception e) {
            logger.trace(e.getMessage(), (Throwable)e);
        }
    }

    private Set<Path> getChildrenFragmentTemplates(Path path) {
        HashSet<Path> result = new HashSet<Path>();
        String dirName = path.normalize().toString();
        for (Map.Entry<Path, Set<Path>> entry : this.fragmentDependencyMap.entrySet()) {
            Path mapKey = entry.getKey();
            String mapKeyName = mapKey.toString();
            if (!mapKeyName.startsWith(dirName)) continue;
            result.addAll((Collection<Path>)entry.getValue());
        }
        return result;
    }

    private void createDir(Path path) throws IOException {
        if (!this.isFragment(path)) {
            ReplacementService replacementService = ReplacementService.getInstance();
            TemplateResource templateResource = new TemplateResource(path);
            File generatedDir = replacementService.getTargetFile(templateResource, this.substitutionContext);
            Files.createDirectories(generatedDir.toPath(), new FileAttribute[0]);
        }
        this.registerAll(path);
    }

    private void deleteDir(Path path) throws IOException {
        ReplacementService replacementService = ReplacementService.getInstance();
        TemplateResource templateResource = new TemplateResource(path);
        File generatedDir = replacementService.getTargetFile(templateResource, this.substitutionContext);
        this.deleteDirRecursively(generatedDir);
    }

    private void deleteDirRecursively(File directoryToDelete) throws IOException {
        File[] allContents = directoryToDelete.listFiles();
        if (allContents != null) {
            for (File file : allContents) {
                this.deleteDirRecursively(file);
            }
        }
        logger.trace("File will be deleted '{}'", (Object)directoryToDelete.getAbsolutePath());
        Files.deleteIfExists(directoryToDelete.toPath());
    }

    private void registerAll(Path start) throws IOException {
        Files.walkFileTree(start, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes attrs) throws IOException {
                TrackingService.this.register(path);
                TrackingService.this.reloadFragments(path);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void reloadFragments(Path path) {
        ReplacementService replacementService = ReplacementService.getInstance();
        if (this.isFragment(path)) {
            File[] files = path.toFile().listFiles();
            if (files == null) {
                return;
            }
            for (File file : files) {
                if (!file.isFile() || !this.isFragment(file.toPath()) || !this.fragmentDependencyMap.containsKey(file.toPath())) continue;
                for (Path templatePath : this.fragmentDependencyMap.get(file.toPath())) {
                    TemplateResource templateResource = new TemplateResource(templatePath);
                    replacementService.insertContentIntoTemplate(templateResource, this.substitutionContext);
                }
            }
        }
    }

    private void register(Path path) throws IOException {
        WatchKey key = path.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        this.map.put(key, path);
    }
}

