/*
 * Decompiled with CFR 0.152.
 */
package com.credibledoc.substitution.reporting.visualizer;

import com.credibledoc.combiner.context.CombinerContext;
import com.credibledoc.combiner.log.buffered.LogBufferedReader;
import com.credibledoc.combiner.log.reader.ReaderService;
import com.credibledoc.combiner.node.file.NodeFileTreeSet;
import com.credibledoc.combiner.state.FilesMergerState;
import com.credibledoc.enricher.context.EnricherContext;
import com.credibledoc.enricher.printable.Printable;
import com.credibledoc.enricher.transformer.TransformerService;
import com.credibledoc.substitution.core.exception.SubstitutionRuntimeException;
import com.credibledoc.substitution.reporting.context.ReportingContext;
import com.credibledoc.substitution.reporting.report.Report;
import com.credibledoc.substitution.reporting.reportdocument.ReportDocument;
import com.credibledoc.substitution.reporting.reportdocument.ReportDocumentService;
import com.credibledoc.substitution.reporting.reportdocument.ReportDocumentType;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisualizerService {
    private static final Logger logger = LoggerFactory.getLogger(VisualizerService.class);
    private static final String IGNORE_FAILURES = "credibledocIgnoreFailures";
    private static final VisualizerService instance = new VisualizerService();

    public static VisualizerService getInstance() {
        return instance;
    }

    public void createReports(Collection<Class<? extends ReportDocumentType>> reportDocumentTypes, CombinerContext combinerContext, ReportingContext reportingContext, EnricherContext enricherContext) {
        logger.info("Method createReports started, reportDocumentTypes: '{}'", reportDocumentTypes);
        List<Report> reports = reportingContext.getReportRepository().getReports();
        for (Report report : reports) {
            this.createReport(reportDocumentTypes, report, combinerContext, reportingContext, enricherContext);
        }
    }

    private void createReport(Collection<Class<? extends ReportDocumentType>> reportDocumentTypes, Report report, CombinerContext combinerContext, ReportingContext reportingContext, EnricherContext enricherContext) {
        logger.info("Method createReports started. Report: {}", (Object)report);
        ReportDocumentService reportDocumentService = ReportDocumentService.getInstance();
        List<ReportDocument> reportDocuments = reportDocumentService.getReportDocuments(report, reportingContext);
        NodeFileTreeSet nodeFiles = (NodeFileTreeSet)reportDocumentService.getNodeFiles(reportDocuments);
        ReaderService readerService = ReaderService.getInstance();
        readerService.prepareBufferedReaders(combinerContext, nodeFiles);
        String line = null;
        FilesMergerState filesMergerState = new FilesMergerState();
        filesMergerState.setNodeFiles((Set)nodeFiles);
        LogBufferedReader currentReader = null;
        int currentLineNumber = 0;
        TransformerService transformerService = TransformerService.getInstance();
        try {
            line = readerService.readLineFromReaders(filesMergerState);
            int endIndex = Math.max(line.length(), 35);
            String substring = line.substring(0, endIndex);
            logger.trace("The first line is read from {}. Line: '{}...'", (Object)this.getClass().getSimpleName(), (Object)substring);
            while (line != null) {
                currentReader = filesMergerState.getCurrentNodeFile().getLogBufferedReader();
                List multiLine = readerService.readMultiline(line, currentReader, combinerContext);
                currentLineNumber = this.transformMultiLine(multiLine, reportDocumentTypes, report, reportDocuments, currentReader, currentLineNumber, transformerService, combinerContext, enricherContext);
                reportDocumentService.mergeReportDocumentsForAddition(reportingContext);
                reportDocuments = reportDocumentService.getReportDocuments(report, reportingContext);
                line = readerService.readLineFromReaders(filesMergerState);
            }
            logger.debug("{} lines processed (100%)", (Object)currentLineNumber);
        }
        catch (Exception e) {
            String fileName = "null";
            if (currentReader != null) {
                fileName = readerService.getFile(currentReader).getAbsolutePath();
            }
            String message = "Reports creation failed. File: '" + fileName + "', ReportDirectory: '" + this.getReportDirectoryPath(report) + "', line: '" + line + "'";
            throw new SubstitutionRuntimeException(message, (Throwable)e);
        }
        finally {
            for (ReportDocument reportDocument : reportDocuments) {
                if (reportDocument.getFooterMethod() == null) continue;
                reportDocument.getFooterMethod().accept(reportDocument);
            }
        }
    }

    private int transformMultiLine(List<String> multiLine, Collection<Class<? extends ReportDocumentType>> reportDocumentTypes, Report report, List<ReportDocument> reportDocuments, LogBufferedReader currentReader, int currentLineNumber, TransformerService transformerService, CombinerContext combinerContext, EnricherContext enricherContext) {
        currentLineNumber += multiLine.size();
        try {
            if (report.getLinesNumber() > 0 && currentLineNumber % 100000 == 0) {
                int perCent = (int)((float)currentLineNumber * 100.0f) / report.getLinesNumber();
                logger.debug("{} lines processed ({}%)", (Object)currentLineNumber, (Object)perCent);
            }
            for (ReportDocument reportDocument : reportDocuments) {
                if (!reportDocumentTypes.contains(reportDocument.getReportDocumentType())) continue;
                transformerService.transformToReport((Printable)reportDocument, multiLine, currentReader, combinerContext, enricherContext);
            }
        }
        catch (Exception e) {
            String message = "Reports creation failed. ReportDirectory: '" + this.getReportDirectoryPath(report) + "', line: '" + multiLine.get(0) + "'";
            if ("true".equals(System.getProperty(IGNORE_FAILURES))) {
                logger.error(message);
            }
            throw new SubstitutionRuntimeException(message, (Throwable)e);
        }
        return currentLineNumber;
    }

    private String getReportDirectoryPath(Report report) {
        if (report.getDirectory() != null) {
            return report.getDirectory().getAbsolutePath();
        }
        return null;
    }
}

