/*
 * Decompiled with CFR 0.152.
 */
package com.criteo.slab.lib;

import com.criteo.slab.core.Codec;
import com.criteo.slab.core.Context;
import com.criteo.slab.core.Store;
import com.criteo.slab.lib.InMemoryStore$;
import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.immutable.Nil$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005%g\u0001B\u0001\u0003\u0001-\u0011Q\"\u00138NK6|'/_*u_J,'BA\u0002\u0005\u0003\ra\u0017N\u0019\u0006\u0003\u000b\u0019\tAa\u001d7bE*\u0011q\u0001C\u0001\u0007GJLG/Z8\u000b\u0003%\t1aY8n\u0007\u0001\u00192\u0001\u0001\u0007\u0013!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fMB\u00191C\u0006\r\u000e\u0003QQ!!\u0006\u0003\u0002\t\r|'/Z\u0005\u0003/Q\u0011Qa\u0015;pe\u0016\u0004\"!D\r\n\u0005iq!aA!os\"AA\u0004\u0001BC\u0002\u0013\u0005Q$\u0001\u0006fqBL'/\u001f#bsN,\u0012A\b\t\u0003\u001b}I!\u0001\t\b\u0003\u0007%sG\u000f\u0003\u0005#\u0001\t\u0005\t\u0015!\u0003\u001f\u0003-)\u0007\u0010]5ss\u0012\u000b\u0017p\u001d\u0011\t\u000b\u0011\u0002A\u0011A\u0013\u0002\rqJg.\u001b;?)\t1\u0003\u0006\u0005\u0002(\u00015\t!\u0001C\u0004\u001dGA\u0005\t\u0019\u0001\u0010\t\u000f)\u0002!\u0019!C\u0005W\u00051An\\4hKJ,\u0012\u0001\f\t\u0003[Ij\u0011A\f\u0006\u0003_A\nQa\u001d7gi)T\u0011!M\u0001\u0004_J<\u0017BA\u001a/\u0005\u0019aunZ4fe\"1Q\u0007\u0001Q\u0001\n1\nq\u0001\\8hO\u0016\u0014\b\u0005C\u00048\u0001\t\u0007I\u0011\u0002\u001d\u0002\u000b\r\f7\r[3\u0016\u0003e\u0002BAO B15\t1H\u0003\u0002={\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005yr\u0011AC2pY2,7\r^5p]&\u0011\u0001i\u000f\u0002\b)JLW-T1q!\u0011i!\tR(\n\u0005\rs!A\u0002+va2,'\u0007\u0005\u0002F\u0019:\u0011aI\u0013\t\u0003\u000f:i\u0011\u0001\u0013\u0006\u0003\u0013*\ta\u0001\u0010:p_Rt\u0014BA&\u000f\u0003\u0019\u0001&/\u001a3fM&\u0011QJ\u0014\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005-s\u0001CA\u0007Q\u0013\t\tfB\u0001\u0003M_:<\u0007BB*\u0001A\u0003%\u0011(\u0001\u0004dC\u000eDW\r\t\u0005\b+\u0002\u0011\r\u0011\"\u0003W\u0003%\u00198\r[3ek2,'/F\u0001X!\tAf,D\u0001Z\u0015\ta$L\u0003\u0002\\9\u0006!Q\u000f^5m\u0015\u0005i\u0016\u0001\u00026bm\u0006L!aX-\u00031M\u001b\u0007.\u001a3vY\u0016$W\t_3dkR|'oU3sm&\u001cW\r\u0003\u0004b\u0001\u0001\u0006IaV\u0001\u000bg\u000eDW\rZ;mKJ\u0004\u0003\"B2\u0001\t\u0003\"\u0017AB;qY>\fG-\u0006\u0002fmR)a\r @\u0002\bQ\u0011qm\u001c\t\u0004Q*dW\"A5\u000b\u0005qr\u0011BA6j\u0005\u00191U\u000f^;sKB\u0011Q\"\\\u0005\u0003]:\u0011A!\u00168ji\")\u0001O\u0019a\u0002c\u0006)1m\u001c3fGB!1C\u001d;\u0019\u0013\t\u0019HCA\u0003D_\u0012,7\r\u0005\u0002vm2\u0001A!B<c\u0005\u0004A(!\u0001+\u0012\u0005eD\u0002CA\u0007{\u0013\tYhBA\u0004O_RD\u0017N\\4\t\u000bu\u0014\u0007\u0019\u0001#\u0002\u0005%$\u0007BB@c\u0001\u0004\t\t!A\u0004d_:$X\r\u001f;\u0011\u0007M\t\u0019!C\u0002\u0002\u0006Q\u0011qaQ8oi\u0016DH\u000f\u0003\u0004\u0002\n\t\u0004\r\u0001^\u0001\u0002m\"9\u0011Q\u0002\u0001\u0005B\u0005=\u0011!\u00024fi\u000eDW\u0003BA\t\u0003?!b!a\u0005\u0002&\u0005\u001dB\u0003BA\u000b\u0003C\u0001B\u0001\u001b6\u0002\u0018A)Q\"!\u0007\u0002\u001e%\u0019\u00111\u0004\b\u0003\r=\u0003H/[8o!\r)\u0018q\u0004\u0003\u0007o\u0006-!\u0019\u0001=\t\u000fA\fY\u0001q\u0001\u0002$A)1C]A\u000f1!1Q0a\u0003A\u0002\u0011Cqa`A\u0006\u0001\u0004\t\t\u0001C\u0004\u0002,\u0001!\t%!\f\u0002\u0019\u0019,Go\u00195ISN$xN]=\u0016\t\u0005=\u00121\n\u000b\t\u0003c\t\u0019&!\u0016\u0002fQ!\u00111GA'!\u0011A'.!\u000e\u0011\r\u0005]\u0012\u0011IA$\u001d\u0011\tI$!\u0010\u000f\u0007\u001d\u000bY$C\u0001\u0010\u0013\r\tyDD\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019%!\u0012\u0003\u0007M+\u0017OC\u0002\u0002@9\u0001R!\u0004\"P\u0003\u0013\u00022!^A&\t\u00199\u0018\u0011\u0006b\u0001q\"A\u0011qJA\u0015\u0001\b\t\t&\u0001\u0002fmB)1C]A%1!1Q0!\u000bA\u0002\u0011C\u0001\"a\u0016\u0002*\u0001\u0007\u0011\u0011L\u0001\u0005MJ|W\u000e\u0005\u0003\u0002\\\u0005\u0005TBAA/\u0015\r\ty\u0006X\u0001\u0005i&lW-\u0003\u0003\u0002d\u0005u#aB%ogR\fg\u000e\u001e\u0005\t\u0003O\nI\u00031\u0001\u0002Z\u0005)QO\u001c;jY\"9\u00111\u000e\u0001\u0005\n\u00055\u0014A\u00024pe6\fG\u000f\u0006\u0003\u0002p\u0005e\u0004\u0003BA9\u0003oj!!a\u001d\u000b\u0007\u0005UD,\u0001\u0003mC:<\u0017bA'\u0002t!A\u00111PA5\u0001\u0004\tI&A\u0001j\u000f\u001d\tyH\u0001E\u0001\u0003\u0003\u000bQ\"\u00138NK6|'/_*u_J,\u0007cA\u0014\u0002\u0004\u001a1\u0011A\u0001E\u0001\u0003\u000b\u001b2!a!\r\u0011\u001d!\u00131\u0011C\u0001\u0003\u0013#\"!!!\t\u000fA\f\u0019\tb\u0001\u0002\u000eV!\u0011qRAN+\t\t\tJE\u0003\u0002\u00142\t9JB\u0004\u0002\u0016\u0006-\u0005!!%\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \u0011\u000bM\u0011\u0018\u0011\u0014\r\u0011\u0007U\fY\n\u0002\u0004x\u0003\u0017\u0013\r\u0001\u001f\u0005\t\u0003?\u000b\u0019\t\"\u0001\u0002\"\u0006i1M]3bi\u0016\u001cE.Z1oKJ$\u0002\"a)\u0002*\u0006-\u0016Q\u0016\t\u0005\u0003c\n)+\u0003\u0003\u0002(\u0006M$\u0001\u0003*v]:\f'\r\\3\t\r]\ni\n1\u0001:\u0011\u0019a\u0012Q\u0014a\u0001=!1!&!(A\u00021B!\"!-\u0002\u0004F\u0005I\u0011AAZ\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u0017\u0016\u0004=\u0005]6FAA]!\u0011\tY,!2\u000e\u0005\u0005u&\u0002BA`\u0003\u0003\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\rg\"\u0001\u0006b]:|G/\u0019;j_:LA!a2\u0002>\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class InMemoryStore
implements Store<Object> {
    private final int expiryDays;
    private final Logger logger;
    private final TrieMap<Tuple2<String, Object>, Object> cache;
    private final ScheduledExecutorService scheduler;

    public static int $lessinit$greater$default$1() {
        return InMemoryStore$.MODULE$.$lessinit$greater$default$1();
    }

    public static Runnable createCleaner(TrieMap<Tuple2<String, Object>, Object> trieMap, int n, Logger logger) {
        return InMemoryStore$.MODULE$.createCleaner(trieMap, n, logger);
    }

    public static <T> Codec<T, Object> codec() {
        return InMemoryStore$.MODULE$.codec();
    }

    public int expiryDays() {
        return this.expiryDays;
    }

    private Logger logger() {
        return this.logger;
    }

    private TrieMap<Tuple2<String, Object>, Object> cache() {
        return this.cache;
    }

    private ScheduledExecutorService scheduler() {
        return this.scheduler;
    }

    @Override
    public <T> Future<BoxedUnit> upload(String id, Context context, T v, Codec<T, Object> codec) {
        this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Uploading ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id})));
        this.cache().putIfAbsent((Object)new Tuple2((Object)id, (Object)BoxesRunTime.boxToLong((long)context.when().toEpochMilli())), codec.encode(v));
        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Store updated, size: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.cache().size())})));
        return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
    }

    @Override
    public <T> Future<Option<T>> fetch(String id, Context context, Codec<T, Object> codec) {
        this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Fetching ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id})));
        return Future$.MODULE$.successful((Object)this.cache().get((Object)new Tuple2((Object)id, (Object)BoxesRunTime.boxToLong((long)context.when().toEpochMilli()))).map((Function1 & Serializable & scala.Serializable)v -> codec.decode(v).get()));
    }

    @Override
    public <T> Future<Seq<Tuple2<Object, T>>> fetchHistory(String id, Instant from, Instant until, Codec<T, Object> ev) {
        this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Fetching the history of ", " from ", " until ", ", cache size: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id, this.format(from), this.format(until), BoxesRunTime.boxToInteger((int)this.cache().size())})));
        return Future$.MODULE$.successful((Object)((TraversableOnce)this.cache().withFilter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)InMemoryStore.$anonfun$fetchHistory$1(id, from, until, x0$1))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Object repr;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = x0$2;
                    if (tuple22 == null) break block2;
                    tuple2 = (Tuple2)tuple22._1();
                    repr = tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            long ts = tuple2._2$mcJ$sp();
            Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToLong((long)ts), ev.decode(repr).get());
            return tuple23;
        }, TrieMap$.MODULE$.canBuildFrom())).toList());
    }

    private String format(Instant i) {
        return DateTimeFormatter.ofLocalizedDateTime(FormatStyle.FULL).withZone(ZoneId.systemDefault()).format(i);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$fetchHistory$1(String id$1, Instant from$1, Instant until$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Tuple2 tuple22 = (Tuple2)tuple2._1();
        if (tuple22 == null) throw new MatchError((Object)tuple2);
        String _id = (String)tuple22._1();
        long ts = tuple22._2$mcJ$sp();
        String string = _id;
        String string2 = id$1;
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (ts < from$1.toEpochMilli()) return false;
        if (ts > until$1.toEpochMilli()) return false;
        return true;
    }

    public InMemoryStore(int expiryDays) {
        this.expiryDays = expiryDays;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.cache = TrieMap$.MODULE$.empty();
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        this.scheduler().scheduleAtFixedRate(InMemoryStore$.MODULE$.createCleaner(this.cache(), expiryDays, this.logger()), 1L, 1L, TimeUnit.HOURS);
        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"InMemoryStore started, entries expire in ", " days"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)expiryDays)})));
        package$.MODULE$.addShutdownHook((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Shutting down..."})).s((Seq)Nil$.MODULE$));
            this.scheduler().shutdown();
        });
    }
}

