/*
 * Decompiled with CFR 0.152.
 */
package com.criteo.slab.utils;

import com.criteo.slab.utils.HttpUtils;
import java.io.Serializable;
import java.net.URL;
import java.net.URLEncoder;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import lol.http.Client;
import lol.http.Client$;
import lol.http.ClientOptions;
import lol.http.ContentDecoder;
import lol.http.ContentDecoder$;
import lol.http.HttpString;
import lol.http.Request;
import lol.http.Response;
import lol.http.SSL;
import lol.http.package$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class HttpUtils$ {
    public static HttpUtils$ MODULE$;
    private final Logger com$criteo$slab$utils$HttpUtils$$logger;

    static {
        new HttpUtils$();
    }

    public Logger com$criteo$slab$utils$HttpUtils$$logger() {
        return this.com$criteo$slab$utils$HttpUtils$$logger;
    }

    public <A> Future<A> get(URL url, Map<HttpString, HttpString> headers, FiniteDuration timeout, ContentDecoder<A> evidence$1, ExecutionContext ec) {
        Map defaultHeaders = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new HttpString("Host")), (Object)new HttpString(url.getHost()))}));
        String path = url.getPath() + Option$.MODULE$.apply((Object)url.getQuery()).map((Function1 & Serializable & scala.Serializable)x$1 -> "?" + x$1).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        int port = url.getPort() > 0 ? url.getPort() : url.getDefaultPort();
        Request request = package$.MODULE$.Get(path).addHeaders(defaultHeaders.$plus$plus(headers));
        String fullURL = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "://", ":", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url.getProtocol(), url.getHost(), BoxesRunTime.boxToInteger((int)port), path}));
        this.com$criteo$slab$utils$HttpUtils$$logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Requesting ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fullURL})));
        Instant start = Instant.now();
        return Client$.MODULE$.apply(url.getHost(), port, url.getProtocol(), Client$.MODULE$.apply$default$4(), Client$.MODULE$.apply$default$5(), Client$.MODULE$.apply$default$6(), ec).runAndStop((Function1 & Serializable & scala.Serializable)client -> {
            Request x$2 = request;
            FiniteDuration x$3 = timeout;
            boolean x$4 = client.run$default$2();
            Function1 & Serializable & scala.Serializable x$5 = (Function1 & Serializable & scala.Serializable)res -> {
                this.com$criteo$slab$utils$HttpUtils$$logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Response from ", ", status: ", ", ", "ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fullURL, BoxesRunTime.boxToInteger((int)res.status()), BoxesRunTime.boxToLong((long)(Instant.now().toEpochMilli() - start.toEpochMilli()))})));
                return this.com$criteo$slab$utils$HttpUtils$$handleResponse((Response)res, fullURL, evidence$1, ec);
            };
            return client.run(x$2, x$4, x$3, (Function1)x$5).recoverWith(this.com$criteo$slab$utils$HttpUtils$$handleError(fullURL, ec), ec);
        });
    }

    public <A> Map<HttpString, HttpString> get$default$2() {
        return Predef$.MODULE$.Map().empty();
    }

    public <A> FiniteDuration get$default$3() {
        return Duration$.MODULE$.create(60L, TimeUnit.SECONDS);
    }

    public HttpUtils.SafeHTTPGet makeGet(URL url, int maxConnections, ExecutionContext ec) {
        int port = url.getPort() > 0 ? url.getPort() : url.getDefaultPort();
        String x$6 = url.getHost();
        int x$7 = port;
        String x$8 = url.getProtocol();
        int x$9 = 10;
        SSL.ClientConfiguration x$10 = Client$.MODULE$.apply$default$4();
        ClientOptions x$11 = Client$.MODULE$.apply$default$5();
        Client client = Client$.MODULE$.apply(x$6, x$7, x$8, x$10, x$11, x$9, ec);
        return new HttpUtils.SafeHTTPGet(client, (Map<HttpString, HttpString>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new HttpString("Host")), (Object)new HttpString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url.getHost(), BoxesRunTime.boxToInteger((int)port)}))))}))), ec);
    }

    public int makeGet$default$2() {
        return 10;
    }

    public String makeQuery(Map<String, String> queries) {
        return "?" + ((TraversableOnce)queries.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            String string = this.encodeURI(key) + "=" + this.encodeURI(value);
            return string;
        }, Iterable$.MODULE$.canBuildFrom())).mkString("&");
    }

    private String encodeURI(String in) {
        return URLEncoder.encode(in, "UTF-8").replace("+", "%20");
    }

    public <A> Future<A> com$criteo$slab$utils$HttpUtils$$handleResponse(Response res, String url, ContentDecoder<A> evidence$2, ExecutionContext ec) {
        return res.status() < 400 ? res.readAs(evidence$2) : res.readAs(ContentDecoder$.MODULE$.defaultText()).recoverWith((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                HttpUtils$.MODULE$.com$criteo$slab$utils$HttpUtils$$logger().error(A1.getMessage(), A1);
                Future future = Future$.MODULE$.successful((Object)"Unable to get the message");
                return (B1)future;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
        }, ec).flatMap((Function1 & Serializable & scala.Serializable)message -> {
            this.com$criteo$slab$utils$HttpUtils$$logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Request to ", " has failed, status: ", ", message: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url, BoxesRunTime.boxToInteger((int)res.status()), message})));
            return Future$.MODULE$.failed((Throwable)new HttpUtils.FailedRequestException(res));
        }, ec);
    }

    public <A> PartialFunction<Throwable, Future<A>> com$criteo$slab$utils$HttpUtils$$handleError(String url, ExecutionContext ec) {
        return new scala.Serializable(url){
            public static final long serialVersionUID = 0L;
            private final String url$2;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof HttpUtils.FailedRequestException) {
                    HttpUtils.FailedRequestException failedRequestException = (HttpUtils.FailedRequestException)A1;
                    object = Future$.MODULE$.failed((Throwable)failedRequestException);
                } else {
                    Option option = NonFatal$.MODULE$.unapply(A1);
                    if (!option.isEmpty()) {
                        Throwable e = (Throwable)option.get();
                        HttpUtils$.MODULE$.com$criteo$slab$utils$HttpUtils$$logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error when requesting ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.url$2, e.getMessage()})), e);
                        object = Future$.MODULE$.failed(e);
                    } else {
                        object = function1.apply(x2);
                    }
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x2) {
                Option option;
                Throwable throwable = x2;
                boolean bl = throwable instanceof HttpUtils.FailedRequestException ? true : !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty();
                return bl;
            }
            {
                this.url$2 = url$2;
            }
        };
    }

    private HttpUtils$() {
        MODULE$ = this;
        this.com$criteo$slab$utils$HttpUtils$$logger = LoggerFactory.getLogger(this.getClass());
    }
}

