/*
 * Decompiled with CFR 0.152.
 */
package com.crittercism.app;

import android.content.Context;
import crittercism.android.di;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class CrittercismNDK {
    private static boolean isNdkInstalled = false;
    private static final String LIBNAME = "libcrittercism-ndk.so";
    private static final int LIBRARY_VERSION = 2;

    public static native boolean installNdk(String var0);

    public static native boolean checkLibraryVersion(int var0);

    public static File getInstalledLibraryFile(Context c2) {
        Object object;
        object = object.getFilesDir().getAbsolutePath() + "/com.crittercism/lib/";
        return new File((String)object + LIBNAME);
    }

    public static void installNdkLib(Context context, String nativeDumpPath) {
        boolean bl2;
        String string;
        string = context.getFilesDir().getAbsolutePath() + "/" + string;
        if (CrittercismNDK.doNdkSharedLibrariesExist(context)) {
            Context context2;
            bl2 = CrittercismNDK.loadLibraryFromAssets(context2);
        } else {
            try {
                System.loadLibrary("crittercism-ndk");
                bl2 = true;
            }
            catch (Throwable throwable) {
                bl2 = false;
            }
        }
        if (!bl2) {
            return;
        }
        try {
            if (CrittercismNDK.installNdk(string)) {
                File file = new File(string);
                file.getAbsolutePath();
                di.b();
                file.mkdirs();
                di.b();
                isNdkInstalled = true;
                return;
            }
            di.b();
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public static boolean loadLibraryFromAssets(Context context) {
        boolean bl2 = false;
        File file = CrittercismNDK.getInstalledLibraryFile(context);
        if (!CrittercismNDK.copyLibFromAssets(context, file)) {
            return false;
        }
        try {
            System.load(file.getAbsolutePath());
            bl2 = CrittercismNDK.checkLibraryVersion(2);
        }
        catch (Throwable throwable) {}
        if (!bl2) {
            Context context2;
            if (!CrittercismNDK.copyLibFromAssets(context2, file)) {
                return false;
            }
            try {
                System.load(file.getAbsolutePath());
            }
            catch (Throwable throwable) {
                di.b("Crittercism", "Unable to load breakpad" + throwable.toString());
                return false;
            }
        }
        return true;
    }

    public static boolean doNdkSharedLibrariesExist(Context context) {
        boolean bl2 = false;
        try {
            Context context2;
            CrittercismNDK.getJarredLibFileStream(context2);
            bl2 = true;
        }
        catch (IOException iOException) {}
        return bl2;
    }

    public static InputStream getJarredLibFileStream(Context context) {
        Context context2;
        String string = "armeabi";
        if (System.getProperty("os.arch").contains("v7")) {
            string = string + "-v7a";
        }
        return context2.getAssets().open(string + "/libcrittercism-ndk.so");
    }

    public static boolean copyLibFromAssets(Context context, File installedLibFile) {
        if (installedLibFile.exists()) {
            return true;
        }
        di.b();
        try {
            InputStream inputStream;
            FileOutputStream fileOutputStream;
            installedLibFile.getParentFile().mkdirs();
            fileOutputStream = new FileOutputStream((File)((Object)fileOutputStream));
            inputStream = CrittercismNDK.getJarredLibFileStream((Context)inputStream);
            int n2 = 0;
            byte[] byArray = new byte[8192];
            while ((n2 = inputStream.read(byArray)) >= 0) {
                fileOutputStream.write(byArray, 0, n2);
            }
            inputStream.close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            di.b("Crittercism", "Could not install breakpad library: " + exception.toString());
            return false;
        }
        return true;
    }

    public static boolean isNdkCrashReportingInstalled() {
        return isNdkInstalled;
    }
}

