/*
 * Decompiled with CFR 0.152.
 */
package com.crittercism.app;

import android.content.Context;
import crittercism.android.dy;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class CrittercismNDK {
    private static boolean isNdkInstalled = false;
    private static final String LIBRARY_NAME = "crittercism-v3";
    private static final String SO_FILE_NAME = "libcrittercism-v3.so";
    private static final String LEGACY_SO_FILE_NAME = "libcrittercism-ndk.so";

    public static native boolean installNdk(String var0);

    public static File getInstalledLibraryFile(Context c2) {
        Object object;
        object = object.getFilesDir().getAbsolutePath() + "/com.crittercism/lib/";
        return new File((String)object + SO_FILE_NAME);
    }

    public static void installNdkLib(Context context, String nativeDumpPath) {
        boolean bl2;
        String string;
        string = context.getFilesDir().getAbsolutePath() + "/" + string;
        if (CrittercismNDK.doNdkSharedLibrariesExist(context)) {
            Context context2;
            bl2 = CrittercismNDK.loadLibraryFromAssets(context2);
        } else {
            try {
                System.loadLibrary(LIBRARY_NAME);
                bl2 = true;
            }
            catch (Throwable throwable) {
                bl2 = false;
            }
        }
        if (!bl2) {
            return;
        }
        try {
            if (CrittercismNDK.installNdk(string)) {
                new File(string).mkdirs();
                isNdkInstalled = true;
                return;
            }
            dy.c("Unable to initialize NDK crash reporting.");
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public static boolean loadLibraryFromAssets(Context context) {
        File file = new File(context.getFilesDir(), "/com.crittercism/lib/");
        File file2 = new File(file, SO_FILE_NAME);
        file = new File(file, LEGACY_SO_FILE_NAME);
        if (!file2.exists()) {
            Context context2;
            if (!CrittercismNDK.copyLibFromAssets(context2, file2)) {
                file2.delete();
                return false;
            }
            file.delete();
        }
        boolean bl2 = false;
        try {
            System.load(file2.getAbsolutePath());
            bl2 = true;
        }
        catch (Throwable throwable) {
            dy.a("Unable to install NDK library", throwable);
            file2.delete();
        }
        return bl2;
    }

    public static boolean doNdkSharedLibrariesExist(Context context) {
        boolean bl2 = false;
        try {
            Context context2;
            CrittercismNDK.getJarredLibFileStream(context2);
            bl2 = true;
        }
        catch (IOException iOException) {}
        return bl2;
    }

    public static InputStream getJarredLibFileStream(Context context) {
        Context context2;
        String string = "armeabi";
        if (System.getProperty("os.arch").contains("v7")) {
            string = string + "-v7a";
        }
        return context2.getAssets().open(string + "/libcrittercism-v3.so");
    }

    public static boolean copyLibFromAssets(Context context, File installedLibFile) {
        dy.b();
        try {
            InputStream inputStream;
            FileOutputStream fileOutputStream;
            installedLibFile.getParentFile().mkdirs();
            fileOutputStream = new FileOutputStream((File)((Object)fileOutputStream));
            inputStream = CrittercismNDK.getJarredLibFileStream((Context)inputStream);
            int n2 = 0;
            byte[] byArray = new byte[8192];
            while ((n2 = inputStream.read(byArray)) >= 0) {
                fileOutputStream.write(byArray, 0, n2);
            }
            inputStream.close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            dy.b("Could not install breakpad library: " + exception.toString());
            return false;
        }
        return true;
    }

    public static boolean isNdkCrashReportingInstalled() {
        return isNdkInstalled;
    }
}

