/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.mockito;

import com.android.dx.mockito.InvocationHandlerAdapter;
import com.android.dx.mockito.UnsafeAllocator;
import com.android.dx.stock.ProxyBuilder;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Set;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.exceptions.stacktrace.StackTraceCleaner;
import org.mockito.invocation.MockHandler;
import org.mockito.mock.MockCreationSettings;
import org.mockito.plugins.MockMaker;
import org.mockito.plugins.StackTraceCleanerProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DexmakerMockMaker
implements MockMaker,
StackTraceCleanerProvider {
    private final UnsafeAllocator unsafeAllocator = UnsafeAllocator.create();

    public <T> T createMock(MockCreationSettings<T> settings, MockHandler handler) {
        Class typeToMock = settings.getTypeToMock();
        Set interfacesSet = settings.getExtraInterfaces();
        Class[] extraInterfaces = interfacesSet.toArray(new Class[interfacesSet.size()]);
        InvocationHandlerAdapter invocationHandler = new InvocationHandlerAdapter(handler);
        if (typeToMock.isInterface()) {
            Class[] classesToMock = new Class[extraInterfaces.length + 1];
            classesToMock[0] = typeToMock;
            System.arraycopy(extraInterfaces, 0, classesToMock, 1, extraInterfaces.length);
            Object mock = Proxy.newProxyInstance(typeToMock.getClassLoader(), classesToMock, (InvocationHandler)invocationHandler);
            return (T)mock;
        }
        try {
            Class proxyClass = ProxyBuilder.forClass((Class)typeToMock).implementing(extraInterfaces).buildProxyClass();
            Object mock = this.unsafeAllocator.newInstance(proxyClass);
            ProxyBuilder.setInvocationHandler(mock, (InvocationHandler)invocationHandler);
            return mock;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MockitoException("Failed to mock " + typeToMock, (Throwable)e);
        }
    }

    public void resetMock(Object mock, MockHandler newHandler, MockCreationSettings settings) {
        InvocationHandlerAdapter adapter = this.getInvocationHandlerAdapter(mock);
        adapter.setHandler(newHandler);
    }

    public MockHandler getHandler(Object mock) {
        InvocationHandlerAdapter adapter = this.getInvocationHandlerAdapter(mock);
        return adapter != null ? adapter.getHandler() : null;
    }

    private InvocationHandlerAdapter getInvocationHandlerAdapter(Object mock) {
        if (Proxy.isProxyClass(mock.getClass())) {
            InvocationHandler invocationHandler = Proxy.getInvocationHandler(mock);
            return invocationHandler instanceof InvocationHandlerAdapter ? (InvocationHandlerAdapter)invocationHandler : null;
        }
        if (ProxyBuilder.isProxyClass(mock.getClass())) {
            InvocationHandler invocationHandler = ProxyBuilder.getInvocationHandler((Object)mock);
            return invocationHandler instanceof InvocationHandlerAdapter ? (InvocationHandlerAdapter)invocationHandler : null;
        }
        return null;
    }

    public StackTraceCleaner getStackTraceCleaner(final StackTraceCleaner defaultCleaner) {
        return new StackTraceCleaner(){

            public boolean isOut(StackTraceElement candidate) {
                return defaultCleaner.isOut(candidate) || candidate.getClassName().endsWith("_Proxy") || candidate.getClassName().startsWith("$Proxy") || candidate.getClassName().startsWith("com.google.dexmaker.mockito.");
            }
        };
    }
}

