/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.mockito;

import com.android.dx.stock.ProxyBuilder;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.mockito.internal.invocation.InvocationImpl;
import org.mockito.internal.invocation.MockitoMethod;
import org.mockito.internal.invocation.realmethod.RealMethod;
import org.mockito.internal.progress.SequenceNumber;
import org.mockito.internal.util.ObjectMethodsGuru;
import org.mockito.invocation.Invocation;
import org.mockito.invocation.MockHandler;

final class InvocationHandlerAdapter
implements InvocationHandler {
    private MockHandler handler;
    private final ObjectMethodsGuru objectMethodsGuru = new ObjectMethodsGuru();

    public InvocationHandlerAdapter(MockHandler handler) {
        this.handler = handler;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.objectMethodsGuru.isEqualsMethod(method)) {
            return proxy == args[0];
        }
        if (this.objectMethodsGuru.isHashCodeMethod(method)) {
            return System.identityHashCode(proxy);
        }
        ProxiedMethod proxiedMethod = new ProxiedMethod(method);
        return this.handler.handle((Invocation)new InvocationImpl(proxy, (MockitoMethod)proxiedMethod, args, SequenceNumber.next(), (RealMethod)proxiedMethod));
    }

    public MockHandler getHandler() {
        return this.handler;
    }

    public void setHandler(MockHandler handler) {
        this.handler = handler;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProxiedMethod
    implements MockitoMethod,
    RealMethod {
        private final Method method;

        public ProxiedMethod(Method method) {
            this.method = method;
        }

        public String getName() {
            return this.method.getName();
        }

        public Class<?> getReturnType() {
            return this.method.getReturnType();
        }

        public Class<?>[] getParameterTypes() {
            return this.method.getParameterTypes();
        }

        public Class<?>[] getExceptionTypes() {
            return this.method.getExceptionTypes();
        }

        public boolean isVarArgs() {
            return this.method.isVarArgs();
        }

        public Method getJavaMethod() {
            return this.method;
        }

        public Object invoke(Object target, Object[] arguments) throws Throwable {
            return ProxyBuilder.callSuper((Object)target, (Method)this.method, (Object[])arguments);
        }

        public boolean isAbstract() {
            return Modifier.isAbstract(this.method.getModifiers());
        }
    }
}

