/*
 * Decompiled with CFR 0.152.
 */
package com.crivano.jflow;

import com.crivano.jflow.Dao;
import com.crivano.jflow.Engine;
import com.crivano.jflow.Handler;
import com.crivano.jflow.PausableTask;
import com.crivano.jflow.Task;
import com.crivano.jflow.TaskResult;
import com.crivano.jflow.model.ProcessDefinition;
import com.crivano.jflow.model.ProcessInstance;
import com.crivano.jflow.model.Responsible;
import com.crivano.jflow.model.ResponsibleKind;
import com.crivano.jflow.model.TaskDefinition;
import com.crivano.jflow.model.TaskDefinitionDetour;
import com.crivano.jflow.model.TaskDefinitionVariable;
import com.crivano.jflow.model.TaskKind;
import com.crivano.jflow.model.enm.ProcessInstanceStatus;
import com.crivano.jflow.model.enm.TaskResultKind;
import java.util.List;
import java.util.Map;

public class EngineImpl<PD extends ProcessDefinition<TD>, TD extends TaskDefinition<TK, RK, DV, DD>, R extends Responsible, TK extends TaskKind, RK extends ResponsibleKind, DV extends TaskDefinitionVariable, DD extends TaskDefinitionDetour, PI extends ProcessInstance<PD, TD, R>, H extends Handler<PI, R>, D extends Dao<PI>>
implements Engine<PI, R, H> {
    private D dao;
    private H handler;

    public EngineImpl(D dao, H handler) {
        this.setDao(dao);
        this.setHandler(handler);
    }

    @Override
    public void start(PI pi) throws Exception {
        pi.start();
        TaskResult r = new TaskResult(TaskResultKind.DONE, null, null, null, null);
        this.resume(pi, r);
    }

    @Override
    public int resume(String event, Integer detourIndex, Map<String, Object> param) throws Exception {
        List l = this.getDao().listByEvent(event);
        if (l == null || l.size() == 0) {
            return 0;
        }
        int i = 0;
        for (ProcessInstance pi : l) {
            PausableTask ti;
            TaskResult r;
            if (pi.getStatus() != ProcessInstanceStatus.PAUSED || pi.getIdEvent() == null || !pi.getIdEvent().startsWith(event)) continue;
            Object td = pi.getCurrentTaskDefinition();
            Class<? extends Task> clazz = td.getKind().getClazz();
            if (td == null || !PausableTask.class.isAssignableFrom(clazz) || (r = (ti = (PausableTask)clazz.newInstance()).resume(td, pi, detourIndex, param, this)) == null) continue;
            this.resume(pi, r);
            ++i;
        }
        return i;
    }

    public TaskResult resume(PI pi, TaskResult result) throws Exception {
        switch (result.getKind()) {
            case ERROR: {
                Object td = pi.getCurrentTaskDefinition();
                if (result.getError() != null) {
                    throw new Exception("error processing task " + td.toString(), result.getError());
                }
                throw new Exception("error processing task " + td.toString());
            }
            case PAUSE: {
                Object td = pi.getCurrentTaskDefinition();
                if (result.getEvent() == null) {
                    throw new Exception("error processing task " + td.toString() + ", when 'PAUSE' is returned, an 'event' must be specified.");
                }
                pi.pause(result.getEvent(), (Responsible)result.getResponsible());
                if (this.getDao() != null) {
                    this.getDao().persist(pi);
                }
                if (this.getHandler() == null) break;
                this.getHandler().afterPause(pi, result);
                break;
            }
            case DONE: {
                pi.resume();
                Integer from = pi.getCurrentIndex() >= 0 ? pi.getCurrentIndex() : null;
                int to = pi.getCurrentIndex() + 1;
                if (result.getDetour() != null && result.getDetour().length() > 0) {
                    to = pi.getIndexById(result.getDetour());
                } else if (pi.getCurrentTaskDefinition() != null && pi.getCurrentTaskDefinition().getAfter() != null) {
                    to = pi.getIndexById(pi.getCurrentTaskDefinition().getAfter());
                }
                if (to >= pi.getProcessDefinition().getTaskDefinition().size()) {
                    pi.end();
                    if (this.getDao() != null) {
                        this.getDao().persist(pi);
                    }
                    if (this.getHandler() == null) break;
                    this.getHandler().afterTransition(pi, from, pi.getCurrentIndex());
                    break;
                }
                this.execute(pi, from, to);
            }
        }
        return result;
    }

    @Override
    public TaskResult resume(PI pi) throws Exception {
        if (pi.getStatus() != ProcessInstanceStatus.RESUMING) {
            return null;
        }
        Object td = pi.getCurrentTaskDefinition();
        Class<? extends Task> clazz = td.getKind().getClazz();
        Task ti = clazz.newInstance();
        TaskResult r = ti.execute(td, pi, this);
        return this.resume(pi, r);
    }

    @Override
    public TaskResult execute(PI pi, Integer from, int to) throws Exception {
        pi.resume();
        pi.setCurrentIndex(to);
        Object td = pi.getCurrentTaskDefinition();
        if (this.getDao() != null) {
            this.getDao().persist(pi);
        }
        if (this.getHandler() != null) {
            this.getHandler().afterTransition(pi, from, pi.getCurrentIndex());
        }
        Task ti = td.getKind().getClazz().newInstance();
        Object tdTo = pi.getTaskDefinitionByIndex(to);
        TaskResult trTo = ti.execute(tdTo, pi, this);
        return this.resume(pi, trTo);
    }

    @Override
    public H getHandler() {
        return this.handler;
    }

    public void setHandler(H handler) {
        this.handler = handler;
    }

    public D getDao() {
        return this.dao;
    }

    public void setDao(D dao) {
        this.dao = dao;
    }
}

