/*
 * Decompiled with CFR 0.152.
 */
package com.crivano.jflow;

import com.crivano.jflow.model.ProcessDefinition;
import com.crivano.jflow.model.ProcessInstance;
import com.crivano.jflow.model.TaskDefinition;
import com.crivano.jflow.model.TaskDefinitionDetour;
import com.crivano.jflow.support.DetourSupport;
import com.crivano.jflow.support.TaskDefinitionSupport;
import java.util.ArrayList;

public class GraphViz {
    private static String graphElement(String shape, String color, TaskDefinition n, String resp, String tooltip) {
        String s = "\"" + n.getIdentifier() + "\"" + (tooltip != null ? "[tooltip=\"" + tooltip + "\"]" : "") + "[shape=\"" + shape + "\"][color=\"" + color + "\"][fontcolor=\"" + color + "\"][label=<" + (n != null && n.getKind() != null && n.getKind().getGraphTitle() != null ? "<font point-size=\"10pt\">" + n.getKind().getGraphTitle() + "</font><br/>" : "") + n.getTitle() + (resp != null ? "<br/><font point-size=\"10pt\">" + resp + "</font>" : "") + ">];";
        if (n != null && n.getKind() != null && n.getKind().getGraphTitle() != null && "rectangle".equals(shape)) {
            shape = "plaintext";
            s = "\"" + n.getIdentifier() + "\"" + (tooltip != null ? "[tooltip=\"" + tooltip + "\"]" : "") + "[shape=\"" + shape + "\"][color=\"" + color + "\"][fontcolor=\"" + color + "\"][label=<<TABLE BORDER=\"0\" CELLBORDER=\"1\" CELLSPACING=\"0\">" + (n != null && n.getKind() != null && n.getKind().getGraphTitle() != null ? "<TR><TD><font point-size=\"10pt\">" + n.getKind().getGraphTitle() + "</font></TD></TR>" : "") + "<TR><TD CELLSPACING=\"0\">" + n.getTitle() + "" + (resp != null ? "<br/><font point-size=\"10pt\">" + resp + "</font>" : "") + "</TD></TR></TABLE>>];";
        }
        if (n.getKind() != null || n.getIdentifier().equals("start")) {
            if (n.getDetour() != null && n.getDetour().size() > 0) {
                for (TaskDefinitionDetour dd : n.getDetour()) {
                    s = dd.getTaskIdentifier() != null && dd.getTaskIdentifier().length() > 0 ? s + "\"" + n.getIdentifier() + "\"->\"" + dd.getTaskIdentifier() + "\"" : (n.getAfter() != null ? s + "\"" + n.getIdentifier() + "\"->\"" + n.getAfter() + "\"" : s + "\"" + n.getIdentifier() + "\"->\"finish\"");
                    if (dd.getTitle() != null && dd.getTitle().trim().length() != 0) {
                        s = s + " [label=\"" + dd.getTitle() + "\"]";
                    }
                    s = s + ";";
                }
            } else {
                s = n.getAfter() != null ? s + "\"" + n.getIdentifier() + "\"->\"" + n.getAfter() + "\";" : s + "\"" + n.getIdentifier() + "\"->\"finish\";";
            }
        }
        return s;
    }

    public static String getDot(ProcessInstance pi, String labelStart, String labelFinish) {
        Object wf = pi.getProcessDefinition();
        String s = "";
        if (wf.getTaskDefinition() != null && wf.getTaskDefinition().size() > 0) {
            ArrayList<DetourSupport> desvios = new ArrayList<DetourSupport>();
            desvios.add(new DetourSupport(null, ((TaskDefinition)wf.getTaskDefinition().get(0)).getIdentifier(), null));
            s = s + GraphViz.graphElement("oval", "black", new TaskDefinitionSupport("start", null, labelStart, null, null, null, desvios, null, null){}, null, null);
            s = s + GraphViz.graphElement("oval", pi.getCurrentIndex() == null ? "blue" : "black", new TaskDefinitionSupport("finish", null, labelFinish, null, null, null, null, null, null), null, null);
            for (int i = 0; i < wf.getTaskDefinition().size(); ++i) {
                TaskDefinition n = (TaskDefinition)wf.getTaskDefinition().get(i);
                Object responsible = pi.calcResponsible(n);
                String resp = responsible != null ? responsible.getInitials() : null;
                String tooltip = responsible != null ? responsible.getTooltip() : null;
                s = s + GraphViz.graphElement(n.getKind().getGraphKind(), pi.getCurrentIndex() != null && pi.getCurrentIndex() == i ? "blue" : "black", n, resp, tooltip);
            }
        }
        return s;
    }

    public static String getDot(ProcessDefinition wf, String labelStart, String labelFinish) {
        String s = "";
        if (wf.getTaskDefinition() != null && wf.getTaskDefinition().size() > 0) {
            ArrayList<DetourSupport> desvios = new ArrayList<DetourSupport>();
            desvios.add(new DetourSupport(null, ((TaskDefinition)wf.getTaskDefinition().get(0)).getIdentifier(), null));
            s = s + GraphViz.graphElement("oval", "black", new TaskDefinitionSupport("start", null, labelStart, null, null, null, desvios, null, null){}, null, null);
            s = s + GraphViz.graphElement("oval", "black", new TaskDefinitionSupport("finish", null, labelFinish, null, null, null, null, null, null), null, null);
            for (int i = 0; i < wf.getTaskDefinition().size(); ++i) {
                TaskDefinition n = (TaskDefinition)wf.getTaskDefinition().get(i);
                s = s + GraphViz.graphElement(n.getKind().getGraphKind(), "black", n, n.getResponsibleDescription(), n.getTooltip());
            }
        }
        return s;
    }
}

