/*
 * Decompiled with CFR 0.152.
 */
package com.crivano.jflow.support;

import com.crivano.jflow.model.ProcessInstance;
import com.crivano.jflow.model.TaskDefinition;
import com.crivano.jflow.model.enm.ProcessInstanceStatus;
import com.crivano.jflow.support.ProcessDefinitionSupport;
import com.crivano.jflow.support.ProcessInstanceVariableSupport;
import com.crivano.jflow.support.ResponsibleSupport;
import com.crivano.jflow.support.TaskDefinitionSupport;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class ProcessInstanceSupport
implements ProcessInstance<ProcessDefinitionSupport, TaskDefinitionSupport, ResponsibleSupport> {
    private String codigo;
    private ProcessDefinitionSupport definicao;
    private Integer indiceCorrente = null;
    private Map<String, Object> variavel = new TreeMap<String, Object>();
    private List<ProcessInstanceVariableSupport> listaDeVariaveis = new ArrayList<ProcessInstanceVariableSupport>();
    private ProcessInstanceStatus status = ProcessInstanceStatus.INACTIVE;
    private Date dtEvento;
    private String evento;
    ResponsibleSupport responsavel;

    public ProcessInstanceSupport(ProcessDefinitionSupport definicao, Map<String, Object> variavel) {
        this.definicao = definicao;
        if (variavel != null) {
            this.variavel.putAll(variavel);
        }
    }

    @Override
    public void start() {
        this.indiceCorrente = -1;
        this.status = ProcessInstanceStatus.STARTED;
    }

    @Override
    public void pause(String evento, ResponsibleSupport responsavel) {
        this.evento = evento;
        this.responsavel = responsavel;
        this.dtEvento = new Date();
        this.status = ProcessInstanceStatus.PAUSED;
    }

    @Override
    public void resume() {
        this.evento = null;
        this.responsavel = null;
        this.dtEvento = null;
        this.status = ProcessInstanceStatus.RESUMING;
    }

    @Override
    public void end() {
        this.indiceCorrente = null;
        this.status = ProcessInstanceStatus.FINISHED;
    }

    @Override
    public TaskDefinitionSupport getCurrentTaskDefinition() {
        return this.getTaskDefinitionByIndex(this.indiceCorrente);
    }

    @Override
    public TaskDefinitionSupport getTaskDefinitionByIndex(int i) {
        if (i < 0 || i >= this.definicao.getTaskDefinition().size()) {
            return null;
        }
        return this.definicao.getTaskDefinition().get(i);
    }

    @Override
    public int getIndexById(String id) {
        int i = 0;
        for (TaskDefinition taskDefinition : this.definicao.getTaskDefinition()) {
            if (taskDefinition.getIdentifier().equals(id)) {
                return i;
            }
            ++i;
        }
        return i;
    }

    public void onLoad() {
        this.variavel.clear();
        for (ProcessInstanceVariableSupport v : this.listaDeVariaveis) {
            if (v.number != null) {
                this.variavel.put(v.id, v.number);
                continue;
            }
            if (v.bool != null) {
                this.variavel.put(v.id, v.bool);
                continue;
            }
            if (v.date != null) {
                this.variavel.put(v.id, v.date);
                continue;
            }
            this.variavel.put(v.id, v.string);
        }
    }

    public void onSave() throws Exception {
        this.listaDeVariaveis.clear();
        for (String k : this.variavel.keySet()) {
            ProcessInstanceVariableSupport v = new ProcessInstanceVariableSupport();
            v.id = k;
            Object o = this.variavel.get(k);
            if (o instanceof Boolean) {
                v.bool = (Boolean)o;
            } else if (o instanceof Double) {
                v.number = (Double)o;
            } else if (o instanceof Date) {
                v.date = (Date)o;
            } else {
                v.string = o.toString();
            }
            this.listaDeVariaveis.add(v);
        }
    }

    @Override
    public abstract ResponsibleSupport calcResponsible(TaskDefinitionSupport var1);

    @Override
    public ProcessDefinitionSupport getProcessDefinition() {
        return this.definicao;
    }

    @Override
    public Integer getCurrentIndex() {
        return this.indiceCorrente;
    }

    @Override
    public Map<String, Object> getVariable() {
        return this.variavel;
    }

    @Override
    public ProcessInstanceStatus getStatus() {
        return this.status;
    }

    @Override
    public Date getDtEvent() {
        return this.dtEvento;
    }

    @Override
    public String getIdEvent() {
        return this.evento;
    }

    @Override
    public ResponsibleSupport getResponsible() {
        return this.responsavel;
    }

    @Override
    public void setCurrentIndex(int indiceCorrente) {
        this.indiceCorrente = indiceCorrente;
    }

    @Override
    public void setProcessDefinition(ProcessDefinitionSupport definicao) {
        this.definicao = definicao;
    }

    @Override
    public void setVariable(Map<String, Object> variavel) {
        this.variavel = variavel;
    }
}

