/*
 * Decompiled with CFR 0.152.
 */
package com.crivano.jmodel;

import com.crivano.jmodel.CommandEnum;
import com.crivano.jmodel.Utils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Command {
    private static Pattern patternTemplateCommand = Pattern.compile("\\{(?<command>/?[a-zA-Z][a-zA-Z0-9_]*)?(?<expr>.*?)(?<params>\\s*[a-zA-Z0-9_]+\\s*=\\s*[^=].*)?\\}$");
    private static Pattern patternFreemarkerCommand = Pattern.compile("^\\[(?<command>(?>/?@[a-z]+))(?<expr>\\s+.*?)?(?<params>\\s*[a-zA-Z0-9_]+\\s*=\\s*[^=].*)?\\]$");
    private static Pattern patternSplitParams = Pattern.compile("\\s*(?<name>[a-z][a-z0-9]+)\\s*=\\s*(?<value>.+?)\\s*(?=$|[a-z][a-z0-9]+\\s*=)");
    private static Set<String> commands = new HashSet<String>(Arrays.asList("field", "print", "if", "/if", "for", "/for", "set"));
    String command;
    String expr;
    String var;
    String params;
    Map<String, String> mapParams;

    public Command(String s) {
        Matcher m = patternTemplateCommand.matcher(s);
        if (m.find()) {
            this.command = Utils.sorn(m.group("command"));
            this.expr = Utils.sorn(m.group("expr"));
            this.params = Utils.sorn(m.group("params"));
            if (this.command != null) {
                CommandEnum ce = CommandEnum.getCommandFromName(this.command);
                if (ce != null) {
                    this.command = ce.ftlCommand;
                } else if (this.command.equals(this.command.toUpperCase())) {
                    ce = CommandEnum.PRINT;
                    this.expr = this.command;
                    this.command = ce.ftlCommand;
                } else {
                    ce = CommandEnum.FIELD;
                    this.var = this.command;
                    this.command = ce.ftlCommand;
                    this.expr = null;
                    this.params = "var='" + this.var + "'" + (this.params != null ? " " + this.params : "");
                }
            }
        } else {
            m = patternFreemarkerCommand.matcher(s);
            if (m.find()) {
                this.command = Utils.sorn(m.group("command"));
                this.expr = Utils.sorn(m.group("expr"));
                this.params = Utils.sorn(m.group("params"));
            }
        }
        this.mapParams = new TreeMap<String, String>();
        if (this.params != null) {
            Matcher matcher = patternSplitParams.matcher(this.params);
            while (matcher.find()) {
                String name = Utils.sorn(matcher.group("name"));
                String value = Utils.sorn(matcher.group("value"));
                if (name == null || value == null) continue;
                this.mapParams.put(name, value);
            }
        }
    }

    public String getFieldVarAndIndex() {
        if (!CommandEnum.FIELD.ftlCommand.equals(this.command) || !this.mapParams.containsKey("var")) {
            return null;
        }
        String s = this.command + "|" + this.mapParams.get("var");
        if (this.mapParams.containsKey("index")) {
            s = s + "|" + this.mapParams.get("index");
        }
        return s;
    }

    public boolean isSelfContained() {
        return !this.isOpening() && !this.isClosing();
    }

    public boolean isClosing() {
        return this.command.startsWith("/");
    }

    public boolean isOpening() {
        return CommandEnum.GROUP_BEGIN.ftlCommand.equals(this.command) || CommandEnum.IF_BEGIN.ftlCommand.equals(this.command) || CommandEnum.FOR_BEGIN.ftlCommand.equals(this.command) || CommandEnum.DESCRIPTION_BEGIN.ftlCommand.equals(this.command) || CommandEnum.HOOK_BEGIN.ftlCommand.equals(this.command);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isClosing()) {
            sb.append("[/");
            sb.append(this.command.substring(1));
        } else {
            sb.append("[");
            sb.append(this.command);
        }
        if (this.expr != null) {
            sb.append(" expr=(");
            sb.append(this.expr);
            sb.append(")");
        }
        if (this.params != null) {
            sb.append(" ");
            sb.append(this.params);
        }
        if (CommandEnum.FOR_BEGIN.ftlCommand.equals(this.command)) {
            sb.append(" ; index");
        }
        sb.append(this.isSelfContained() ? "/]" : "]");
        return sb.toString();
    }
}

