/*
 * Decompiled with CFR 0.152.
 */
package com.crivano.jmodel;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FreemarkerMarker {
    public static Pattern patternFMM = Pattern.compile("\\{\\{fm\\}\\}(.*?)\\{\\{\\/fm\\}\\}", 32);
    private String template;
    private int pos = 0;
    private int len = 0;

    public FreemarkerMarker(String template) {
        this.template = template;
        this.len = this.template.length();
    }

    private boolean match(char c, int i) {
        if (this.pos + i >= this.len) {
            return false;
        }
        return this.template.charAt(this.pos + i) == c;
    }

    public String addMarks() {
        StringBuffer sb = new StringBuffer();
        boolean state = false;
        while (this.pos < this.len) {
            if (this.match('[', 0)) {
                int start;
                if (this.match('#', 1) && this.match('-', 2) && this.match('-', 3)) {
                    start = this.pos;
                    this.skipComment();
                    sb.append("{{fm}}");
                    sb.append(this.template.substring(start, this.pos));
                    sb.append("{{/fm}}");
                    continue;
                }
                if (this.match('#', 1) || this.match('@', 1) || this.match('/', 1) && (this.match('#', 2) || this.match('@', 2))) {
                    start = this.pos;
                    this.skipCommand();
                    sb.append("{{fm}}");
                    sb.append(this.template.substring(start, this.pos));
                    sb.append("{{/fm}}");
                    continue;
                }
            }
            sb.append(this.template.charAt(this.pos));
            ++this.pos;
        }
        return sb.toString();
    }

    private void skipComment() {
        while (this.pos < this.len) {
            if (this.match('-', 0) && this.match('-', 1) && this.match(']', 2)) {
                this.pos += 3;
                return;
            }
            ++this.pos;
        }
    }

    private void skipCommand() {
        ++this.pos;
        while (this.pos < this.len) {
            if (this.match('\"', 0)) {
                this.skipStringDoubleQuote();
            }
            if (this.match('\'', 0)) {
                this.skipStringSingleQuote();
            }
            if (this.match('[', 0)) {
                this.skipBrackets();
            }
            if (this.match(']', 0)) {
                ++this.pos;
                return;
            }
            if (this.match('/', 0) && this.match(']', 1)) {
                this.pos += 2;
                return;
            }
            ++this.pos;
        }
    }

    private void skipStringDoubleQuote() {
        ++this.pos;
        while (this.pos < this.len) {
            if (this.match('\"', 0)) {
                ++this.pos;
                return;
            }
            if (this.match('\\', 0) && this.match('\"', 1)) {
                this.pos += 2;
            }
            ++this.pos;
        }
    }

    private void skipStringSingleQuote() {
        ++this.pos;
        while (this.pos < this.len) {
            if (this.match('\'', 0)) {
                ++this.pos;
                return;
            }
            if (this.match('\\', 0) && this.match('\'', 1)) {
                this.pos += 2;
            }
            ++this.pos;
        }
    }

    private void skipBrackets() {
        ++this.pos;
        while (this.pos < this.len) {
            if (this.match('[', 0)) {
                this.skipBrackets();
            }
            if (this.match(']', 0)) {
                ++this.pos;
                return;
            }
            ++this.pos;
        }
    }

    public static String removeMarks(String marked) {
        Matcher matcher = patternFMM.matcher(marked);
        StringBuffer output = new StringBuffer();
        while (matcher.find()) {
            String ftl = matcher.group(1);
            matcher.appendReplacement(output, ftl);
        }
        matcher.appendTail(output);
        return output.toString();
    }
}

