/*
 * Decompiled with CFR 0.152.
 */
package com.crivano.jmodel;

import com.crivano.jmodel.Command;
import com.crivano.jmodel.CommandEnum;
import com.crivano.jmodel.FreemarkerIndent;
import com.crivano.jmodel.FreemarkerMarker;
import com.crivano.jmodel.Utils;
import com.vladsch.flexmark.ext.tables.TablesExtension;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Template {
    private static final String MARKDOWN_DOCUMENT = "<!-- MARKDOWN-DOCUMENT -->";
    private static final String MARKDOWN_DESCRIPTION = "<!-- MARKDOWN-DESCRIPTION -->";
    private static final String MARKDOWN_HOOK = "<!-- MARKDOWN-HOOK -->";
    static final Pattern patternFreemarkerRepositionUp = Pattern.compile("\\s*(?<html>(?:<p>|<tr>\\s*<td(?:\\s+align=\\\"[a-z]+\\\")?>))\\s*(?<freemarker>\\{\\{fm\\}\\}\\[@(?:if|for) .+?\\{\\{\\/fm\\}\\})\\s*", 8);
    static final Pattern patternFreemarkerRepositionDown = Pattern.compile("\\s*(?<freemarker>\\{\\{fm\\}\\}\\[/@(?:if|for)]\\{\\{\\/fm\\}\\})\\s*(?<html>(?:</p>|</td>\\s*</tr>))\\s*", 8);
    static final Pattern patternFreemarkerEmptyTopLevelMacros = Pattern.compile("\\[@(?:interview|description|document)\\]\\s*\\[/@(?:interview|description|document)\\]\\s*", 8);
    static final Pattern patternFreemarkerDescriptionWithin = Pattern.compile("\\{description\\}(?<description>.+)\\{/description\\}\\s*", 40);
    static final Pattern patternFreemarkerHookWithin = Pattern.compile("(?<hook>\\{hook ?(?<params>[^}]*)\\}.+\\{/hook\\})\\s*", 40);

    public static String markdownToFreemarker(String mdDescription, String mdDocument, String mdHook) {
        String htmlHook;
        int i;
        if (mdDescription == null) {
            mdDescription = "";
        }
        if (mdDocument == null) {
            mdDocument = "";
        }
        if (mdHook == null) {
            mdHook = "";
        }
        Matcher mDescr = patternFreemarkerDescriptionWithin.matcher(mdDocument);
        while (mDescr.find()) {
            String descr = Utils.sorn(mDescr.group("description"));
            if (descr == null) continue;
            mdDescription = mdDescription + descr;
        }
        mdDocument = mDescr.replaceAll("");
        Matcher mHook = patternFreemarkerHookWithin.matcher(mdDocument);
        while (mHook.find()) {
            String hook = Utils.sorn(mHook.group("hook"));
            if (hook == null) continue;
            mdHook = mdHook + hook;
        }
        mdDocument = mHook.replaceAll("");
        String input = "<!-- MARKDOWN-DESCRIPTION -->\n\n" + mdDescription + "\n\n" + MARKDOWN_DOCUMENT + "\n\n" + mdDocument + "\n\n" + MARKDOWN_HOOK + "\n\n" + mdHook;
        String mdWithCommandsInFreemarker = Template.processCommands(input, cmd -> {
            String comando = cmd.command;
            if (comando == null) {
                return "UNKNOWN_COMMAND";
            }
            return cmd.toString();
        });
        ArrayList<String> lftl = new ArrayList<String>();
        String txtWithPlaceholders = FreemarkerIndent.convertFtl2Html(mdWithCommandsInFreemarker, lftl);
        StringBuilder sb = new StringBuilder();
        sb.append(Template.buildHead(lftl));
        sb.append(Template.buildInterview(lftl));
        for (i = 0; i < lftl.size(); ++i) {
            if (!((String)lftl.get(i)).startsWith(CommandEnum.PREFIX_FIELD)) continue;
            lftl.set(i, CommandEnum.PREFIX_VALUE + ((String)lftl.get(i)).substring(CommandEnum.PREFIX_FIELD.length()));
        }
        for (i = 0; i < lftl.size(); ++i) {
            String ftl = (String)lftl.get(i);
            if (!ftl.startsWith(CommandEnum.PREFIX_GROUP_BEGIN) && !ftl.startsWith(CommandEnum.PREFIX_GROUP_END)) continue;
            lftl.set(i, "");
        }
        String ftlInMarkdown = FreemarkerIndent.convertHtml2Ftl(txtWithPlaceholders, lftl);
        String[] markdownSplit = Utils.sorn(ftlInMarkdown).split(MARKDOWN_HOOK);
        String ftlInHtml = Template.markdownToHtml(markdownSplit[0]) + "\n\n" + MARKDOWN_HOOK + "\n\n" + (markdownSplit.length == 1 ? "" : markdownSplit[1]);
        String[] html = ftlInHtml.split(MARKDOWN_DOCUMENT);
        String htmlDescription = Utils.sorn(html[0].replace(MARKDOWN_DESCRIPTION, ""));
        html = Utils.sorn(html[1]).split(MARKDOWN_HOOK);
        String htmlDocument = Utils.sorn(html[0].replace(MARKDOWN_DOCUMENT, ""));
        String string = htmlHook = html.length == 1 ? "" : Utils.sorn(html[1]);
        if (htmlDescription != null) {
            sb.append("\n\n[@description]\n");
            sb.append(htmlDescription);
            sb.append("[/@description]");
        }
        if (htmlDocument != null) {
            sb.append("\n\n[@document]\n");
            sb.append(htmlDocument);
            sb.append("[/@document]");
        }
        if (htmlHook != null) {
            sb.append("\n\n");
            sb.append(htmlHook);
        }
        try {
            String result = sb.toString();
            result = patternFreemarkerEmptyTopLevelMacros.matcher(result).replaceAll("");
            result = Template.freemarkerReposition(result);
            result = FreemarkerIndent.indent(result);
            result = result.replaceAll("\\s+\n", "\n");
            result = result.replaceAll("\\]\\s*\\[@interview\\]", "]\n\n[@interview]");
            result = result.replaceAll("\\]\\s*\\[@description\\]", "]\n\n[@description]");
            result = result.replaceAll("\\]\\s*\\[@document\\]", "]\n\n[@document]");
            result = result.replaceAll("\\]\\s*\\[@hook", "]\n\n[@hook");
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String buildHead(List<String> lftl) {
        StringBuilder sb = new StringBuilder();
        HashSet fields = new HashSet();
        String[] HEAD_COMMANDS = new String[]{CommandEnum.PREFIX_SET};
        for (int i = 0; i < lftl.size(); ++i) {
            String s = lftl.get(i);
            String next = i < lftl.size() - 1 ? lftl.get(i + 1) : null;
            for (String prefix : HEAD_COMMANDS) {
                if (!s.startsWith(prefix)) continue;
                sb.append("\n  ");
                if (s.startsWith(CommandEnum.PREFIX_SET)) {
                    s = "[#assign " + s.substring(6);
                }
                sb.append(s);
                lftl.set(i, "");
            }
        }
        return sb.toString();
    }

    private static String buildInterview(List<String> lftl) {
        StringBuilder sb = new StringBuilder();
        HashSet<String> fields = new HashSet<String>();
        sb.append("[@interview]");
        ArrayList<String> l = new ArrayList<String>();
        for (String ftl : lftl) {
            for (String prefix : CommandEnum.INTERVIEW_COMMANDS) {
                if (!ftl.startsWith(prefix)) continue;
                l.add(ftl);
            }
        }
        for (int i = 0; i < l.size(); ++i) {
            String s = (String)l.get(i);
            String next = i < l.size() - 1 ? (String)l.get(i + 1) : null;
            Command cmd = new Command(s);
            String fieldVarAndIndex = cmd.getFieldVarAndIndex();
            if (fieldVarAndIndex != null) {
                if (fields.contains(fieldVarAndIndex)) continue;
                fields.add(fieldVarAndIndex);
            }
            if (CommandEnum.IF_BEGIN.match(s) && CommandEnum.IF_END.match(next) || CommandEnum.FOR_BEGIN.match(s) && CommandEnum.FOR_END.match(next)) {
                ++i;
                continue;
            }
            sb.append("\n  ");
            sb.append(s);
        }
        sb.append("\n[/@interview]");
        return sb.toString();
    }

    private static String markdownToHtml(String input) {
        MutableDataSet options = new MutableDataSet();
        options.set(Parser.EXTENSIONS, Arrays.asList(TablesExtension.create()));
        Parser parser = Parser.builder((DataHolder)options).build();
        HtmlRenderer renderer = HtmlRenderer.builder((DataHolder)options).indentSize(2).build();
        Document document = parser.parse(input);
        String html = renderer.render((Node)document);
        return html;
    }

    private static Integer readCommand(String block, int startIndex) {
        int openBrackets = 0;
        boolean stillSearching = true;
        char waitForChar = '\u0000';
        for (int currPos = startIndex; stillSearching && currPos <= block.length(); ++currPos) {
            char currChar = block.charAt(currPos);
            if (waitForChar == '\u0000') {
                switch (currChar) {
                    case '{': {
                        ++openBrackets;
                        break;
                    }
                    case '}': {
                        --openBrackets;
                        break;
                    }
                    case '\"': 
                    case '\'': {
                        waitForChar = currChar;
                    }
                }
                continue;
            }
            if (currChar == waitForChar) {
                if (waitForChar == '\"' || waitForChar == '\'') {
                    if (block.charAt(currPos - 1) == '\\') continue;
                    waitForChar = '\u0000';
                    continue;
                }
                waitForChar = '\u0000';
                continue;
            }
            if (currChar != '*' || block.charAt(currPos + 1) != '/') continue;
            waitForChar = '\u0000';
            if (openBrackets != 0) continue;
            stillSearching = false;
            return currPos;
        }
        return null;
    }

    private static String processCommands(String template, ProcessCommandFunction func) {
        int start;
        int pointer = 0;
        String s = "";
        while (-1 != (start = template.indexOf("{", pointer))) {
            s = s + template.substring(pointer, start);
            Integer end = Template.readCommand(template, start);
            if (end == null) break;
            String command = template.substring(start, end);
            Command cmd = new Command(command);
            String r = func.modifyCommand(cmd);
            if (r != null) {
                s = s + r;
            }
            pointer = end;
        }
        s = s + template.substring(pointer, template.length());
        return s;
    }

    public static String freemarkerReposition(String s) {
        FreemarkerMarker fmm = new FreemarkerMarker(s);
        s = fmm.addMarks();
        String subst = "$2$1";
        s = patternFreemarkerRepositionUp.matcher(s).replaceAll("$2$1");
        s = patternFreemarkerRepositionDown.matcher(s).replaceAll("$2$1");
        return FreemarkerMarker.removeMarks(s);
    }

    public static interface ProcessCommandFunction {
        public String modifyCommand(Command var1);
    }
}

