/*
 * Decompiled with CFR 0.152.
 */
package com.crivano.swaggerservlet;

import com.crivano.swaggerservlet.ISwaggerRequest;
import com.crivano.swaggerservlet.ISwaggerResponse;
import com.crivano.swaggerservlet.SwaggerAsyncResponse;
import com.crivano.swaggerservlet.SwaggerCall;
import com.crivano.swaggerservlet.SwaggerException;
import com.crivano.swaggerservlet.SwaggerUtils;
import java.util.concurrent.Callable;

public class SwaggerAsyncRequest<T extends ISwaggerResponse>
implements Callable<SwaggerAsyncResponse<T>> {
    private String context;
    private String authorization;
    private String url;
    private String method;
    private ISwaggerRequest req;
    private Class<? extends ISwaggerResponse> respClass;

    public SwaggerAsyncRequest(String context, String authorization, String method, String url, ISwaggerRequest req, Class<? extends ISwaggerResponse> clazz) {
        this.context = context;
        this.authorization = authorization;
        this.method = method;
        this.url = url;
        this.req = req;
        this.respClass = clazz;
    }

    @Override
    public SwaggerAsyncResponse<T> call() throws Exception {
        long time = System.currentTimeMillis();
        try {
            SwaggerAsyncResponse<ISwaggerResponse> ar = new SwaggerAsyncResponse<ISwaggerResponse>(SwaggerCall.call(this.context, this.authorization, this.method, this.url, this.req, this.respClass));
            ar.setMiliseconds(System.currentTimeMillis() - time);
            return ar;
        }
        catch (Exception ex) {
            SwaggerAsyncResponse<Object> ar = new SwaggerAsyncResponse<Object>(null);
            ar.setMiliseconds(System.currentTimeMillis() - time);
            if (ex instanceof SwaggerException) {
                ar.setException((SwaggerException)ex);
            } else {
                String errmsg = SwaggerUtils.messageAsString(ex);
                String errstack = SwaggerUtils.stackAsString(ex);
                ar.setException(new SwaggerException(errmsg, 500, ex, this.req, null, this.context));
            }
            return ar;
        }
    }
}

