/*
 * Decompiled with CFR 0.152.
 */
package com.crivano.swaggerservlet;

import com.crivano.swaggerservlet.DefaultHTTP;
import com.crivano.swaggerservlet.IHTTP;
import com.crivano.swaggerservlet.ISwaggerRequest;
import com.crivano.swaggerservlet.ISwaggerResponse;
import com.crivano.swaggerservlet.IUnloggedException;
import com.crivano.swaggerservlet.LogResponse;
import com.crivano.swaggerservlet.SwaggerAsyncRequest;
import com.crivano.swaggerservlet.SwaggerAsyncResponse;
import com.crivano.swaggerservlet.SwaggerCallParameters;
import com.crivano.swaggerservlet.SwaggerCallStatus;
import com.crivano.swaggerservlet.SwaggerError;
import com.crivano.swaggerservlet.SwaggerException;
import com.crivano.swaggerservlet.SwaggerMultipleCallResult;
import com.crivano.swaggerservlet.SwaggerServlet;
import com.crivano.swaggerservlet.SwaggerUtils;
import com.crivano.swaggerservlet.test.TestResponse;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerCall {
    private static final Logger log = LoggerFactory.getLogger(SwaggerCall.class);
    private static IHTTP http = new DefaultHTTP();

    public static void setHttp(IHTTP http) {
        SwaggerCall.http = http;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends ISwaggerResponse> T call(String context, String authorization, String method, String url, ISwaggerRequest req, Class<T> clazz) throws Exception {
        ISwaggerResponse resp = null;
        LogResponse lr = new LogResponse();
        lr.method = method;
        lr.path = url;
        try {
            try {
                resp = (ISwaggerResponse)SwaggerCall.doHTTP(authorization, url.toString(), method, req, clazz);
            }
            catch (SwaggerException ex) {
                ex.context = context;
                throw ex;
            }
            catch (Exception ex) {
                String errmsg = SwaggerUtils.messageAsString(ex);
                String errstack = SwaggerUtils.stackAsString(ex);
                throw new SwaggerException(errmsg, 500, ex, req, null, context);
            }
            if (!(resp instanceof TestResponse) && resp instanceof SwaggerError) {
                SwaggerError err = (SwaggerError)resp;
                throw new SwaggerException(err.errormsg, 500, null, req, resp, context);
            }
            ISwaggerResponse iSwaggerResponse = resp;
            return (T)iSwaggerResponse;
        }
        finally {
            lr.request = req;
            lr.response = resp;
            log.debug("HTTP-CALL: " + SwaggerUtils.toJson(lr));
        }
    }

    public static <T extends ISwaggerResponse> T doHTTP(String authorization, String url, String method, ISwaggerRequest req, Class<T> respClass) throws Exception {
        if ("GET".equals(method)) {
            StringBuilder sb = new StringBuilder(url);
            if (req != null) {
                boolean first = true;
                for (Field f : req.getClass().getDeclaredFields()) {
                    f.setAccessible(true);
                    Object v = f.get(req);
                    if (v == null) continue;
                    if (v instanceof Date) {
                        v = SwaggerUtils.dateAdapter.format((Date)v);
                    }
                    sb.append(first && !url.contains("?") ? "?" : "&");
                    first = false;
                    sb.append(f.getName());
                    sb.append("=");
                    sb.append(URLEncoder.encode(v.toString(), "UTF-8"));
                }
            }
            url = sb.toString();
        }
        return http.fetch(authorization, url, method, req, respClass);
    }

    public static <T extends ISwaggerResponse> Future<SwaggerAsyncResponse<T>> callAsync(String context, String authorization, String method, String url, ISwaggerRequest req, Class<T> clazz) throws Exception {
        try {
            return SwaggerServlet.executor.submit(new SwaggerAsyncRequest(context, authorization, method, url, req, clazz));
        }
        catch (Exception ex) {
            String errmsg = SwaggerUtils.messageAsString(ex);
            String errstack = SwaggerUtils.stackAsString(ex);
            throw new SwaggerException(errmsg, 500, ex, req, null, context);
        }
    }

    public static SwaggerMultipleCallResult callMultiple(Map<String, SwaggerCallParameters> mapp, long timeoutMilliseconds) throws Exception {
        SwaggerMultipleCallResult r = new SwaggerMultipleCallResult();
        HashMap map = new HashMap();
        CountDownLatch responseWaiter = new CountDownLatch(mapp.size());
        long dt1 = System.currentTimeMillis();
        for (String system : mapp.keySet()) {
            SwaggerCallParameters scp = mapp.get(system);
            map.put(system, SwaggerCall.callAsync(scp.context, scp.authorization, scp.method, scp.url, scp.req, scp.clazz));
        }
        for (String system : mapp.keySet()) {
            SwaggerCallStatus ls = new SwaggerCallStatus();
            ls.system = system;
            r.status.add(ls);
            long time = System.currentTimeMillis();
            try {
                long timeout = timeoutMilliseconds - (time - dt1);
                if (timeout < 0L) {
                    timeout = 50L;
                }
                SwaggerAsyncResponse futureresponse = (SwaggerAsyncResponse)((Future)map.get(system)).get(timeout, TimeUnit.MILLISECONDS);
                ls.miliseconds = futureresponse.getMiliseconds();
                Object o = futureresponse.getRespOrThrowException();
                if (o == null) continue;
                r.responses.put(system, (ISwaggerResponse)o);
            }
            catch (Exception ex) {
                boolean logged = true;
                if (ex instanceof SwaggerException) {
                    SwaggerException se = (SwaggerException)ex;
                    if (se.resp instanceof SwaggerError) {
                        SwaggerError err = (SwaggerError)se.resp;
                        if (err.errordetails != null && err.errordetails.size() > 0) {
                            logged = err.errordetails.get((int)0).logged;
                        }
                    }
                }
                if (!(ex instanceof IUnloggedException)) {
                    logged = false;
                }
                if (logged) {
                    log.error("Erro acessando " + system, (Throwable)ex);
                }
                ls.errormsg = SwaggerUtils.messageAsString(ex);
                if (ls.errormsg == null) {
                    ls.errormsg = ex.getClass().getName();
                }
                ls.stacktrace = SwaggerUtils.stackAsString(ex);
                if (ls.miliseconds == null) {
                    ls.miliseconds = System.currentTimeMillis() - time;
                }
                if (!(ex instanceof TimeoutException)) continue;
                ((Future)map.get(system)).cancel(true);
            }
        }
        return r;
    }
}

