/*
 * Decompiled with CFR 0.152.
 */
package com.crivano.swaggerservlet;

import com.crivano.swaggerservlet.ISwaggerApiContext;
import com.crivano.swaggerservlet.ISwaggerCacheableMethod;
import com.crivano.swaggerservlet.ISwaggerMethod;
import com.crivano.swaggerservlet.ISwaggerPublicMethod;
import com.crivano.swaggerservlet.ISwaggerRequest;
import com.crivano.swaggerservlet.ISwaggerRequestFile;
import com.crivano.swaggerservlet.ISwaggerResponse;
import com.crivano.swaggerservlet.ISwaggerResponseFile;
import com.crivano.swaggerservlet.IUnloggedException;
import com.crivano.swaggerservlet.LogResponse;
import com.crivano.swaggerservlet.Property;
import com.crivano.swaggerservlet.Swagger;
import com.crivano.swaggerservlet.SwaggerAuthorizationException;
import com.crivano.swaggerservlet.SwaggerContext;
import com.crivano.swaggerservlet.SwaggerDetailedException;
import com.crivano.swaggerservlet.SwaggerError;
import com.crivano.swaggerservlet.SwaggerException;
import com.crivano.swaggerservlet.SwaggerUtils;
import com.crivano.swaggerservlet.dependency.IDependency;
import com.crivano.swaggerservlet.test.Test;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerServlet
extends HttpServlet {
    private static final String SWAGGERSERVLET_PROPERTIES_SECRET_NAME = "swaggerservlet.properties.secret";
    public static final String SWAGGERSERVLET_THREADPOOL_SIZE_PROPERTY_NAME = "swaggerservlet.threadpool.size";
    public static final String SWAGGERSERVLET_THREADPOOL_SIZE_DEFAULT_VALUE = "20";
    public static final String SWAGGERSERVLET_CALL_CONTENT_TYPE_NAME = "swaggerservlet.call.content.type";
    public static final String SWAGGERSERVLET_CALL_CONTENT_TYPE_VALUE = "application/json";
    private static final Logger log = LoggerFactory.getLogger(SwaggerServlet.class);
    private static final long serialVersionUID = 4436503480265700847L;
    private Swagger swagger = null;
    private String actionpackage = null;
    private Set<String> aditionalPackages = new TreeSet<String>();
    private Map<String, IDependency> dependencies = new TreeMap<String, IDependency>();
    private List<Property> properties = new ArrayList<Property>();
    private Map<String, String> manifest = new TreeMap<String, String>();
    private String authorization = null;
    private String authorizationToProperties = null;
    private Class<? extends ISwaggerApiContext> classApiContext;
    public String servletContext = null;
    public static String callContentType;
    public static ExecutorService executor;
    private static ThreadLocal<SwaggerContext> current;
    private Map<String, String> redefinedProperties = new HashMap<String, String>();

    public final void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.servletContext = config.getServletContext().getContextPath().replace("/", "");
        this.addRestrictedProperty(SWAGGERSERVLET_THREADPOOL_SIZE_PROPERTY_NAME, SWAGGERSERVLET_THREADPOOL_SIZE_DEFAULT_VALUE);
        this.addRestrictedProperty(SWAGGERSERVLET_CALL_CONTENT_TYPE_NAME, SWAGGERSERVLET_CALL_CONTENT_TYPE_VALUE);
        callContentType = this.getProperty(SWAGGERSERVLET_CALL_CONTENT_TYPE_NAME);
        this.addPrivateProperty(SWAGGERSERVLET_PROPERTIES_SECRET_NAME, null);
        this.setAuthorizationToProperties(this.getProperty(SWAGGERSERVLET_PROPERTIES_SECRET_NAME));
        try (InputStream is = config.getServletContext().getResourceAsStream("/META-INF/MANIFEST.MF");){
            String m = SwaggerUtils.convertStreamToString(is);
            if (m != null) {
                m = m.replaceAll("\r\n", "\n");
                for (String s : m.split("\n")) {
                    String[] a = s.split(":", 2);
                    if (a.length != 2) continue;
                    this.manifest.put(a[0].trim(), a[1].trim());
                }
            }
        }
        catch (IOException e) {
            log.error("INIT ERROR: ", (Throwable)e);
        }
        if (executor == null) {
            executor = Executors.newFixedThreadPool(new Integer(this.getProperty(SWAGGERSERVLET_THREADPOOL_SIZE_PROPERTY_NAME)));
        }
        try {
            this.initialize(config);
        }
        catch (Exception ex) {
            throw new ServletException((Throwable)ex);
        }
        try {
            this.assertProperties();
        }
        catch (Exception ex) {
            log.error("PROPERTIES ERROR", (Throwable)ex);
        }
    }

    protected void initialize(ServletConfig config) throws Exception {
    }

    public String getProperty(String propertyName) {
        String name = this.propertyName(propertyName);
        Property dp = this.getDefinedProperty(name);
        if (dp == null) {
            throw new RuntimeException("Can't access property '" + name + "' because it was not declared in servlet's initialization");
        }
        if (this.redefinedProperties.containsKey(name)) {
            return this.redefinedProperties.get(name);
        }
        String s = System.getProperty(name);
        if (s != null) {
            return s;
        }
        s = System.getenv("PROP_" + name.replace(".", "_").toUpperCase());
        if (s != null) {
            return s;
        }
        if (dp.isOptional()) {
            return dp.getDefaultValue();
        }
        throw new RuntimeException("Property '" + name + "' not defined");
    }

    public void setProperty(String propertyName, String value) {
        this.redefinedProperties.put(propertyName, value);
    }

    public Property getDefinedProperty(String propertyName) {
        for (Property p : this.properties) {
            if (!p.getName().equals(propertyName)) continue;
            return p;
        }
        return null;
    }

    public void showPackageErrors(String pkg) {
        this.aditionalPackages.add(pkg);
    }

    public static HttpServletRequest getHttpServletRequest() {
        return current.get().getRequest();
    }

    public static HttpServletResponse getHttpServletResponse() {
        return current.get().getResponse();
    }

    public Map<String, String> getManifestEntries() {
        return this.manifest;
    }

    protected void prepare(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String requestMethod = request.getMethod();
        String requestPathInfo = request.getPathInfo();
        this.prepare(requestMethod, requestPathInfo);
    }

    public void prepare(String requestMethod, String requestPathInfo) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        SwaggerContext p = new SwaggerContext();
        current.set(null);
        String method = requestMethod.toLowerCase();
        p.setMatchingPath(this.swagger.checkRequestPath(requestPathInfo, method));
        p.setActionName(this.toCamelCase(p.getMatchingPath().swaggerPath + " " + method));
        Class<?> clazz = Class.forName(this.actionpackage + "." + p.getActionName());
        p.setAction((ISwaggerMethod)this.newInstance(clazz));
        p.setContext(p.getAction().getContext());
        p.setService(this.getService());
        p.setCacheable(p.getAction() instanceof ISwaggerCacheableMethod);
        p.setClazzRequest(Class.forName(this.swagger.getInterfacePackage() + "." + this.swagger.getInterfaceName() + "$I" + p.getActionName() + "$Request"));
        p.setClazzResponse(Class.forName(this.swagger.getInterfacePackage() + "." + this.swagger.getInterfaceName() + "$I" + p.getActionName() + "$Response"));
        p.setSubclazzContext(this.getApiContextClass());
        p.setClazzContext(Class.forName(this.swagger.getInterfacePackage() + "." + this.swagger.getInfoTitle() + "Context"));
        p.setReq(this.newInstance(p.getClazzRequest()));
        p.setResp(this.newInstance(p.getClazzResponse()));
        current.set(p);
    }

    public <T> T newInstance(Class<T> clazz) throws InstantiationException, IllegalAccessException {
        return clazz.newInstance();
    }

    public String toCamelCase(String path) {
        path = path.replaceAll("[^A-Za-z0-9]", " ");
        path = path.trim();
        path = path.replaceAll("\\s+", "_");
        StringBuilder sb = new StringBuilder();
        for (String oneString : path.split("_")) {
            sb.append(oneString.substring(0, 1).toUpperCase());
            sb.append(oneString.substring(1));
        }
        return sb.toString();
    }

    protected static String getContext() {
        SwaggerContext prepared = current.get();
        if (prepared == null) {
            return null;
        }
        String context = prepared.getContext();
        return context;
    }

    protected static boolean isCacheable() {
        SwaggerContext prepared = current.get();
        if (prepared == null) {
            return false;
        }
        Boolean cacheable = prepared.isCacheable();
        return cacheable;
    }

    public String getService() {
        return this.swagger.getInfoTitle();
    }

    public String getUser() {
        return null;
    }

    public void setSwagger(Swagger sw) {
        this.swagger = sw;
    }

    public void setActionPackage(String ap) {
        this.actionpackage = ap;
    }

    public Class<? extends ISwaggerApiContext> getApiContextClass() throws ClassNotFoundException {
        if (this.classApiContext == null) {
            this.classApiContext = Class.forName(this.swagger.getInterfacePackage() + "." + this.swagger.getInfoTitle() + "Context");
        }
        return this.classApiContext;
    }

    public void setApiContextClass(Class<? extends ISwaggerApiContext> classApiContext) {
        this.classApiContext = classApiContext;
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse response) throws ServletException, IOException {
        if (req.getPathInfo() != null && req.getPathInfo().endsWith("/swagger.yaml")) {
            InputStream is = this.getSwaggerYamlAsStream();
            if (is == null) {
                is = ((Object)((Object)this)).getClass().getResourceAsStream("/swagger.yaml");
            }
            String sSwagger = SwaggerUtils.convertStreamToString(is);
            sSwagger = sSwagger.replaceFirst("basePath: [^\\s]+", "basePath: " + req.getRequestURI().replace("/swagger.yaml", ""));
            byte[] ab = sSwagger.getBytes();
            response.setContentType("text/x-yaml");
            response.setContentLength(ab.length);
            response.getOutputStream().write(ab);
            response.getOutputStream().flush();
        } else if (req.getPathInfo() != null && req.getPathInfo().endsWith("/swagger-ui")) {
            response.sendRedirect(req.getRequestURL() + "/index.html?url=" + req.getRequestURL().substring(0, req.getRequestURL().length() - "/swagger-ui".length()) + "/swagger.yaml");
        } else if (req.getPathInfo() != null && req.getPathInfo().contains("/swagger-ui/")) {
            String resource = req.getPathInfo().substring(req.getPathInfo().lastIndexOf("/swagger-ui/") + "/swagger-ui/".length());
            if (!resource.matches("^[a-z0-9\\.-]+$")) {
                throw new ServletException("Invalid swagger-ui resource");
            }
            InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/com/crivano/swaggerservlet/dist/" + resource);
            String sSwagger = SwaggerUtils.convertStreamToString(is);
            if (sSwagger == null) {
                response.sendError(404);
                return;
            }
            byte[] ab = sSwagger.getBytes(StandardCharsets.UTF_8);
            if (resource.endsWith(".html")) {
                response.setContentType("text/html; charset=utf-8");
            } else if (resource.endsWith(".css")) {
                response.setContentType("text/css; charset=utf-8");
            } else if (resource.endsWith(".js")) {
                response.setContentType("text/javascript; charset=utf-8");
            } else if (resource.endsWith(".png")) {
                response.setContentType("image/png");
            }
            response.setContentLength(ab.length);
            response.getOutputStream().write(ab);
            response.getOutputStream().flush();
        } else if ("GET".equals(req.getMethod()) && req.getPathInfo() != null && req.getPathInfo().equals("/test")) {
            Test.run(this, this.dependencies, this.properties, req, response);
        } else {
            this.doPost(req, response);
        }
    }

    public InputStream getSwaggerYamlAsStream() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String path = this.swagger.getInterfacePackage().replace(".", "/");
        InputStream is = classLoader.getResourceAsStream(path + "/swagger.yaml");
        return is;
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ISwaggerRequest req = null;
        ISwaggerResponse resp = null;
        SwaggerServlet.corsHeaders(request, response);
        try {
            this.prepare(request, response);
            SwaggerContext prepared = current.get();
            prepared.setRequest(request);
            prepared.setResponse(response);
            req = prepared.getReq();
            resp = prepared.getResp();
            req = this.injectVariables(request, req);
            if (SwaggerServlet.isCacheable()) {
                // empty if block
            }
            if (!ISwaggerPublicMethod.class.isAssignableFrom(prepared.getAction().getClass()) && this.getAuthorization() != null && !this.getAuthorization().equals(this.getAuthorizationFromHeader(request))) {
                throw new Exception("Unauthorized.");
            }
            this.run(req, resp);
            current.set(prepared);
            if (!response.isCommitted()) {
                SwaggerServlet.flush(req, resp);
            }
        }
        catch (Exception e) {
            try {
                int sts = this.errorStatus(e);
                if (e instanceof SwaggerAuthorizationException) {
                    sts = 401;
                }
                String errorcode = this.errorCode(e);
                SwaggerError error = SwaggerUtils.writeJsonError(sts, errorcode, request, response, e, req, resp, SwaggerServlet.getContext(), this.getService(), this.getUser(), e instanceof SwaggerDetailedException ? ((SwaggerDetailedException)e).status : null);
                response.getWriter().close();
                if (this.shouldBeLogged(sts, e)) {
                    LogResponse lr = new LogResponse();
                    lr.method = request.getMethod();
                    lr.path = request.getContextPath() + request.getPathInfo();
                    lr.request = req;
                    lr.response = error;
                    String details = SwaggerUtils.toJson(lr);
                    this.aditionalPackages.add(this.actionpackage);
                    log.error("HTTP-ERROR: {}, EXCEPTION {}", (Object)details, (Object)SwaggerUtils.simplifyStackTrace(e, this.aditionalPackages.toArray(new String[this.aditionalPackages.size()])));
                }
            }
            catch (Exception e2) {
                if (e.getMessage() != null && e.getMessage().contains("Connection reset")) {
                    return;
                }
                throw new RuntimeException("Error returning error message.", e);
            }
        }
    }

    public static void flush(ISwaggerRequest req, ISwaggerResponse resp) throws IOException, Exception {
        boolean fCanReturnPayload;
        HttpServletRequest request = SwaggerServlet.getHttpServletRequest();
        HttpServletResponse response = SwaggerServlet.getHttpServletResponse();
        LogResponse lr = new LogResponse();
        lr.method = request.getMethod();
        lr.path = request.getContextPath() + request.getPathInfo();
        response.setHeader("Swagger-Servlet-Version", "0.0.2-SNAPSHOT");
        String userAgent = request.getHeader("User-Agent");
        if (userAgent == null) {
            userAgent = request.getHeader("user-agent");
        }
        response.setHeader("Swagger-Servlet-Request-UA", userAgent);
        boolean bl = fCanReturnPayload = !"SwaggerServlet".equals(userAgent);
        if (fCanReturnPayload && resp instanceof ISwaggerResponseFile) {
            ISwaggerResponseFile r = (ISwaggerResponseFile)resp;
            if (r.getContentlength() != null) {
                response.setContentLength(r.getContentlength().intValue());
            }
            response.setContentType(r.getContenttype());
            if (r.getContentdisposition() != null) {
                response.setHeader("Content-Disposition", r.getContentdisposition());
            }
            SwaggerUtils.transferContent(r.getInputstream(), (OutputStream)response.getOutputStream());
            return;
        }
        if (SwaggerServlet.isCacheable()) {
            // empty if block
        }
        lr.request = req;
        lr.response = resp;
        log.debug("HTTP-OK: " + SwaggerUtils.toJson(lr));
        SwaggerUtils.writeJsonResp(response, resp, SwaggerServlet.getContext(), current.get().getService());
        response.getWriter().close();
    }

    public int errorStatus(Exception e) {
        if (e instanceof SwaggerException) {
            return ((SwaggerException)e).getStatus();
        }
        return 500;
    }

    public String errorCode(Exception e) {
        return null;
    }

    public boolean shouldBeLogged(int sts, Exception e) {
        return sts >= 500 && !(e instanceof IUnloggedException);
    }

    public String getAuthorizationFromHeader(HttpServletRequest request) {
        String s = request.getHeader("Authorization");
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).startsWith("Basic ")) {
            String userpass = new String(SwaggerUtils.base64Decode(s.substring(6)));
            s = userpass.split(":")[1];
        }
        return s;
    }

    public ISwaggerRequest injectVariables(HttpServletRequest request, ISwaggerRequest req) throws Exception {
        ISwaggerRequest reqFromJson;
        SwaggerContext prepared = current.get();
        if (req instanceof ISwaggerRequestFile && ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            ISwaggerRequestFile reqFile = (ISwaggerRequestFile)((Object)req);
            ServletFileUpload upload = new ServletFileUpload();
            FileItemIterator iter = upload.getItemIterator(request);
            while (iter.hasNext()) {
                FileItemStream item = iter.next();
                String name = item.getFieldName();
                InputStream stream = item.openStream();
                if (item.isFormField()) {
                    String value = Streams.asString((InputStream)stream);
                    SwaggerUtils.log(((Object)((Object)this)).getClass()).debug("Form field " + name + " with value " + value + " detected.");
                    if (Swagger.has(req, name)) continue;
                    Swagger.set(req, name, value);
                    continue;
                }
                SwaggerUtils.log(((Object)((Object)this)).getClass()).debug("File field " + name + " with file name " + item.getName() + " detected.");
                reqFile.setContenttype(item.getContentType());
                reqFile.setFilename(item.getName());
                reqFile.setContent(SwaggerUtils.upload(item.getName(), item.getContentType(), stream));
                Enumeration headerNames = request.getHeaderNames();
                if (headerNames == null) continue;
                HashMap<String, List<String>> headerFields = new HashMap<String, List<String>>();
                while (headerNames.hasMoreElements()) {
                    String headerName = (String)headerNames.nextElement();
                    if (headerFields.get(headerName) == null) {
                        headerFields.put(headerName, new ArrayList());
                    }
                    ((List)headerFields.get(headerName)).add(request.getHeader(headerName));
                }
                reqFile.setHeaderFields(headerFields);
            }
        }
        if (request.getContentType() != null && request.getContentType().startsWith(SWAGGERSERVLET_CALL_CONTENT_TYPE_VALUE) && (reqFromJson = SwaggerUtils.getJsonReq(request, SwaggerServlet.getContext(), prepared.getClazzRequest())) != null) {
            req = reqFromJson;
            prepared.setReq(req);
        }
        Enumeration paramNames = request.getParameterNames();
        while (paramNames != null && paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            String[] paramValues = request.getParameterValues(paramName);
            if (!(request.getParameter(paramName) instanceof String)) continue;
            if (Swagger.has(req, paramName)) continue;
            Swagger.set(req, paramName, request.getParameter(paramName));
        }
        this.swagger.injectQueryStringParameters(req, request.getParameterMap());
        this.swagger.injectPathVariables(req, prepared.getMatchingPath());
        return req;
    }

    public void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    public void doOptions(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        SwaggerServlet.corsHeaders(request, response);
        response.setStatus(200);
        response.getWriter().write("OK");
        response.getWriter().close();
    }

    public static void corsHeaders(HttpServletRequest request, HttpServletResponse response) {
        String origin = request.getHeader("Origin");
        if (origin == null) {
            origin = "*";
        }
        response.addHeader("Access-Control-Allow-Origin", origin);
        response.addHeader("Access-Control-Allow-Methods", "GET,POST,DELETE,PUT,OPTIONS");
        response.addHeader("Access-Control-Allow-Headers", "Content-Type,Authorization");
        response.addHeader("Access-Control-Allow-Credentials", "true");
    }

    public String getAuthorization() {
        return this.authorization;
    }

    public void setAuthorization(String authorization) {
        this.authorization = authorization;
    }

    public String getAuthorizationToProperties() {
        return this.authorizationToProperties;
    }

    public void setAuthorizationToProperties(String authorization) {
        this.authorizationToProperties = authorization;
    }

    public void run(ISwaggerRequest req, ISwaggerResponse resp) throws Exception {
        SwaggerContext prepared = current.get();
        prepared.setReq(req);
        prepared.setResp(resp);
        try {
            this.invoke(prepared);
        }
        catch (InvocationTargetException ex) {
            Exception exc = ex;
            if (exc.getCause() != null && exc.getCause() instanceof Exception) {
                exc = (Exception)exc.getCause();
            }
            if (exc instanceof ServletException && exc.getCause() != null && exc.getCause() instanceof Exception) {
                exc = (Exception)exc.getCause();
            }
            throw exc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(SwaggerContext prepared) throws Exception {
        block19: {
            Class<?> clazzAction = prepared.getAction().getClass();
            Method method = clazzAction.getMethod("run", prepared.getClazzRequest(), prepared.getClazzResponse(), prepared.getClazzContext());
            try (ISwaggerApiContext ctx = this.newInstance(prepared.getSubclazzContext());){
                ctx.init(prepared);
                try {
                    ctx.onTryBegin();
                    method.invoke((Object)prepared.getAction(), prepared.getReq(), prepared.getResp(), ctx);
                    ctx.onTryEnd();
                }
                catch (Throwable t) {
                    try {
                        if (t instanceof Exception) {
                            ctx.onCatch((Exception)t);
                        } else {
                            ctx.onCatch(new Exception(t));
                        }
                        break block19;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        ctx.onFinally();
                    }
                }
                ctx.onFinally();
            }
        }
    }

    public void setAPI(Class clazzInterface) {
        Swagger sw = new Swagger();
        sw.setInterfaceName(clazzInterface.getSimpleName());
        sw.setInterfacePackage(clazzInterface.getPackage().getName());
        this.setSwagger(sw);
        InputStream is = this.getSwaggerYamlAsStream();
        sw.loadFromInputStream(is);
    }

    public static void setExecutor(ExecutorService newExecutor) {
        executor = newExecutor;
    }

    public boolean test() {
        return true;
    }

    public void addDependency(IDependency dep) {
        this.dependencies.put(dep.getService(), dep);
    }

    public String propertyName(String name) {
        if (this.servletContext == null || this.servletContext.length() == 0) {
            return name;
        }
        if (name.startsWith("/")) {
            return name.substring(1);
        }
        return this.servletContext + "." + name;
    }

    public void addPrivateProperty(String name) {
        this.properties.add(new Property(Property.Scope.PRIVATE, this.propertyName(name), false, null));
    }

    public void addRestrictedProperty(String name) {
        this.properties.add(new Property(Property.Scope.RESTRICTED, this.propertyName(name), false, null));
    }

    public void addPublicProperty(String name) {
        this.properties.add(new Property(Property.Scope.PUBLIC, this.propertyName(name), false, null));
    }

    public void addPrivateProperty(String name, String defaultValue) {
        this.properties.add(new Property(Property.Scope.PRIVATE, this.propertyName(name), true, defaultValue));
    }

    public void addRestrictedProperty(String name, String defaultValue) {
        this.properties.add(new Property(Property.Scope.RESTRICTED, this.propertyName(name), true, defaultValue));
    }

    public void addPublicProperty(String name, String defaultValue) {
        this.properties.add(new Property(Property.Scope.PUBLIC, this.propertyName(name), true, defaultValue));
    }

    public void assertProperties() {
        for (Property p : this.properties) {
            if (!p.getName().startsWith(this.servletContext + ".")) continue;
            this.getProperty(p.getName().substring(this.servletContext.length() + 1));
        }
    }

    public ISwaggerResponse execute(String requestMethod, String requestPathInfo, ISwaggerRequest reqOverride, HttpServletRequest request, Map<String, String[]> params) throws Exception {
        this.prepare(requestMethod, requestPathInfo);
        SwaggerContext prepared = current.get();
        if (reqOverride != null) {
            prepared.setReq(reqOverride);
        }
        if (request != null) {
            prepared.setRequest(request);
        }
        ISwaggerRequest req = prepared.getReq();
        ISwaggerResponse resp = prepared.getResp();
        if (request != null) {
            req = this.injectVariables(request, req);
        }
        if (params != null) {
            this.swagger.injectQueryStringParameters(req, params);
        }
        this.swagger.injectPathVariables(req, prepared.getMatchingPath());
        this.run(req, resp);
        return resp;
    }

    public ISwaggerResponse execute(String requestMethod, String requestPathInfo, Map<String, String> params) throws Exception {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        if (params != null) {
            for (String key : params.keySet()) {
                map.put(key, new String[]{params.get(key)});
            }
        }
        return this.execute(requestMethod, requestPathInfo, null, null, map);
    }

    public void destroy() {
        super.destroy();
        this.servletContext = null;
        this.redefinedProperties = new HashMap<String, String>();
    }

    static {
        executor = null;
        current = new ThreadLocal();
    }
}

