/*
 * Decompiled with CFR 0.152.
 */
package com.crivano.swaggerservlet.test;

import com.crivano.swaggerservlet.Property;
import com.crivano.swaggerservlet.SwaggerCall;
import com.crivano.swaggerservlet.SwaggerCallParameters;
import com.crivano.swaggerservlet.SwaggerCallStatus;
import com.crivano.swaggerservlet.SwaggerError;
import com.crivano.swaggerservlet.SwaggerMultipleCallResult;
import com.crivano.swaggerservlet.SwaggerServlet;
import com.crivano.swaggerservlet.SwaggerUtils;
import com.crivano.swaggerservlet.dependency.IDependency;
import com.crivano.swaggerservlet.dependency.SwaggerServletDependency;
import com.crivano.swaggerservlet.dependency.TestableDependency;
import com.crivano.swaggerservlet.test.TestAsync;
import com.crivano.swaggerservlet.test.TestResponse;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Test {
    private static final long DEFAULT_TIMEOUT_MILLISECONDS = 10000L;
    private static final long DEFAULT_TIMEOUT_MINUS_MILLISECONDS = 500L;
    private static final Logger log = LoggerFactory.getLogger(Test.class);

    public static void run(SwaggerServlet ss, Map<String, IDependency> dependencies, List<Property> properties, HttpServletRequest request, HttpServletResponse response) throws IOException {
        long timeout;
        long start_time = System.currentTimeMillis();
        HashSet<String> skip = new HashSet<String>();
        HashMap<String, Boolean> partialMap = new HashMap<String, Boolean>();
        String[] skipValues = request.getParameterValues("skip");
        String[] partialValues = request.getParameterValues("partial");
        boolean skipAll = false;
        long dt1 = System.currentTimeMillis();
        try {
            timeout = Long.parseLong(request.getParameter("timeout"));
        }
        catch (NumberFormatException e) {
            timeout = 10000L;
        }
        if (skipValues != null) {
            for (String s : skipValues) {
                skip.add(s);
            }
            if (skipValues.length == 1 && "all".equals(skipValues[0])) {
                skipAll = true;
            }
        }
        if (partialValues != null) {
            for (String s : partialValues) {
                String[] split = s.split(":");
                partialMap.put(split[0], Boolean.valueOf(split[1]));
            }
        }
        TestResponse tr = new TestResponse(null, ss.getService(), request.getRequestURI(), false);
        tr.version = ss.getManifestEntries().get("Build-Label");
        tr.timestamp = ss.getManifestEntries().get("Build-Time");
        boolean auth = ss.getAuthorizationToProperties() != null && ss.getAuthorizationToProperties().equals(request.getParameter("authorizationToProperties"));
        for (Property p : properties) {
            if (p.getScope() == Property.Scope.PUBLIC) {
                tr.addProperty(p.getName(), ss.getDefinedProperty(p.getName()), ss);
                continue;
            }
            if (p.getScope() == Property.Scope.RESTRICTED) {
                if (auth) {
                    tr.addProperty(p.getName(), ss.getDefinedProperty(p.getName()), ss);
                    continue;
                }
                tr.addPrivateProperty(p.getName(), ss);
                continue;
            }
            if (p.getScope() != Property.Scope.PRIVATE) continue;
            tr.addPrivateProperty(p.getName(), ss);
        }
        try {
            TestResponse tr2;
            ss.assertProperties();
            boolean dependenciesOK = true;
            HashMap<String, SwaggerCallParameters> mapp = new HashMap<String, SwaggerCallParameters>();
            HashMap<String, IDependency> mapt = new HashMap<String, IDependency>();
            for (String string : dependencies.keySet()) {
                IDependency dep = dependencies.get(string);
                String ref = Test.buildRef(dep);
                if (skipAll || skip.contains(ref)) continue;
                if (timeout >= dep.getMsMin()) {
                    if (dep instanceof SwaggerServletDependency) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("?timeout=");
                        sb.append(timeout);
                        for (String s : skip) {
                            if (sb.length() == 0) {
                                sb.append("?");
                            }
                            sb.append("&");
                            sb.append("skip=");
                            sb.append(URLEncoder.encode(s, StandardCharsets.UTF_8.name()));
                        }
                        mapp.put(string, new SwaggerCallParameters("test- " + string, null, "GET", dep.getUrl() + "/test" + sb.toString(), null, TestResponse.class));
                        continue;
                    }
                    if (!(dep instanceof TestableDependency)) continue;
                    mapt.put(string, dep);
                    continue;
                }
                tr2 = new TestResponse(dep.getCategory(), dep.getService(), dep.getUrl(), Test.isPartial(dep, partialMap));
                tr2.skiped = true;
                tr.addDependency(tr2);
                Test.addToSkipList(skip, null, ref);
            }
            HashMap<String, Future<TestResponse>> map = new HashMap<String, Future<TestResponse>>();
            for (String service : mapt.keySet()) {
                TestableDependency dep = (TestableDependency)dependencies.get(service);
                tr2 = new TestResponse(dep.getCategory(), dep.getService(), dep.getUrl(), Test.isPartial(dep, partialMap));
                map.put(service, SwaggerServlet.executor.submit(new TestAsync(dep, tr2)));
            }
            SwaggerMultipleCallResult swaggerMultipleCallResult = SwaggerCall.callMultiple(mapp, timeout);
            for (SwaggerCallStatus sts : swaggerMultipleCallResult.status) {
                IDependency dep = dependencies.get(sts.system);
                TestResponse r = (TestResponse)swaggerMultipleCallResult.responses.get(sts.system);
                if (r == null) {
                    r = new TestResponse(dep.getCategory(), dep.getService(), dep.getUrl(), Test.isPartial(dep, partialMap));
                    r.pass = null;
                    r.available = false;
                    r.errormsg = sts.errormsg;
                    r.errordetails = new ArrayList();
                    SwaggerError.Detail det = new SwaggerError.Detail();
                    det.stacktrace = sts.stacktrace;
                    r.errordetails.add(det);
                }
                r.category = dep.getCategory();
                r.service = dep.getService();
                r.url = dep.getUrl();
                r.partial = Test.isPartial(dep, partialMap);
                r.ms = sts.miliseconds;
                tr.addDependency(r);
                Test.addToSkipList(skip, r, Test.buildRef(dep));
            }
            for (String service : mapt.keySet()) {
                TestResponse r;
                long time = System.currentTimeMillis();
                try {
                    long timeRemaining = timeout - (time - dt1);
                    if (timeRemaining < 0L) {
                        timeRemaining = 0L;
                    }
                    r = (TestResponse)((Future)map.get(service)).get(timeRemaining, TimeUnit.MILLISECONDS);
                    tr.addDependency(r);
                }
                catch (Exception ex) {
                    IDependency dep = (IDependency)mapt.get(service);
                    r = new TestResponse(dep.getCategory(), dep.getService(), dep.getUrl(), Test.isPartial(dep, partialMap));
                    SwaggerUtils.buildSwaggerError(request, ex, "test", ss.getService(), ss.getUser(), r, null);
                    r.available = false;
                    r.ms = time - dt1;
                    tr.addDependency(r);
                    if (!(ex instanceof TimeoutException)) continue;
                    ((Future)map.get(service)).cancel(true);
                }
            }
            if (tr.dependencies != null) {
                for (TestResponse r : tr.dependencies) {
                    if (r.available == null || r.available.booleanValue()) continue;
                    dependenciesOK = false;
                    if (!r.partial.booleanValue()) {
                        tr.available = false;
                        tr.errormsg = r.category + ": " + r.service + ": " + r.errormsg;
                        break;
                    }
                    tr.partial = true;
                }
            }
            if (tr.available == null) {
                tr.available = ss.test();
            }
            tr.pass = tr.available;
        }
        catch (Exception e) {
            tr.available = false;
            tr.pass = false;
            SwaggerUtils.buildSwaggerError(request, e, "test", ss.getService(), ss.getUser(), tr, null);
            log.error("Error testing swaggerservlet", (Throwable)e);
        }
        tr.ms = System.currentTimeMillis() - dt1;
        try {
            if (tr.pass == null || !tr.pass.booleanValue()) {
                response.setStatus(242);
            }
            SwaggerServlet.corsHeaders(request, response);
            SwaggerUtils.writeJsonResp(response, tr, "test", ss.getService());
        }
        catch (Exception e) {
            throw new RuntimeException("error reporting test results", e);
        }
    }

    private static String buildRef(IDependency dep) {
        return dep.getService() + "@" + dep.getUrl();
    }

    private static boolean isPartial(IDependency dep, Map<String, Boolean> partialMap) {
        boolean isPartial = dep.isPartial();
        if (partialMap.containsKey(dep.getService())) {
            isPartial = partialMap.get(dep.getService());
        }
        if (partialMap.containsKey(dep.getUrl())) {
            isPartial = partialMap.get(dep.getUrl());
        }
        return isPartial;
    }

    private static void addToSkipList(Set<String> skip, TestResponse tr, String ref) {
        skip.add(ref);
        if (tr == null || tr.dependencies == null) {
            return;
        }
        for (TestResponse tr2 : tr.dependencies) {
            Test.addToSkipList(skip, tr2, tr2.service + "@" + tr2.url);
        }
    }
}

