/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.htime;

import com.cronutils.htime.DatetimeFormatterConstants;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;

public class DateTimeFormatParser {
    private DatetimeFormatterConstants constants;
    private Locale locale;
    private Map<String, String> dayOfWeek;
    private Map<String, String> months;
    private Map<String, String> dateFormatByCountry;

    public DateTimeFormatParser(DatetimeFormatterConstants constants, Locale locale) {
        this.constants = (DatetimeFormatterConstants)Validate.notNull((Object)constants, (String)"ConstantsConfiguration must not be null", (Object[])new Object[0]);
        this.locale = (Locale)Validate.notNull((Object)locale, (String)"Locale must not be null", (Object[])new Object[0]);
        this.dayOfWeek = this.initDaysOfWeek(locale);
        this.months = this.initMonths(locale);
        this.dateFormatByCountry = this.initDateFormatByCountry();
    }

    public String parsePattern(String expression) {
        if (this.isTimezone(expression.replaceAll("[^A-Za-z0-9/_:\\-\\+ ]", ""))) {
            return this.timezonePattern(expression);
        }
        if ((expression = expression.toLowerCase()).contains("/")) {
            return this.parseDateSlashes(expression);
        }
        if (expression.contains(":")) {
            return this.parseTimeWithColons(expression);
        }
        String clean = expression.replaceAll("[^A-Za-z0-9 ]", "");
        if (this.isNumberPattern(clean)) {
            return expression.replace(clean, this.numberPattern(clean));
        }
        if (this.dayOfWeek.containsKey(clean)) {
            return expression.replace(clean, this.dayOfWeek.get(clean));
        }
        if (this.months.containsKey(clean)) {
            return expression.replace(clean, this.months.get(clean));
        }
        return expression;
    }

    @VisibleForTesting
    String parseDateSlashes(String expression) {
        return this.dateFormatByCountry.containsKey(this.locale.getCountry()) ? this.dateFormatByCountry.get(this.locale.getCountry()) : String.format("%s%s/%s%s/%s%s", this.constants.dayOfMonth(), this.constants.dayOfMonth(), this.constants.monthOfYear(), this.constants.monthOfYear(), this.constants.year(), this.constants.year());
    }

    @VisibleForTesting
    String parseTimeWithColons(String expression) {
        String[] parts;
        String hour = String.format("%s%s", this.constants.hourOfDay(), this.constants.hourOfDay());
        String pattern = "%s";
        if (expression.contains("am") || expression.contains("pm")) {
            hour = String.format("%s%s", this.constants.clockhourOfHalfday(), this.constants.clockhourOfHalfday());
            pattern = "%s " + this.constants.halfOfDay();
        }
        if ((parts = expression.split(":")).length == 2) {
            return String.format(pattern, String.format("%s:%s%s", hour, this.constants.minuteOfHour(), this.constants.minuteOfHour()));
        }
        return String.format(pattern, String.format("%s:%s%s:%s%s", hour, this.constants.minuteOfHour(), this.constants.minuteOfHour(), this.constants.secondOfMinute(), this.constants.secondOfMinute()));
    }

    @VisibleForTesting
    boolean isNumberPattern(String string) {
        try {
            Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    @VisibleForTesting
    String numberPattern(String string) {
        switch (string.length()) {
            case 4: {
                return String.format("%s%s%s%s", this.constants.year(), this.constants.year(), this.constants.year(), this.constants.year());
            }
            case 2: {
                return String.format("%s%s", this.constants.dayOfMonth(), this.constants.dayOfMonth());
            }
        }
        return this.constants.dayOfMonth();
    }

    @VisibleForTesting
    boolean isTimezone(String string) {
        try {
            DateTimeZone.forID((String)string);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    @VisibleForTesting
    String timezonePattern(String string) {
        return this.constants.timezoneRFC822();
    }

    @VisibleForTesting
    Map<String, String> initDaysOfWeek(Locale locale) {
        String fullDoW = String.format("%s%s%s%s", this.constants.dayOfWeekName(), this.constants.dayOfWeekName(), this.constants.dayOfWeekName(), this.constants.dayOfWeekName());
        LocalDate date = new LocalDate();
        HashMap mapping = Maps.newHashMap();
        for (int j = 1; j < 8; ++j) {
            String dow = date.withDayOfWeek(j).dayOfWeek().getAsText(locale).toLowerCase();
            mapping.put(dow, fullDoW);
            mapping.put(dow.substring(0, 3), this.constants.dayOfWeekName());
        }
        return mapping;
    }

    @VisibleForTesting
    Map<String, String> initMonths(Locale locale) {
        String fullMonth = String.format("%s%s%s%s", this.constants.monthOfYear(), this.constants.monthOfYear(), this.constants.monthOfYear(), this.constants.monthOfYear());
        String shortMonth = String.format("%s%s%s", this.constants.monthOfYear(), this.constants.monthOfYear(), this.constants.monthOfYear());
        LocalDate date = new LocalDate();
        HashMap mapping = Maps.newHashMap();
        for (int j = 1; j < 13; ++j) {
            String moy = date.withMonthOfYear(j).monthOfYear().getAsText(locale).toLowerCase();
            mapping.put(moy, fullMonth);
            mapping.put(moy.substring(0, 3), shortMonth);
        }
        return mapping;
    }

    @VisibleForTesting
    Map<String, String> initDateFormatByCountry() {
        String mmddyy = String.format("%s%s/%s%s/%s%s", this.constants.monthOfYear(), this.constants.monthOfYear(), this.constants.dayOfMonth(), this.constants.dayOfMonth(), this.constants.year(), this.constants.year());
        String yymmdd = String.format("%s%s/%s%s/%s%s", this.constants.year(), this.constants.year(), this.constants.monthOfYear(), this.constants.monthOfYear(), this.constants.dayOfMonth(), this.constants.dayOfMonth());
        HashMap dateFormatByCountry = Maps.newHashMap();
        dateFormatByCountry.put("US", mmddyy);
        dateFormatByCountry.put("BZ", mmddyy);
        dateFormatByCountry.put("CN", yymmdd);
        dateFormatByCountry.put("KR", yymmdd);
        dateFormatByCountry.put("KP", yymmdd);
        dateFormatByCountry.put("TW", yymmdd);
        dateFormatByCountry.put("HU", yymmdd);
        dateFormatByCountry.put("IR", yymmdd);
        dateFormatByCountry.put("JP", yymmdd);
        dateFormatByCountry.put("LT", yymmdd);
        dateFormatByCountry.put("MN", yymmdd);
        return dateFormatByCountry;
    }
}

