package com.crosstreelabs.phpfunctions.dateformat;

import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeParser;
import org.joda.time.format.DateTimeParserBucket;
import org.joda.time.format.DateTimePrinter;

public abstract class AbstractPrinterParser implements DateTimePrinter, DateTimeParser {

    //~ DateTimePrinter impl ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    @Override
    public void printTo(StringBuffer buf, long instant, Chronology chrono, int displayOffset, DateTimeZone displayZone, Locale locale) {
        buf.append(fromInstant(instant, chrono, displayOffset, displayZone, locale));
    }

    @Override
    public void printTo(Writer out, long instant, Chronology chrono, int displayOffset, DateTimeZone displayZone, Locale locale) throws IOException {
        out.append(fromInstant(instant, chrono, displayOffset, displayZone, locale));
    }

    @Override
    public void printTo(StringBuffer buf, ReadablePartial partial, Locale locale) {
        buf.append(fromPartial(partial, locale));
    }

    @Override
    public void printTo(Writer out, ReadablePartial partial, Locale locale) throws IOException {
        out.append(fromPartial(partial, locale));
    }
    
    public abstract String fromPartial(ReadablePartial partial, Locale locale);
    
    public String fromInstant(long instance, Chronology chrono, int displayOffset, DateTimeZone displayZone, Locale locale) {
        return fromPartial(new LocalDateTime(instance, displayZone), locale);
    }

    //~ DateTimeParser impl ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    @Override
    public int estimateParsedLength() {
        return estimatePrintedLength();
    }

    @Override
    public int parseInto(DateTimeParserBucket bucket, String text, int position) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
    
}