package com.crosstreelabs.phpfunctions.dateformat;

import java.util.Locale;
import org.joda.time.DateTimeFieldType;
import org.joda.time.ReadablePartial;

public class DayOfWeekPrinterParser extends AbstractPrinterParser {
    private final boolean iso;
    
    public DayOfWeekPrinterParser() {
        this(true);
    }
    public DayOfWeekPrinterParser(final boolean iso) {
        this.iso = iso;
    }

    @Override
    public String fromPartial(ReadablePartial partial, Locale locale) {
        // Surely there's a better way to do this?
        int n = partial.get(DateTimeFieldType.dayOfWeek());
        if (!iso) {
            if (n == 7) {
                return 0+"";
            }
            return ++n+"";
        }
        return n+"";
    }

    @Override
    public int estimatePrintedLength() {
        return 2;
    }
    
}