package com.crosstreelabs.phpfunctions.dateformat;

import java.util.Locale;
import org.joda.time.ReadablePartial;

public class DaysInMonthPrinter extends AbstractPrinterParser {

    @Override
    public String fromPartial(ReadablePartial partial, Locale locale) {
        // Surely there's a better way to do this?
        return partial.getChronology().dayOfMonth().getMaximumValue(partial)+"";
    }

    @Override
    public int estimatePrintedLength() {
        return 2;
    }
    
}