package com.crosstreelabs.phpfunctions.dateformat;

import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadablePartial;

public class IsDaylightSavingsTimePrinter extends AbstractPrinterParser {

    @Override
    public String fromPartial(ReadablePartial partial, Locale locale) {
        DateTimeZone zone = partial.getChronology().getZone();
        
        int year = partial.get(DateTimeFieldType.year());
        int month = partial.get(DateTimeFieldType.monthOfYear());
        int day = partial.get(DateTimeFieldType.dayOfMonth());
        int hour = partial.get(DateTimeFieldType.hourOfDay());
        int minute = partial.get(DateTimeFieldType.minuteOfHour());
        int second = partial.get(DateTimeFieldType.secondOfMinute());
        
        DateTime dt = new DateTime(year, month, day, hour, minute, second, zone);
        return zone.isStandardOffset(dt.getMillis()) ? "0" : "1";
    }

    @Override
    public int estimatePrintedLength() {
        return 1;
    }

    @Override
    public String fromInstant(long instant, Chronology chrono, int displayOffset, DateTimeZone displayZone, Locale locale) {
        DateTime dt = new DateTime(instant, DateTimeZone.UTC)
                .withZoneRetainFields(displayZone);
        return displayZone.isStandardOffset(dt.getMillis()) ? "0" : "1";
    }
    
}