package com.crosstreelabs.phpfunctions.dateformat;

import java.util.Locale;
import org.joda.time.DateTimeField;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;

public class IsLeapYearPrinter extends AbstractPrinterParser {

    @Override
    public String fromPartial(ReadablePartial partial, Locale locale) {
        DateTimeField year = partial.getChronology().year();
        if (new LocalDateTime(partial.get(year.getType()), 1, 1, 1, 0).year().isLeap()) {
            return "1";
        }
        return "0";
    }

    @Override
    public int estimatePrintedLength() {
        return 1;
    }
    
}