package com.crosstreelabs.phpfunctions.dateformat;

import java.util.Locale;
import org.joda.time.ReadablePartial;

public class OrdinalDayOfWeekSuffixPrinter extends AbstractPrinterParser {

    @Override
    public String fromPartial(ReadablePartial partial, Locale locale) {
        // Surely there's a better way to do this?
        int n = Integer.valueOf(partial.getChronology().dayOfMonth().getAsText(partial, locale));
        if (n >= 11 && n <= 13) {
            return "th";
        }
        switch (n % 10) {
            case 1:  return "st";
            case 2:  return "nd";
            case 3:  return "rd";
            default: return "th";
        }
    }

    @Override
    public int estimatePrintedLength() {
        return 2;
    }
    
}