package com.crosstreelabs.phpfunctions.dateformat;

import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadablePartial;

public class SwatchInternetTimePrinter extends AbstractPrinterParser {

    @Override
    public String fromPartial(ReadablePartial partial, Locale locale) {
        // (UTC+1seconds + (UTC+1minutes * 60) + (UTC+1hours * 3600)) / 86.4
        
        // NOTE: As far as I can tell, we can't get timezone info when given a
        // partial, so we assume the time is given according the default time
        // zone. - Thomas Wilson
        
        int localSeconds = partial.get(DateTimeFieldType.secondOfMinute());
        int localMinutes = partial.get(DateTimeFieldType.minuteOfHour());
        int localHours = partial.get(DateTimeFieldType.hourOfDay());
        DateTime dt = new DateTime(2000, 1, 1, localHours, localMinutes, localSeconds, DateTimeZone.getDefault())
                .withZone(DateTimeZone.forOffsetHours(1));
        return fromDateTime(dt);
    }

    @Override
    public String fromInstant(long instant, Chronology chrono, int displayOffset, DateTimeZone displayZone, Locale locale) {
        DateTime dt = new DateTime(instant, DateTimeZone.UTC)
                .withZoneRetainFields(displayZone)
                .withZone(DateTimeZone.forOffsetHours(1));
        return fromDateTime(dt);
    }
    
    protected String fromDateTime(final DateTime dt) {
        return (int)((dt.getSecondOfMinute() + (dt.getMinuteOfHour() * 60) + (dt.getHourOfDay() * 3600)) / 86.4)+"";
    }

    @Override
    public int estimatePrintedLength() {
        return 3;
    }
    
}