/*
 * Decompiled with CFR 0.152.
 */
package com.crosstreelabs.phpfunctions;

import com.crosstreelabs.phpfunctions.dateformat.DayOfWeekPrinterParser;
import com.crosstreelabs.phpfunctions.dateformat.DaysInMonthPrinter;
import com.crosstreelabs.phpfunctions.dateformat.IsDaylightSavingsTimePrinter;
import com.crosstreelabs.phpfunctions.dateformat.IsLeapYearPrinter;
import com.crosstreelabs.phpfunctions.dateformat.LowercaseHalfOfDayPrinter;
import com.crosstreelabs.phpfunctions.dateformat.OrdinalDayOfWeekSuffixPrinter;
import com.crosstreelabs.phpfunctions.dateformat.SwatchInternetTimePrinter;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;
import org.joda.time.format.DateTimePrinter;

public class DateFormatUtil {
    public static DateTimeFormatter output(String format) {
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
        block39: for (String token : new Tokenizer(format, OUTPUT_FORMAT_SYMBOL.tokens())) {
            if (!OUTPUT_FORMAT_SYMBOL.contains(token)) {
                builder.appendLiteral(token);
                continue;
            }
            switch (OUTPUT_FORMAT_SYMBOL.valueOf(token)) {
                case d: {
                    builder.appendDayOfMonth(2);
                    continue block39;
                }
                case D: {
                    builder.appendDayOfWeekShortText();
                    continue block39;
                }
                case j: {
                    builder.appendDayOfMonth(1);
                    continue block39;
                }
                case l: {
                    builder.appendDayOfWeekText();
                    continue block39;
                }
                case N: {
                    builder.append((DateTimePrinter)new DayOfWeekPrinterParser(), (DateTimeParser)new DayOfWeekPrinterParser());
                    continue block39;
                }
                case S: {
                    builder.append((DateTimePrinter)new OrdinalDayOfWeekSuffixPrinter(), (DateTimeParser)new OrdinalDayOfWeekSuffixPrinter());
                    continue block39;
                }
                case w: {
                    builder.append((DateTimePrinter)new DayOfWeekPrinterParser(false), (DateTimeParser)new DayOfWeekPrinterParser(false));
                    continue block39;
                }
                case z: {
                    builder.appendDayOfYear(1);
                    continue block39;
                }
                case W: {
                    builder.appendWeekOfWeekyear(1);
                    continue block39;
                }
                case F: {
                    builder.appendMonthOfYearText();
                    continue block39;
                }
                case m: {
                    builder.appendMonthOfYear(2);
                    continue block39;
                }
                case M: {
                    builder.appendMonthOfYearShortText();
                    continue block39;
                }
                case n: {
                    builder.appendMonthOfYear(1);
                    continue block39;
                }
                case t: {
                    builder.append((DateTimePrinter)new DaysInMonthPrinter(), (DateTimeParser)new DaysInMonthPrinter());
                    continue block39;
                }
                case L: {
                    builder.append((DateTimePrinter)new IsLeapYearPrinter(), (DateTimeParser)new IsLeapYearPrinter());
                    continue block39;
                }
                case o: {
                    throw new UnsupportedOperationException("'o' not yet supported");
                }
                case Y: {
                    builder.appendYear(4, 4);
                    continue block39;
                }
                case y: {
                    builder.appendYear(2, 2);
                    continue block39;
                }
                case a: {
                    builder.append((DateTimePrinter)new LowercaseHalfOfDayPrinter(), (DateTimeParser)new LowercaseHalfOfDayPrinter());
                    continue block39;
                }
                case A: {
                    builder.appendHalfdayOfDayText();
                    continue block39;
                }
                case B: {
                    builder.append((DateTimePrinter)new SwatchInternetTimePrinter(), (DateTimeParser)new SwatchInternetTimePrinter());
                    continue block39;
                }
                case g: {
                    builder.appendHourOfHalfday(1);
                    continue block39;
                }
                case G: {
                    builder.appendHourOfDay(1);
                    continue block39;
                }
                case h: {
                    builder.appendHourOfHalfday(2);
                    continue block39;
                }
                case H: {
                    builder.appendHourOfDay(2);
                    continue block39;
                }
                case i: {
                    builder.appendMinuteOfHour(2);
                    continue block39;
                }
                case s: {
                    builder.appendSecondOfMinute(2);
                    continue block39;
                }
                case u: {
                    builder.appendMillisOfSecond(6);
                    continue block39;
                }
                case e: {
                    builder.appendTimeZoneName();
                    continue block39;
                }
                case I: {
                    builder.append((DateTimePrinter)new IsDaylightSavingsTimePrinter(), (DateTimeParser)new IsDaylightSavingsTimePrinter());
                    continue block39;
                }
                case O: {
                    builder.appendTimeZoneOffset(null, false, 2, 4);
                    continue block39;
                }
                case P: {
                    builder.appendTimeZoneOffset(null, true, 2, 4);
                    continue block39;
                }
                case T: {
                    builder.appendTimeZoneShortName();
                    continue block39;
                }
                case Z: {
                    throw new UnsupportedOperationException("'Z' not yet supported");
                }
                case c: {
                    throw new UnsupportedOperationException("'c' not yet supported");
                }
                case r: {
                    throw new UnsupportedOperationException("'r' not yet supported");
                }
                case U: {
                    throw new UnsupportedOperationException("'U' not yet supported");
                }
            }
            builder.appendLiteral(token);
        }
        return builder.toFormatter();
    }

    public static class Tokenizer
    implements Iterable<String>,
    Iterator<String> {
        private final String[] knownTokens;
        private final String tokenized;
        private final String[] tokens;
        private int pointer = 0;

        public Tokenizer(String tokenized, String[] knownTokens) {
            this.tokenized = tokenized;
            this.knownTokens = knownTokens;
            ArrayList<String> tokens = new ArrayList<String>();
            String tmp = tokenized;
            while (tmp.length() > 0) {
                int nextKnownTokenIdx = StringUtils.indexOfAny((CharSequence)tmp, (CharSequence[])knownTokens);
                String nextKnownToken = tmp.substring(nextKnownTokenIdx, nextKnownTokenIdx + 1);
                if (nextKnownTokenIdx == -1) {
                    tokens.add(tmp);
                    tmp = "";
                    continue;
                }
                if (nextKnownTokenIdx == 0) {
                    tokens.add("" + nextKnownToken);
                    tmp = tmp.substring(nextKnownToken.length());
                    continue;
                }
                tokens.add(tmp.substring(0, nextKnownTokenIdx));
                tmp = tmp.substring(nextKnownTokenIdx);
                tokens.add(nextKnownToken);
                tmp = tmp.substring(nextKnownToken.length());
            }
            this.tokens = tokens.toArray(new String[tokens.size()]);
        }

        @Override
        public Iterator<String> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.pointer < this.tokens.length;
        }

        @Override
        public String next() {
            String tmp = this.tokens[this.pointer];
            ++this.pointer;
            return tmp;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static enum OUTPUT_FORMAT_SYMBOL {
        d,
        D,
        j,
        l,
        N,
        S,
        w,
        z,
        W,
        F,
        m,
        M,
        n,
        t,
        L,
        o,
        Y,
        y,
        a,
        A,
        B,
        g,
        G,
        h,
        H,
        i,
        s,
        u,
        e,
        I,
        O,
        P,
        T,
        Z,
        c,
        r,
        U;


        public static String[] tokens() {
            OUTPUT_FORMAT_SYMBOL[] values = OUTPUT_FORMAT_SYMBOL.values();
            String[] result = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                result[i] = values[i].name();
            }
            return result;
        }

        public static boolean contains(String test) {
            for (OUTPUT_FORMAT_SYMBOL c : OUTPUT_FORMAT_SYMBOL.values()) {
                if (!c.name().equals(test)) continue;
                return true;
            }
            return false;
        }
    }
}

