/*
 * Decompiled with CFR 0.152.
 */
package com.crosstreelabs.phpfunctions;

import com.crosstreelabs.phpfunctions.dateformat.LowercaseHalfOfDayPrinter;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;
import org.joda.time.format.DateTimeParserBucket;
import org.joda.time.format.DateTimePrinter;

public class DateParsingUtil {
    public static final DateTimeFormatter TIMEZONE = new DateTimeFormatterBuilder().appendOptional((DateTimeParser)new OneOf("UTC", "utc", "GMT", "gmt")).append(DateTimeFormat.forPattern((String)"ZZ")).toFormatter();
    public static final DateTimeFormatter TWELVE_HOUR_TIME = new DateTimeFormatterBuilder().appendClockhourOfHalfday(1).appendOptional(new DateTimeFormatterBuilder().appendOptional((DateTimeParser)new OneOf(".", ":")).appendMinuteOfHour(2).appendOptional(new DateTimeFormatterBuilder().appendOptional((DateTimeParser)new OneOf(".", ":")).appendSecondOfMinute(2).appendOptional(new DateTimeFormatterBuilder().appendOptional((DateTimeParser)new OneOf(".", ":")).appendFractionOfSecond(1, 6).toParser()).toParser()).toParser()).appendOptional(DateTimeFormat.forPattern((String)" ").getParser()).append((DateTimePrinter)new LowercaseHalfOfDayPrinter(), (DateTimeParser)new LowercaseHalfOfDayPrinter()).toFormatter().withOffsetParsed();
    public static final DateTimeFormatter TWENTY_FOUR_HOUR_TIME = new DateTimeFormatterBuilder().append(null, new DateTimeParser[]{TIMEZONE.getParser(), new DateTimeFormatterBuilder().appendOptional((DateTimeParser)new OneOf("t", "T")).appendHourOfDay(2).appendOptional((DateTimeParser)new OneOf(".", ":")).appendMinuteOfHour(2).appendOptional(new DateTimeFormatterBuilder().appendOptional((DateTimeParser)new OneOf(".", ":")).appendSecondOfMinute(2).appendOptional(new DateTimeFormatterBuilder().append(null, new DateTimeParser[]{TIMEZONE.getParser(), DateTimeFormat.forPattern((String)".SSSSSS").getParser()}).toParser()).toParser()).toParser()}).toFormatter().withOffsetParsed();
    public static final DateTimeFormatter DATE_FORMATS = new DateTimeFormatterBuilder().append(null, new DateTimeParser[]{new DateTimeFormatterBuilder().appendMonthOfYear(1).appendLiteral('/').appendDayOfMonth(1).appendOptional(new DateTimeFormatterBuilder().appendLiteral('/').append((DateTimeParser)new YearParser()).toParser()).toParser(), DateTimeFormat.forPattern((String)"yyyy/M/d").getParser(), DateTimeFormat.forPattern((String)"yyyy-M").getParser(), new DateTimeFormatterBuilder().append((DateTimeParser)new YearParser()).appendLiteral('-').appendMonthOfYear(1).appendLiteral('-').appendDayOfMonth(1).toParser(), new DateTimeFormatterBuilder().appendDayOfMonth(1).append((DateTimeParser)new OneOf("\t", ".", "-")).appendMonthOfYear(1).append((DateTimeParser)new OneOf("\t", ".", "-")).append((DateTimeParser)new YearParser(2, 4)).toParser(), new DateTimeFormatterBuilder().append((DateTimeParser)new DayParser()).append((DateTimeParser)new ManyOf(" ", "\t", ".", "-")).appendPattern("MMMM").append((DateTimeParser)new ManyOf(" ", "\t", ".", "-")).append((DateTimeParser)new YearParser()).toParser(), new DateTimeFormatterBuilder().appendPattern("MMMM").append((DateTimeParser)new ManyOf(" ", "\t", ".", "-")).append((DateTimeParser)new YearParser(4, 4)).toParser(), new DateTimeFormatterBuilder().append((DateTimeParser)new YearParser(4, 4)).append((DateTimeParser)new ManyOf(" ", "\t", ".", "-")).appendPattern("MMMM").toParser(), new DateTimeFormatterBuilder().appendPattern("MMMM").append((DateTimeParser)new ManyOf(" ", "\t", ".", "-")).appendDayOfMonth(1).append((DateTimeParser)new ManyOf(",", ".", "s", "t", "n", "d", "r", "h", "\t", " ")).appendOptional((DateTimeParser)new YearParser()).toParser(), new DateTimeFormatterBuilder().appendDayOfMonth(1).append((DateTimeParser)new ManyOf(" ", "\t", ".", "-")).appendPattern("MMMM").toParser(), new DateTimeFormatterBuilder().appendPattern("MMM").appendLiteral('-').appendDayOfMonth(2).appendLiteral('-').append((DateTimeParser)new YearParser()).toParser(), new DateTimeFormatterBuilder().append((DateTimeParser)new YearParser()).appendLiteral('-').appendPattern("MMM").appendLiteral('-').appendDayOfMonth(2).toParser(), DateTimeFormat.forPattern((String)"yyyy").getParser(), DateTimeFormat.forPattern((String)"MMM").getParser()}).toFormatter().withDefaultYear(Calendar.getInstance().get(1)).withOffsetParsed();
    public static final DateTimeFormatter ISO_DATE_FORMATS = new DateTimeFormatterBuilder().append(null, new DateTimeParser[]{DateTimeFormat.forPattern((String)"yyyyMMdd").getParser(), DateTimeFormat.forPattern((String)"yyyy/MM/dd").getParser(), DateTimeFormat.forPattern((String)"yy-MM-dd").getParser(), new DateTimeFormatterBuilder().append((DateTimeParser)new YearParser(4, 4, true)).append(DateTimeFormat.forPattern((String)"-MM-dd")).toParser()}).toFormatter().withOffsetParsed();
    public static final DateTimeFormatter COMPOUND_FORMATS = new DateTimeFormatterBuilder().append(null, new DateTimeParser[]{DateTimeFormat.forPattern((String)"dd/MMM/yyyy:HH:mm:ss ZZ").getParser(), DateTimeFormat.forPattern((String)"yyyy:MM:dd HH:mm:ss").getParser(), new DateTimeFormatterBuilder().appendYear(4, 4).appendOptional((DateTimeParser)new OneOf("-")).appendLiteral('W').appendWeekOfWeekyear(2).appendOptional(new DateTimeFormatterBuilder().appendOptional((DateTimeParser)new OneOf("-")).appendDayOfWeek(1).toParser()).toParser(), DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss").getParser(), new DateTimeFormatterBuilder().appendYear(4, 4).appendOptional((DateTimeParser)new OneOf(".")).appendDayOfYear(3).toParser(), DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSSSSSZZ").getParser(), DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSSSSS").getParser(), new DateTimeFormatterBuilder().appendLiteral('@').append((DateTimeParser)new UnixTimestampParser()).toParser(), DateTimeFormat.forPattern((String)"yyyyMMdd'T'HH:mm:ss").getParser(), DateTimeFormat.forPattern((String)"yyyyMMdd't'HHmmss").getParser(), DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss").getParser()}).toFormatter().withOffsetParsed();

    public static class UnixTimestampParser
    implements DateTimeParser {
        public int estimateParsedLength() {
            return 20;
        }

        public int parseInto(DateTimeParserBucket bucket, String text, int position) {
            String next = text.substring(position);
            Pattern p = Pattern.compile("^-?\\d{1,20}");
            Matcher m = p.matcher(next);
            if (!m.find()) {
                return 0;
            }
            String timestampStr = m.group();
            if (timestampStr == null || timestampStr.trim().isEmpty()) {
                return 0;
            }
            Long timestamp = Long.valueOf(timestampStr);
            DateTime date = new DateTime(timestamp * 1000L, DateTimeZone.UTC);
            bucket.setZone(DateTimeZone.UTC);
            bucket.saveField(DateTimeFieldType.year(), date.getYear());
            bucket.saveField(DateTimeFieldType.monthOfYear(), date.getMonthOfYear());
            bucket.saveField(DateTimeFieldType.dayOfMonth(), date.getDayOfMonth());
            bucket.saveField(DateTimeFieldType.hourOfDay(), date.getHourOfDay());
            bucket.saveField(DateTimeFieldType.minuteOfHour(), date.getMinuteOfHour());
            bucket.saveField(DateTimeFieldType.secondOfMinute(), date.getSecondOfMinute());
            bucket.saveField(DateTimeFieldType.millisOfSecond(), date.getMillisOfSecond());
            return position + timestampStr.length();
        }
    }

    public static class DayParser
    implements DateTimeParser {
        public int estimateParsedLength() {
            return 2;
        }

        public int parseInto(DateTimeParserBucket bucket, String text, int position) {
            String next = text.substring(position);
            String number = this.getFirstNumber(next);
            if (number == null) {
                return -1;
            }
            Integer day = Integer.valueOf(number);
            if (day < 0 || day > 31) {
                return -1;
            }
            bucket.saveField(DateTimeFieldType.dayOfMonth(), day.intValue());
            return position + number.length();
        }

        protected String getFirstNumber(String text) {
            Pattern p = Pattern.compile("^\\d{1,2}");
            Matcher m = p.matcher(text);
            if (m.find()) {
                return m.group();
            }
            return null;
        }
    }

    public static class YearParser
    implements DateTimeParser {
        private final int minLength;
        private final int maxLength;
        private final boolean allowLeadingSign;

        public YearParser() {
            this(1, 4, false);
        }

        public YearParser(int minLength, int maxLength) {
            this(minLength, maxLength, false);
        }

        public YearParser(int minLength, int maxLength, boolean allowLeadingSign) {
            this.minLength = minLength;
            this.maxLength = maxLength;
            this.allowLeadingSign = allowLeadingSign;
        }

        public int estimateParsedLength() {
            return this.maxLength;
        }

        public int parseInto(DateTimeParserBucket bucket, String text, int position) {
            String next = text.substring(position);
            String number = this.getFirstNumber(next);
            if (number == null || number.length() < this.minLength || number.length() > this.maxLength) {
                return -1;
            }
            Integer year = Integer.valueOf(number);
            if (number.length() >= 4) {
                bucket.saveField(DateTimeFieldType.year(), year.intValue());
                return position + number.length();
            }
            int pivot = (bucket.getPivotYear() == null ? 69 : bucket.getPivotYear()) % 100;
            if (year >= 0 && year <= pivot) {
                bucket.saveField(DateTimeFieldType.year(), 2000 + year);
            } else {
                bucket.saveField(DateTimeFieldType.year(), 1900 + year);
            }
            return position + number.length();
        }

        protected String getFirstNumber(String text) {
            Pattern p = Pattern.compile(String.format("^%s\\d{%s,%s}", this.allowLeadingSign ? "[-+]?" : "", this.minLength, this.maxLength));
            Matcher m = p.matcher(text);
            if (m.find()) {
                return m.group();
            }
            return null;
        }
    }

    public static class ManyOf
    extends OneOf {
        public ManyOf(String ... strings) {
            super(strings);
        }

        @Override
        public int parseInto(DateTimeParserBucket bucket, String text, int position) {
            boolean started;
            String next = text.substring(position);
            do {
                started = false;
                for (String str : this.strings) {
                    if (!next.startsWith(str)) continue;
                    started = true;
                    next = next.substring(str.length());
                    position += str.length();
                }
            } while (started);
            return position;
        }
    }

    public static class OneOf
    implements DateTimeParser {
        protected final String[] strings;
        protected final int maxLength;

        public OneOf(String ... strings) {
            this.strings = this.order(strings);
            this.maxLength = this.expectedMaxLength();
        }

        public int estimateParsedLength() {
            return this.maxLength;
        }

        public int parseInto(DateTimeParserBucket bucket, String text, int position) {
            String next = text.substring(position);
            int longest = 0;
            for (String str : this.strings) {
                if (!next.startsWith(str) || str.length() <= longest) continue;
                longest = str.length();
            }
            return position + longest;
        }

        protected String[] order(String[] strings) {
            List<String> list = Arrays.asList(strings);
            Collections.sort(list, new Comparator<String>(){

                @Override
                public int compare(String t, String t1) {
                    return t.length() - t1.length();
                }
            });
            return list.toArray(new String[list.size()]);
        }

        protected int expectedMaxLength() {
            int maxLength = 0;
            for (String str : this.strings) {
                if (str.length() <= maxLength) continue;
                maxLength = str.length();
            }
            return maxLength;
        }
    }
}

