/*
 * Decompiled with CFR 0.152.
 */
package com.crosstreelabs.phpfunctions.dateformat;

import com.crosstreelabs.phpfunctions.dateformat.AbstractPrinterParser;
import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeParserBucket;

public class LowercaseHalfOfDayPrinter
extends AbstractPrinterParser {
    public int estimatePrintedLength() {
        return 2;
    }

    @Override
    public String fromPartial(ReadablePartial partial, Locale locale) {
        return partial.getChronology().halfdayOfDay().getAsText(partial, locale).toLowerCase();
    }

    @Override
    public String fromInstant(long instant, Chronology chrono, int displayOffset, DateTimeZone displayZone, Locale locale) {
        DateTime dt = new DateTime(instant, DateTimeZone.UTC).withZoneRetainFields(displayZone);
        return dt.getChronology().halfdayOfDay().getAsText(dt.getMillis()).toLowerCase();
    }

    @Override
    public int estimateParsedLength() {
        return 4;
    }

    @Override
    public int parseInto(DateTimeParserBucket bucket, String text, int position) {
        String next = text.substring(position).trim();
        if ("pm".equalsIgnoreCase(next)) {
            bucket.saveField(DateTimeFieldType.halfdayOfDay(), 1);
            return position + 2;
        }
        if ("p.m.".equalsIgnoreCase(next)) {
            bucket.saveField(DateTimeFieldType.halfdayOfDay(), 1);
            return position + 4;
        }
        if ("am".equalsIgnoreCase(next)) {
            bucket.saveField(DateTimeFieldType.halfdayOfDay(), 0);
            return position + 2;
        }
        if ("a.m.".equalsIgnoreCase(next)) {
            bucket.saveField(DateTimeFieldType.halfdayOfDay(), 0);
            return position + 4;
        }
        return -1;
    }
}

