/*
 * Decompiled with CFR 0.152.
 */
package com.crosstreelabs.phpfunctions.dateformat;

import com.crosstreelabs.phpfunctions.dateformat.AbstractPrinterParser;
import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadablePartial;

public class SwatchInternetTimePrinter
extends AbstractPrinterParser {
    @Override
    public String fromPartial(ReadablePartial partial, Locale locale) {
        int localSeconds = partial.get(DateTimeFieldType.secondOfMinute());
        int localMinutes = partial.get(DateTimeFieldType.minuteOfHour());
        int localHours = partial.get(DateTimeFieldType.hourOfDay());
        DateTime dt = new DateTime(2000, 1, 1, localHours, localMinutes, localSeconds, DateTimeZone.getDefault()).withZone(DateTimeZone.forOffsetHours((int)1));
        return this.fromDateTime(dt);
    }

    @Override
    public String fromInstant(long instant, Chronology chrono, int displayOffset, DateTimeZone displayZone, Locale locale) {
        DateTime dt = new DateTime(instant, DateTimeZone.UTC).withZoneRetainFields(displayZone).withZone(DateTimeZone.forOffsetHours((int)1));
        return this.fromDateTime(dt);
    }

    protected String fromDateTime(DateTime dt) {
        return (int)((double)(dt.getSecondOfMinute() + dt.getMinuteOfHour() * 60 + dt.getHourOfDay() * 3600) / 86.4) + "";
    }

    public int estimatePrintedLength() {
        return 3;
    }
}

