/*
 * Decompiled with CFR 0.152.
 */
package com.cuisongliu.orderbyhelper.autoconfigure;

import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Configuration;
import tk.mybatis.orderbyhelper.OrderByHelper;

@Configuration
@ConditionalOnBean(value={SqlSessionFactory.class})
@AutoConfigureAfter(name={"org.mybatis.spring.boot.autoconfigure.MybatisAutoConfiguration", "com.github.pagehelper.autoconfigure.PageHelperAutoConfiguration"})
public class OrderByHelperAutoConfiguration {
    @Autowired
    private List<SqlSessionFactory> sqlSessionFactoryList;

    @PostConstruct
    public void addOrderByHelperInterceptor() {
        OrderByHelper interceptor = new OrderByHelper();
        for (SqlSessionFactory sqlSessionFactory : this.sqlSessionFactoryList) {
            sqlSessionFactory.getConfiguration().addInterceptor((Interceptor)interceptor);
        }
    }
}

