/*
 * Copyright 2017 CurrencyFair Ltd
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.currencyfair.onesignal.model.notification;

/**
 * Common segments for sending notifications to.
 */
public final class SegmentConstants {

    /**
     * Active Users segment.
     */
    public static final String ACTIVE_USERS = "Active Users";
    /**
     * Inactive Users segment.
     */
    public static final String INACTIVE_USERS = "Inactive Users";
    /**
     * Engaged Users segment.
     */
    public static final String ENGAGED_USERS = "Engaged Users";
    /**
     * All registered players.
     */
    public static final String ALL = "All";

    private SegmentConstants() {
    }
}
