/*
 * Decompiled with CFR 0.152.
 */
package com.currencyfair.onesignal;

import com.currencyfair.onesignal.OneSignalComms;
import com.currencyfair.onesignal.OneSignalErrorDecoder;
import com.currencyfair.onesignal.model.SuccessResponse;
import com.currencyfair.onesignal.model.app.App;
import com.currencyfair.onesignal.model.app.AppResponse;
import com.currencyfair.onesignal.model.notification.CreateNotificationResponse;
import com.currencyfair.onesignal.model.notification.NotificationRequest;
import com.currencyfair.onesignal.model.notification.ViewNotificationResponse;
import com.currencyfair.onesignal.model.notification.ViewNotificationsResponse;
import com.currencyfair.onesignal.model.player.AddDeviceResponse;
import com.currencyfair.onesignal.model.player.AddEditDeviceRequest;
import com.currencyfair.onesignal.model.player.CsvExportFileLocationRequest;
import com.currencyfair.onesignal.model.player.CsvExportFileLocationResponse;
import com.currencyfair.onesignal.model.player.Purchases;
import com.currencyfair.onesignal.model.player.Session;
import com.currencyfair.onesignal.model.player.ViewDeviceResponse;
import com.currencyfair.onesignal.model.player.ViewDevicesResponse;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import feign.Feign;
import feign.Logger;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import feign.slf4j.Slf4jLogger;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.apache.commons.io.FileUtils;

public final class OneSignal {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private OneSignal() {
    }

    public static CreateNotificationResponse createNotification(String appAuthKey, NotificationRequest notificationRequest) {
        return OneSignal.oneSignal().createNotification(appAuthKey, notificationRequest);
    }

    public static void cancelNotification(String appAuthKey, String appId, String notificationId) {
        OneSignal.oneSignal().cancelNotification(appAuthKey, appId, notificationId);
    }

    public static ViewNotificationResponse viewNotification(String appAuthKey, String appId, String notificationId) {
        return OneSignal.oneSignal().viewNotification(appAuthKey, appId, notificationId);
    }

    public static ViewNotificationsResponse viewNotifications(String appAuthKey, String appId, Number limit, Number offset) {
        return OneSignal.oneSignal().viewNotifications(appAuthKey, appId, limit, offset);
    }

    public static void trackOpen(String appId, String notificationId) {
        OneSignal.oneSignal().trackOpen(appId, notificationId);
    }

    public static List<AppResponse> viewApps(String userAuthKey) {
        return OneSignal.oneSignal().viewApps(userAuthKey);
    }

    public static AppResponse viewApp(String userAuthKey, String appId) {
        return OneSignal.oneSignal().viewApp(userAuthKey, appId);
    }

    public static AppResponse createApp(String userAuthKey, App app) {
        return OneSignal.oneSignal().createApp(userAuthKey, app);
    }

    public static AppResponse updateApp(String userAuthKey, App app) {
        return OneSignal.oneSignal().updateApp(userAuthKey, app.getId(), app);
    }

    public static ViewDevicesResponse viewDevices(String appAuthKey, String appId, Number limit, Number offset) {
        return OneSignal.oneSignal().viewDevices(appAuthKey, appId, limit, offset);
    }

    public static ViewDeviceResponse viewDevice(String appAuthKey, String appId, String deviceId) {
        return OneSignal.oneSignal().viewDevice(appAuthKey, appId, deviceId);
    }

    public static AddDeviceResponse addDevice(AddEditDeviceRequest device) {
        return OneSignal.oneSignal().addDevice(device);
    }

    public static SuccessResponse editDevice(String deviceId, AddEditDeviceRequest device) {
        return OneSignal.oneSignal().editDevice(deviceId, device);
    }

    public static SuccessResponse newSession(String deviceId, Session session) {
        return OneSignal.oneSignal().newSession(deviceId, session);
    }

    public static SuccessResponse newPurchase(String deviceId, Purchases purchases) {
        return OneSignal.oneSignal().newPurchase(deviceId, purchases);
    }

    public static SuccessResponse incrementSessionLength(String deviceId, Long activeTime) {
        return OneSignal.oneSignal().incrementSessionLength(deviceId, activeTime);
    }

    public static CsvExportFileLocationResponse csvExportFileLocation(String appAuthKey, String appId, CsvExportFileLocationRequest csvExportFileLocationRequest) {
        return OneSignal.oneSignal().csvExportLocation(appAuthKey, appId, csvExportFileLocationRequest == null ? new CsvExportFileLocationRequest() : csvExportFileLocationRequest);
    }

    public static void csvExportFileDownload(URL url, File location) throws IOException {
        FileUtils.copyURLToFile((URL)url, (File)location);
    }

    private static OneSignalComms oneSignal() {
        JacksonDecoder decoder = new JacksonDecoder(OBJECT_MAPPER);
        return (OneSignalComms)Feign.builder().encoder((Encoder)new JacksonEncoder(OBJECT_MAPPER)).decoder((Decoder)decoder).decode404().errorDecoder((ErrorDecoder)new OneSignalErrorDecoder((Decoder)decoder)).logger((Logger)new Slf4jLogger()).logLevel(Logger.Level.FULL).target(OneSignalComms.class, "https://onesignal.com/api/v1");
    }

    static {
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        OBJECT_MAPPER.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    }
}

