/*
 * Decompiled with CFR 0.152.
 */
package com.currencyfair.onesignal;

import com.currencyfair.onesignal.model.SuccessResponse;
import com.currencyfair.onesignal.model.app.App;
import com.currencyfair.onesignal.model.app.AppResponse;
import com.currencyfair.onesignal.model.notification.CreateNotificationResponse;
import com.currencyfair.onesignal.model.notification.NotificationRequest;
import com.currencyfair.onesignal.model.notification.ViewNotificationResponse;
import com.currencyfair.onesignal.model.notification.ViewNotificationsResponse;
import com.currencyfair.onesignal.model.player.AddDeviceResponse;
import com.currencyfair.onesignal.model.player.AddEditDeviceRequest;
import com.currencyfair.onesignal.model.player.CsvExportFileLocationRequest;
import com.currencyfair.onesignal.model.player.CsvExportFileLocationResponse;
import com.currencyfair.onesignal.model.player.Purchases;
import com.currencyfair.onesignal.model.player.Session;
import com.currencyfair.onesignal.model.player.ViewDeviceResponse;
import com.currencyfair.onesignal.model.player.ViewDevicesResponse;
import feign.Body;
import feign.Headers;
import feign.Param;
import feign.RequestLine;
import java.util.List;

@Headers(value={"Accept: application/json"})
public interface OneSignalComms {
    public static final String JSON_CONTENT_TYPE_HEADER = "Content-Type: application/json; charset=utf-8";

    @RequestLine(value="POST /notifications")
    @Headers(value={"Authorization: Basic {appAuthKey}", "Content-Type: application/json; charset=utf-8"})
    public CreateNotificationResponse createNotification(@Param(value="appAuthKey") String var1, NotificationRequest var2);

    @RequestLine(value="DELETE /notifications/{id}?app_id={appId}")
    @Headers(value={"Authorization: Basic {appAuthKey}"})
    public void cancelNotification(@Param(value="appAuthKey") String var1, @Param(value="appId") String var2, @Param(value="id") String var3);

    @RequestLine(value="GET /notifications/{id}?app_id={appId}")
    @Headers(value={"Authorization: Basic {appAuthKey}"})
    public ViewNotificationResponse viewNotification(@Param(value="appAuthKey") String var1, @Param(value="appId") String var2, @Param(value="id") String var3);

    @RequestLine(value="GET /notifications?app_id={appId}&limit={limit}&offset={offset}")
    @Headers(value={"Authorization: Basic {appAuthKey}"})
    public ViewNotificationsResponse viewNotifications(@Param(value="appAuthKey") String var1, @Param(value="appId") String var2, @Param(value="limit") Number var3, @Param(value="offset") Number var4);

    @RequestLine(value="PUT /notifications/{id}")
    @Headers(value={"Content-Type: application/json; charset=utf-8"})
    @Body(value="%7B\"opened\": true, \"app_id\": \"{appId}\"%7D")
    public void trackOpen(@Param(value="appId") String var1, @Param(value="id") String var2);

    @RequestLine(value="GET /apps")
    @Headers(value={"Authorization: Basic {userAuthKey}"})
    public List<AppResponse> viewApps(@Param(value="userAuthKey") String var1);

    @RequestLine(value="GET /apps/{id}")
    @Headers(value={"Authorization: Basic {userAuthKey}"})
    public AppResponse viewApp(@Param(value="userAuthKey") String var1, @Param(value="id") String var2);

    @RequestLine(value="POST /apps")
    @Headers(value={"Authorization: Basic {userAuthKey}", "Content-Type: application/json; charset=utf-8"})
    public AppResponse createApp(@Param(value="userAuthKey") String var1, App var2);

    @RequestLine(value="PUT /apps/{id}")
    @Headers(value={"Authorization: Basic {userAuthKey}", "Content-Type: application/json; charset=utf-8"})
    public AppResponse updateApp(@Param(value="userAuthKey") String var1, @Param(value="id") String var2, App var3);

    @RequestLine(value="GET /players?app_id={appId}&limit={limit}&offset={offset}")
    @Headers(value={"Authorization: Basic {appAuthKey}"})
    public ViewDevicesResponse viewDevices(@Param(value="appAuthKey") String var1, @Param(value="appId") String var2, @Param(value="limit") Number var3, @Param(value="offset") Number var4);

    @RequestLine(value="GET /players/{id}?app_id={appId}")
    @Headers(value={"Authorization: Basic {appAuthKey}"})
    public ViewDeviceResponse viewDevice(@Param(value="appAuthKey") String var1, @Param(value="appId") String var2, @Param(value="id") String var3);

    @RequestLine(value="POST /players")
    @Headers(value={"Content-Type: application/json; charset=utf-8"})
    public AddDeviceResponse addDevice(AddEditDeviceRequest var1);

    @RequestLine(value="PUT /players/{id}")
    @Headers(value={"Content-Type: application/json; charset=utf-8"})
    public SuccessResponse editDevice(@Param(value="id") String var1, AddEditDeviceRequest var2);

    @RequestLine(value="POST /players/{id}/on_session")
    @Headers(value={"Content-Type: application/json; charset=utf-8"})
    public SuccessResponse newSession(@Param(value="id") String var1, Session var2);

    @RequestLine(value="POST /players/{id}/on_purchase")
    @Headers(value={"Content-Type: application/json; charset=utf-8"})
    public SuccessResponse newPurchase(@Param(value="id") String var1, Purchases var2);

    @RequestLine(value="POST /players/{id}/on_focus")
    @Headers(value={"Content-Type: application/json; charset=utf-8"})
    @Body(value="%7B\"state\": \"ping\", \"active_time\": \"{activeTime}\"%7D")
    public SuccessResponse incrementSessionLength(@Param(value="id") String var1, @Param(value="activeTime") Long var2);

    @RequestLine(value="POST /players/csv_export?app_id={appId}")
    @Headers(value={"Authorization: Basic {appAuthKey}", "Content-Type: application/json; charset=utf-8"})
    public CsvExportFileLocationResponse csvExportLocation(@Param(value="appAuthKey") String var1, @Param(value="appId") String var2, CsvExportFileLocationRequest var3);
}

