/*
 * Decompiled with CFR 0.152.
 */
package com.currencyfair.onesignal.model.player;

import com.currencyfair.onesignal.model.player.AdId;
import com.currencyfair.onesignal.model.player.Session;
import java.util.HashMap;
import java.util.Map;

public final class SessionBuilder {
    private String identifier;
    private String language;
    private Integer timezone;
    private String gameVersion;
    private String deviceOs;
    private AdId adId;
    private String sdk;
    private Map<String, String> tags = new HashMap<String, String>();

    private SessionBuilder() {
    }

    public static SessionBuilder aSession() {
        return new SessionBuilder();
    }

    public SessionBuilder withIdentifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    public SessionBuilder withLanguage(String language) {
        this.language = language;
        return this;
    }

    public SessionBuilder withTimezone(Integer timezone) {
        this.timezone = timezone;
        return this;
    }

    public SessionBuilder withGameVersion(String gameVersion) {
        this.gameVersion = gameVersion;
        return this;
    }

    public SessionBuilder withDeviceOs(String deviceOs) {
        this.deviceOs = deviceOs;
        return this;
    }

    public SessionBuilder withAdId(AdId adId) {
        this.adId = adId;
        return this;
    }

    public SessionBuilder withSdk(String sdk) {
        this.sdk = sdk;
        return this;
    }

    public SessionBuilder withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public SessionBuilder withTag(String key, String value) {
        this.tags.put(key, value);
        return this;
    }

    public Session build() {
        Session session = new Session();
        session.setIdentifier(this.identifier);
        session.setLanguage(this.language);
        session.setTimezone(this.timezone);
        session.setGameVersion(this.gameVersion);
        session.setDeviceOs(this.deviceOs);
        session.setAdId(this.adId);
        session.setSdk(this.sdk);
        session.setTags(this.tags);
        return session;
    }
}

