/*
 * Decompiled with CFR 0.152.
 */
package com.cxytiandi.encrypt.core;

import com.cxytiandi.encrypt.algorithm.AesEncryptAlgorithm;
import com.cxytiandi.encrypt.algorithm.EncryptAlgorithm;
import com.cxytiandi.encrypt.core.EncryptionConfig;
import com.cxytiandi.encrypt.core.EncryptionReqestWrapper;
import com.cxytiandi.encrypt.core.EncryptionResponseWrapper;
import com.cxytiandi.encrypt.util.RequestUriUtils;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.HandlerMapping;

public class EncryptionFilter
implements Filter {
    private Logger logger = LoggerFactory.getLogger(EncryptionFilter.class);
    private EncryptionConfig encryptionConfig;
    private EncryptAlgorithm encryptAlgorithm = new AesEncryptAlgorithm();
    private DispatcherServlet dispatcherServlet;
    private AntPathMatcher antPathMatcher = new AntPathMatcher();

    public EncryptionFilter() {
        this.encryptionConfig = new EncryptionConfig();
    }

    public EncryptionFilter(EncryptionConfig config) {
        this.encryptionConfig = config;
    }

    public EncryptionFilter(EncryptionConfig config, DispatcherServlet dispatcherServlet) {
        this.encryptionConfig = config;
        this.dispatcherServlet = dispatcherServlet;
    }

    public EncryptionFilter(EncryptionConfig config, EncryptAlgorithm encryptAlgorithm, DispatcherServlet dispatcherServlet) {
        this.encryptionConfig = config;
        this.encryptAlgorithm = encryptAlgorithm;
        this.dispatcherServlet = dispatcherServlet;
    }

    public EncryptionFilter(String key) {
        EncryptionConfig config = new EncryptionConfig();
        config.setKey(key);
        this.encryptionConfig = config;
    }

    public EncryptionFilter(String key, List<String> responseEncryptUriList, List<String> requestDecryptUriList, String responseCharset, boolean debug) {
        this.encryptionConfig = new EncryptionConfig(key, responseEncryptUriList, requestDecryptUriList, responseCharset, debug);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        String uri = req.getRequestURI();
        this.logger.debug("RequestURI: {}", (Object)uri);
        if (this.encryptionConfig.isDebug()) {
            chain.doFilter((ServletRequest)req, (ServletResponse)resp);
            return;
        }
        boolean decryptionStatus = this.contains(this.encryptionConfig.getRequestDecryptUriList(), uri, req.getMethod(), req);
        boolean encryptionStatus = this.contains(this.encryptionConfig.getResponseEncryptUriList(), uri, req.getMethod(), req);
        boolean decryptionIgnoreStatus = this.contains(this.encryptionConfig.getRequestDecryptUriIgnoreList(), uri, req.getMethod(), req);
        boolean encryptionIgnoreStatus = this.contains(this.encryptionConfig.getResponseEncryptUriIgnoreList(), uri, req.getMethod(), req);
        if (CollectionUtils.isEmpty(this.encryptionConfig.getRequestDecryptUriList()) && CollectionUtils.isEmpty(this.encryptionConfig.getResponseEncryptUriList())) {
            decryptionStatus = true;
            encryptionStatus = true;
        }
        if (encryptionIgnoreStatus) {
            encryptionStatus = false;
        }
        if (decryptionIgnoreStatus) {
            decryptionStatus = false;
        }
        if (!decryptionStatus && !encryptionStatus) {
            chain.doFilter((ServletRequest)req, (ServletResponse)resp);
            return;
        }
        EncryptionResponseWrapper responseWrapper = null;
        EncryptionReqestWrapper requestWrapper = null;
        if (decryptionStatus) {
            requestWrapper = new EncryptionReqestWrapper(req);
            this.processDecryption(requestWrapper, req);
        }
        if (encryptionStatus) {
            responseWrapper = new EncryptionResponseWrapper(resp);
        }
        if (encryptionStatus && decryptionStatus) {
            chain.doFilter((ServletRequest)requestWrapper, (ServletResponse)responseWrapper);
        } else if (encryptionStatus) {
            chain.doFilter((ServletRequest)req, (ServletResponse)responseWrapper);
        } else if (decryptionStatus) {
            chain.doFilter((ServletRequest)requestWrapper, (ServletResponse)resp);
        }
        if (encryptionStatus) {
            String responseData = responseWrapper.getResponseData();
            this.writeEncryptContent(responseData, response);
        }
    }

    private void processDecryption(EncryptionReqestWrapper requestWrapper, HttpServletRequest req) {
        String requestData = requestWrapper.getRequestData();
        String uri = req.getRequestURI();
        this.logger.debug("RequestData: {}", (Object)requestData);
        try {
            if (!StringUtils.endsWithIgnoreCase((String)req.getMethod(), (String)RequestMethod.GET.name())) {
                String decryptRequestData = this.encryptAlgorithm.decrypt(requestData, this.encryptionConfig.getKey());
                this.logger.debug("DecryptRequestData: {}", (Object)decryptRequestData);
                requestWrapper.setRequestData(decryptRequestData);
            }
            HashMap<String, String> paramMap = new HashMap<String, String>();
            Enumeration parameterNames = req.getParameterNames();
            while (parameterNames.hasMoreElements()) {
                String paramName = (String)parameterNames.nextElement();
                String prefixUri = req.getMethod().toLowerCase() + ":" + uri;
                if (!this.encryptionConfig.getRequestDecryptParams(prefixUri).contains(paramName)) continue;
                String paramValue = req.getParameter(paramName);
                String decryptParamValue = this.encryptAlgorithm.decrypt(paramValue, this.encryptionConfig.getKey());
                paramMap.put(paramName, decryptParamValue);
            }
            requestWrapper.setParamMap(paramMap);
        }
        catch (Exception e) {
            this.logger.error("\u8bf7\u6c42\u6570\u636e\u89e3\u5bc6\u5931\u8d25", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void writeEncryptContent(String responseData, ServletResponse response) throws IOException {
        this.logger.debug("ResponseData: {}", (Object)responseData);
        ServletOutputStream out = null;
        try {
            responseData = this.encryptAlgorithm.encrypt(responseData, this.encryptionConfig.getKey());
            this.logger.debug("EncryptResponseData: {}", (Object)responseData);
            response.setContentLength(responseData.length());
            response.setCharacterEncoding(this.encryptionConfig.getResponseCharset());
            out = response.getOutputStream();
            out.write(responseData.getBytes(this.encryptionConfig.getResponseCharset()));
        }
        catch (Exception e) {
            this.logger.error("\u54cd\u5e94\u6570\u636e\u52a0\u5bc6\u5931\u8d25", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
        }
    }

    private boolean contains(List<String> list, String uri, String methodType, HttpServletRequest request) {
        if (list.contains(uri)) {
            return true;
        }
        String prefixUri = methodType.toLowerCase() + ":" + uri;
        this.logger.debug("contains uri: {}", (Object)prefixUri);
        if (list.contains(prefixUri)) {
            return true;
        }
        for (String u : list) {
            boolean match = this.antPathMatcher.match(u, prefixUri);
            if (!match) continue;
            return true;
        }
        try {
            HandlerMethod handlerMethod;
            String apiUri;
            HandlerExecutionChain handler = this.getHandler(request);
            if (Objects.isNull(handler)) {
                return false;
            }
            if (Objects.nonNull(handler.getHandler()) && handler.getHandler() instanceof HandlerMethod && list.contains(apiUri = RequestUriUtils.getApiUri((handlerMethod = (HandlerMethod)handler.getHandler()).getClass(), handlerMethod.getMethod(), request.getContextPath()))) {
                return true;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    protected HandlerExecutionChain getHandler(HttpServletRequest request) throws Exception {
        if (Objects.isNull(this.dispatcherServlet)) {
            return null;
        }
        if (this.dispatcherServlet.getHandlerMappings() != null) {
            for (HandlerMapping mapping : this.dispatcherServlet.getHandlerMappings()) {
                HandlerExecutionChain handler = mapping.getHandler(request);
                if (handler == null) continue;
                return handler;
            }
        }
        return null;
    }

    public void destroy() {
    }
}

