/*
 * Decompiled with CFR 0.152.
 */
package com.cxytiandi.encrypt.springboot.autoconfigure;

import com.cxytiandi.encrypt.algorithm.EncryptAlgorithm;
import com.cxytiandi.encrypt.core.EncryptionConfig;
import com.cxytiandi.encrypt.core.EncryptionFilter;
import com.cxytiandi.encrypt.springboot.endpoint.EncryptEndpoint;
import com.cxytiandi.encrypt.springboot.init.ApiEncryptDataInit;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.DispatcherServlet;

@Configuration
@EnableAutoConfiguration
@EnableConfigurationProperties(value={EncryptionConfig.class})
public class EncryptAutoConfiguration {
    @Autowired
    private EncryptionConfig encryptionConfig;
    @Autowired(required=false)
    private EncryptAlgorithm encryptAlgorithm;
    @Autowired(required=false)
    private DispatcherServlet dispatcherServlet;

    @Bean
    public FilterRegistrationBean filterRegistration() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        if (this.encryptAlgorithm != null) {
            registration.setFilter((Filter)new EncryptionFilter(this.encryptionConfig, this.encryptAlgorithm, this.dispatcherServlet));
        } else {
            registration.setFilter((Filter)new EncryptionFilter(this.encryptionConfig, this.dispatcherServlet));
        }
        registration.addUrlPatterns(this.encryptionConfig.getUrlPatterns());
        registration.setName("EncryptionFilter");
        registration.setOrder(this.encryptionConfig.getOrder());
        return registration;
    }

    @Bean
    public ApiEncryptDataInit apiEncryptDataInit() {
        return new ApiEncryptDataInit();
    }

    @Bean
    public EncryptEndpoint encryptEndpoint() {
        return new EncryptEndpoint();
    }
}

