/*
 * Decompiled with CFR 0.152.
 */
package com.cyberark.conjur.service;

import com.cyberark.conjur.sdk.ApiException;
import com.cyberark.conjur.sdk.endpoint.SecretsApi;
import com.cyberark.conjur.service.ConjurService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConjurServiceImpl
implements ConjurService {
    private final Logger LOGGER = LoggerFactory.getLogger(ConjurServiceImpl.class);
    SecretsApi secretsApi = new SecretsApi();
    Object secrets = null;

    @Override
    public Object getSecret(String account, String variable_const, String variableId) throws ApiException {
        this.LOGGER.info("Getting secret for account: {}", (Object)account);
        this.secrets = this.secretsApi.getSecret(account, "variable", variableId);
        this.LOGGER.info("Secret retrieved successfully.");
        return this.secrets;
    }

    @Override
    public Object getBatchSecrets(String variableIds, String account) throws ApiException {
        this.LOGGER.info("Getting secrets for account: {}", (Object)account);
        String[] keys = variableIds.split(",");
        StringBuilder encodeKey = new StringBuilder();
        for (String k : keys) {
            if (encodeKey.length() == 0) {
                encodeKey.append(account + ":");
                encodeKey.append("variable:");
                encodeKey.append(k);
                continue;
            }
            encodeKey.append(",");
            encodeKey.append(account + ":");
            encodeKey.append("variable:");
            encodeKey.append(k);
        }
        this.secrets = this.secretsApi.getSecrets(encodeKey.toString());
        this.LOGGER.info("Secrets retrieved successfully.");
        return this.secrets;
    }
}

