/*
 * Decompiled with CFR 0.152.
 */
package com.cyberark.conjur.core;

import com.cyberark.conjur.authentication.AccessTokenProviderImpl;
import com.cyberark.conjur.constant.ConjurConstant;
import com.cyberark.conjur.domain.ConjurConfiguration;
import com.cyberark.conjur.sdk.AccessToken;
import com.cyberark.conjur.sdk.ApiClient;
import com.cyberark.conjur.sdk.ApiException;
import com.cyberark.conjur.sdk.Configuration;
import com.cyberark.conjur.sdk.endpoint.SecretsApi;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConjurConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConjurConnection.class);

    public static ApiClient getConnection(ConjurConfiguration config) throws ApiException {
        LOGGER.debug("Start: Calling getConnection()");
        AccessToken accessToken = null;
        ApiClient client = Configuration.getDefaultApiClient();
        AccessTokenProviderImpl accessTokenProvider = new AccessTokenProviderImpl();
        String conjurAccount = config.getConjurAccount();
        String conjurBasePath = config.getConjurApplianceUrl();
        String conjurUserName = config.getConjurAuthnLogin();
        String conjurApiKey = config.getConjurApiKey();
        String sslCertificate = config.getConjurSslCertificate();
        String certFile = config.getConjurCertFile();
        client.setAccount(conjurAccount);
        client.setBasePath(conjurBasePath);
        client.setUsername(conjurUserName);
        client.setApiKey(conjurApiKey);
        FileInputStream sslInputStream = null;
        try {
            if (StringUtils.isNotEmpty((CharSequence)sslCertificate)) {
                sslInputStream = new FileInputStream(sslCertificate);
            } else if (StringUtils.isNotEmpty((CharSequence)certFile)) {
                sslInputStream = new FileInputStream(certFile);
            }
            if (sslInputStream != null) {
                client.setSslCaCert((InputStream)sslInputStream);
                ((InputStream)sslInputStream).close();
            }
        }
        catch (IOException ex) {
            LOGGER.error("Error processing CERT_FILE: {}", (Object)ex.getMessage());
        }
        if (conjurApiKey != null && !conjurApiKey.isEmpty()) {
            try {
                accessToken = accessTokenProvider.getNewAccessToken(client);
                String token = accessToken.getHeaderValue();
                client.setAccessToken(token);
                Configuration.setDefaultApiClient((ApiClient)client);
                LOGGER.debug("StatusCode:200_OKConnection with Conjur is successful");
            }
            catch (Exception ex) {
                throw new ApiException((Throwable)ex);
            }
        }
        return client;
    }

    public static String getAccount(SecretsApi secretApi) {
        ApiClient apiClient = secretApi.getApiClient();
        return apiClient != null ? apiClient.getAccount() : ConjurConstant.CONJUR_ACCOUNT;
    }

    public static String obfuscateString(String str) {
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{str}) && str.length() > 2) {
            int len = str.length();
            char first = str.charAt(0);
            char last = str.charAt(len - 1);
            String middle = "*******";
            return first + middle + last;
        }
        return str;
    }
}

