/*
 * Decompiled with CFR 0.152.
 */
package com.cyberark.conjur.mulesoft.internal;

import com.cyberark.conjur.core.ConjurConnection;
import com.cyberark.conjur.domain.ConjurConfiguration;
import com.cyberark.conjur.error.ConjurErrorProvider;
import com.cyberark.conjur.error.ConjurErrorTypes;
import com.cyberark.conjur.mulesoft.internal.ConjurMuleConnection;
import com.cyberark.conjur.sdk.endpoint.SecretsApi;
import com.cyberark.conjur.service.ConjurService;
import com.cyberark.conjur.service.ConjurServiceImpl;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.stereotype.Validator;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConjurMuleConnectionProvider
implements ConnectionProvider<ConjurMuleConnection> {
    private final Logger LOGGER = LoggerFactory.getLogger(ConjurMuleConnectionProvider.class);
    @Parameter
    private String conjurAccount;
    @Parameter
    private String conjurApplianceUrl;
    @Parameter
    private String conjurAuthnLogin;
    @Parameter
    @Optional
    private String conjurApiKey;
    @Parameter
    @Optional
    private String conjurSslCertificate;
    @Parameter
    @Optional
    private String conjurCertFile;
    @Parameter
    private String key;
    private SecretsApi secretsApi = new SecretsApi();
    ConjurService conjurService = new ConjurServiceImpl();
    Object secretValue;
    int errorCode;
    String errorMsg;
    String uniqueID = UUID.randomUUID().toString();
    ConjurConfiguration config = new ConjurConfiguration();

    public ConjurMuleConnection connect() throws ConnectionException {
        this.LOGGER.info("Calling Demo Connection Provider connect()");
        try {
            boolean errorFlag = this.isValidParameters(this.conjurAccount, this.conjurApplianceUrl, this.conjurAuthnLogin, this.conjurApiKey, this.conjurSslCertificate);
            if (!errorFlag) {
                this.config.setConjurAccount(this.conjurAccount);
                this.config.setConjurApplianceUrl(this.conjurApplianceUrl);
                this.config.setConjurAuthnLogin(this.conjurAuthnLogin);
                this.config.setConjurApiKey(this.conjurApiKey);
                this.config.setConjurSslCertificate(this.conjurSslCertificate);
                this.config.setConjurCertFile(this.conjurCertFile);
            }
            ConjurConnection.getConnection(this.config);
            String account = ConjurConnection.getAccount(this.secretsApi);
            String[] keys = this.key.split(",");
            this.secretValue = keys.length > 1 ? this.conjurService.getBatchSecrets(this.key, account) : this.conjurService.getSecret(account, "variable", this.key);
        }
        catch (Exception e) {
            throw new ModuleException((ErrorTypeDefinition)ConjurErrorTypes.INVALID_DATA, (Throwable)new ConnectionException(e.getCause()));
        }
        return new ConjurMuleConnection(this.uniqueID, this.secretValue, this.errorCode, this.errorMsg);
    }

    public void disconnect(ConjurMuleConnection connection) {
        connection.invalidate();
    }

    public ConnectionValidationResult validate(ConjurMuleConnection connection) {
        return ConnectionValidationResult.success();
    }

    @Validator
    @Throws(value={ConjurErrorProvider.class})
    public boolean isValidParameters(String conjurAccount, String conjurApplianceUrl, String conjurAuthnLogin, String conjurApiKey, String conjurSslCertificate) throws Exception {
        boolean errorFlag = false;
        if (StringUtils.isEmpty((CharSequence)conjurAccount)) {
            errorFlag = true;
            throw new ModuleException((ErrorTypeDefinition)ConjurErrorTypes.INVALID_DATA, (Throwable)new Exception("Missing or invalid ConjurAccount"));
        }
        if (StringUtils.isEmpty((CharSequence)conjurApplianceUrl)) {
            errorFlag = true;
            throw new ModuleException((ErrorTypeDefinition)ConjurErrorTypes.INVALID_DATA, (Throwable)new Exception("Missing or invalid Conjur BaseUrl/ApplianceUrl"));
        }
        if (StringUtils.isEmpty((CharSequence)conjurAuthnLogin)) {
            errorFlag = true;
            throw new ModuleException((ErrorTypeDefinition)ConjurErrorTypes.INVALID_DATA, (Throwable)new Exception("Missing or invalid Conjur AuthnLogin"));
        }
        if (StringUtils.isEmpty((CharSequence)conjurApiKey)) {
            errorFlag = true;
            throw new ModuleException((ErrorTypeDefinition)ConjurErrorTypes.INVALID_DATA, (Throwable)new Exception("Missing or invalid API KEY"));
        }
        if (StringUtils.isEmpty((CharSequence)conjurSslCertificate)) {
            errorFlag = true;
            throw new ModuleException((ErrorTypeDefinition)ConjurErrorTypes.INVALID_DATA, (Throwable)new Exception("Missing or invalid Conjur SSLCertificate"));
        }
        return errorFlag;
    }
}

