/*
 * Decompiled with CFR 0.152.
 */
package com.cyberark.conjur.domain;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConjurConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConjurConfiguration.class);
    private String integrationName = System.getenv().getOrDefault("INTEGRATION_NAME", "Mulesoft Connector");
    private String integrationType = System.getenv().getOrDefault("INTEGRATION_TYPE", "cybr-secretsmanager-mulesoft");
    private String integrationVersion = null;
    private String vendorName = System.getenv().getOrDefault("VENDOR_NAME", "MuleSoft");
    @Parameter
    private String configId;
    @Parameter
    private String conjurAccount;
    @Parameter
    private String conjurApplianceUrl;
    @Parameter
    private String conjurAuthnLogin;
    @Parameter
    private String conjurApiKey;
    @Parameter
    private String conjurSslCertificate;
    @Parameter
    private String conjurCertFile;

    public String getIntegrationName() {
        return this.integrationName;
    }

    public String getIntegrationType() {
        return this.integrationType;
    }

    public String getIntegrationVersion() {
        if (this.integrationVersion == null) {
            this.integrationVersion = ConjurConfiguration.getSDKVersion();
        }
        return this.integrationVersion;
    }

    public String getVendorName() {
        return this.vendorName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getSDKVersion() {
        String fallbackVersion = "unset";
        String changelogFilePath = "/CHANGELOG.md";
        Pattern versionPattern = Pattern.compile("## \\[([\\d]+(?:\\.[\\d]+)*)\\]");
        InputStream inputStream = ConjurConfiguration.class.getResourceAsStream(changelogFilePath);
        if (inputStream == null) {
            LOGGER.warn("CHANGELOG.md file not found.");
            return "unset";
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            String line;
            Matcher matcher;
            do {
                if ((line = reader.readLine()) == null) return "unset";
            } while (!(matcher = versionPattern.matcher(line)).find());
            String string = matcher.group(1);
            return string;
        }
        catch (IOException e) {
            LOGGER.warn("Error reading CHANGELOG.md from the JAR.", (Throwable)e);
        }
        return "unset";
    }

    public String getConfigId() {
        return this.configId;
    }

    public String getConjurAccount() {
        return this.conjurAccount;
    }

    public String getConjurApplianceUrl() {
        return this.conjurApplianceUrl;
    }

    public String getConjurAuthnLogin() {
        return this.conjurAuthnLogin;
    }

    public String getConjurApiKey() {
        return this.conjurApiKey;
    }

    public String getConjurSslCertificate() {
        return this.conjurSslCertificate;
    }

    public String getConjurCertFile() {
        return this.conjurCertFile;
    }

    public void setConfigId(String configId) {
        this.configId = configId;
    }

    public void setConjurAccount(String conjurAccount) {
        this.conjurAccount = conjurAccount;
    }

    public void setConjurApplianceUrl(String conjurApplianceUrl) {
        this.conjurApplianceUrl = conjurApplianceUrl;
    }

    public void setConjurAuthnLogin(String conjurAuthnLogin) {
        this.conjurAuthnLogin = conjurAuthnLogin;
    }

    public void setConjurApiKey(String conjurApiKey) {
        this.conjurApiKey = conjurApiKey;
    }

    public void setConjurSslCertificate(String conjurSslCertificate) {
        this.conjurSslCertificate = conjurSslCertificate;
    }

    public void setConjurCertFile(String conjurCertFile) {
        this.conjurCertFile = conjurCertFile;
    }
}

