/*
 * Decompiled with CFR 0.152.
 */
package com.cyberark.conjur.sdk.endpoint;

import com.cyberark.conjur.sdk.ApiCallback;
import com.cyberark.conjur.sdk.ApiClient;
import com.cyberark.conjur.sdk.ApiException;
import com.cyberark.conjur.sdk.ApiResponse;
import com.cyberark.conjur.sdk.Configuration;
import com.cyberark.conjur.sdk.Pair;
import com.cyberark.conjur.sdk.model.ServiceAuthenticators;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class AuthenticationApi {
    private ApiClient localVarApiClient;

    public AuthenticationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AuthenticationApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call changePasswordCall(String account, String body, String xRequestId, ApiCallback _callback) throws ApiException {
        String localVarPostBody = body;
        String localVarPath = "/authn/{account}/password".replaceAll("\\{account\\}", this.localVarApiClient.escapeString(account.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xRequestId != null) {
            localVarHeaderParams.put("X-Request-Id", this.localVarApiClient.parameterToString(xRequestId));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"text/plain"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call changePasswordValidateBeforeCall(String account, String body, String xRequestId, ApiCallback _callback) throws ApiException {
        if (account == null) {
            throw new ApiException("Missing the required parameter 'account' when calling changePassword(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling changePassword(Async)");
        }
        Call localVarCall = this.changePasswordCall(account, body, xRequestId, _callback);
        return localVarCall;
    }

    public void changePassword(String account, String body, String xRequestId) throws ApiException {
        this.changePasswordWithHttpInfo(account, body, xRequestId);
    }

    public void changePassword(String account, String body) throws ApiException {
        this.changePasswordWithHttpInfo(account, body, null);
    }

    public ApiResponse<Void> changePasswordWithHttpInfo(String account, String body, String xRequestId) throws ApiException {
        Call localVarCall = this.changePasswordValidateBeforeCall(account, body, xRequestId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public ApiResponse<Void> changePasswordWithHttpInfo(String account, String body) throws ApiException {
        Call localVarCall = this.changePasswordValidateBeforeCall(account, body, null, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call changePasswordAsync(String account, String body, String xRequestId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.changePasswordValidateBeforeCall(account, body, xRequestId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call enableAuthenticatorInstanceCall(ServiceAuthenticators authenticator, String serviceId, String account, String xRequestId, Boolean enabled, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/{authenticator}/{service_id}/{account}".replaceAll("\\{authenticator\\}", this.localVarApiClient.escapeString(authenticator.toString())).replaceAll("\\{service_id\\}", this.localVarApiClient.escapeString(serviceId.toString())).replaceAll("\\{account\\}", this.localVarApiClient.escapeString(account.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xRequestId != null) {
            localVarHeaderParams.put("X-Request-Id", this.localVarApiClient.parameterToString(xRequestId));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (enabled != null) {
            localVarFormParams.put("enabled", enabled);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[0])) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"conjurAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call enableAuthenticatorInstanceValidateBeforeCall(ServiceAuthenticators authenticator, String serviceId, String account, String xRequestId, Boolean enabled, ApiCallback _callback) throws ApiException {
        if (authenticator == null) {
            throw new ApiException("Missing the required parameter 'authenticator' when calling enableAuthenticatorInstance(Async)");
        }
        if (serviceId == null) {
            throw new ApiException("Missing the required parameter 'serviceId' when calling enableAuthenticatorInstance(Async)");
        }
        if (account == null) {
            throw new ApiException("Missing the required parameter 'account' when calling enableAuthenticatorInstance(Async)");
        }
        Call localVarCall = this.enableAuthenticatorInstanceCall(authenticator, serviceId, account, xRequestId, enabled, _callback);
        return localVarCall;
    }

    public void enableAuthenticatorInstance(ServiceAuthenticators authenticator, String serviceId, String account, String xRequestId, Boolean enabled) throws ApiException {
        this.enableAuthenticatorInstanceWithHttpInfo(authenticator, serviceId, account, xRequestId, enabled);
    }

    public void enableAuthenticatorInstance(ServiceAuthenticators authenticator, String serviceId, String account) throws ApiException {
        this.enableAuthenticatorInstanceWithHttpInfo(authenticator, serviceId, account, null, null);
    }

    public ApiResponse<Void> enableAuthenticatorInstanceWithHttpInfo(ServiceAuthenticators authenticator, String serviceId, String account, String xRequestId, Boolean enabled) throws ApiException {
        Call localVarCall = this.enableAuthenticatorInstanceValidateBeforeCall(authenticator, serviceId, account, xRequestId, enabled, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public ApiResponse<Void> enableAuthenticatorInstanceWithHttpInfo(ServiceAuthenticators authenticator, String serviceId, String account) throws ApiException {
        Call localVarCall = this.enableAuthenticatorInstanceValidateBeforeCall(authenticator, serviceId, account, null, null, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call enableAuthenticatorInstanceAsync(ServiceAuthenticators authenticator, String serviceId, String account, String xRequestId, Boolean enabled, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.enableAuthenticatorInstanceValidateBeforeCall(authenticator, serviceId, account, xRequestId, enabled, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getAPIKeyCall(String account, String xRequestId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/authn/{account}/login".replaceAll("\\{account\\}", this.localVarApiClient.escapeString(account.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xRequestId != null) {
            localVarHeaderParams.put("X-Request-Id", this.localVarApiClient.parameterToString(xRequestId));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAPIKeyValidateBeforeCall(String account, String xRequestId, ApiCallback _callback) throws ApiException {
        if (account == null) {
            throw new ApiException("Missing the required parameter 'account' when calling getAPIKey(Async)");
        }
        Call localVarCall = this.getAPIKeyCall(account, xRequestId, _callback);
        return localVarCall;
    }

    public String getAPIKey(String account, String xRequestId) throws ApiException {
        ApiResponse<String> localVarResp = this.getAPIKeyWithHttpInfo(account, xRequestId);
        return localVarResp.getData();
    }

    public String getAPIKey(String account) throws ApiException {
        ApiResponse<String> localVarResp = this.getAPIKeyWithHttpInfo(account, null);
        return localVarResp.getData();
    }

    public ApiResponse<String> getAPIKeyWithHttpInfo(String account, String xRequestId) throws ApiException {
        Call localVarCall = this.getAPIKeyValidateBeforeCall(account, xRequestId, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public ApiResponse<String> getAPIKeyWithHttpInfo(String account) throws ApiException {
        Call localVarCall = this.getAPIKeyValidateBeforeCall(account, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAPIKeyAsync(String account, String xRequestId, ApiCallback<String> _callback) throws ApiException {
        Call localVarCall = this.getAPIKeyValidateBeforeCall(account, xRequestId, _callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAPIKeyViaLDAPCall(String serviceId, String account, String xRequestId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/authn-ldap/{service_id}/{account}/login".replaceAll("\\{service_id\\}", this.localVarApiClient.escapeString(serviceId.toString())).replaceAll("\\{account\\}", this.localVarApiClient.escapeString(account.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xRequestId != null) {
            localVarHeaderParams.put("X-Request-Id", this.localVarApiClient.parameterToString(xRequestId));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAPIKeyViaLDAPValidateBeforeCall(String serviceId, String account, String xRequestId, ApiCallback _callback) throws ApiException {
        if (serviceId == null) {
            throw new ApiException("Missing the required parameter 'serviceId' when calling getAPIKeyViaLDAP(Async)");
        }
        if (account == null) {
            throw new ApiException("Missing the required parameter 'account' when calling getAPIKeyViaLDAP(Async)");
        }
        Call localVarCall = this.getAPIKeyViaLDAPCall(serviceId, account, xRequestId, _callback);
        return localVarCall;
    }

    public String getAPIKeyViaLDAP(String serviceId, String account, String xRequestId) throws ApiException {
        ApiResponse<String> localVarResp = this.getAPIKeyViaLDAPWithHttpInfo(serviceId, account, xRequestId);
        return localVarResp.getData();
    }

    public String getAPIKeyViaLDAP(String serviceId, String account) throws ApiException {
        ApiResponse<String> localVarResp = this.getAPIKeyViaLDAPWithHttpInfo(serviceId, account, null);
        return localVarResp.getData();
    }

    public ApiResponse<String> getAPIKeyViaLDAPWithHttpInfo(String serviceId, String account, String xRequestId) throws ApiException {
        Call localVarCall = this.getAPIKeyViaLDAPValidateBeforeCall(serviceId, account, xRequestId, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public ApiResponse<String> getAPIKeyViaLDAPWithHttpInfo(String serviceId, String account) throws ApiException {
        Call localVarCall = this.getAPIKeyViaLDAPValidateBeforeCall(serviceId, account, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAPIKeyViaLDAPAsync(String serviceId, String account, String xRequestId, ApiCallback<String> _callback) throws ApiException {
        Call localVarCall = this.getAPIKeyViaLDAPValidateBeforeCall(serviceId, account, xRequestId, _callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAccessTokenCall(String account, String login, String body, String acceptEncoding, String xRequestId, ApiCallback _callback) throws ApiException {
        String localVarPostBody = body;
        String localVarPath = "/authn/{account}/{login}/authenticate".replaceAll("\\{account\\}", this.localVarApiClient.escapeString(account.toString())).replaceAll("\\{login\\}", this.localVarApiClient.escapeString(login.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (xRequestId != null) {
            localVarHeaderParams.put("X-Request-Id", this.localVarApiClient.parameterToString(xRequestId));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"text/plain"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAccessTokenValidateBeforeCall(String account, String login, String body, String acceptEncoding, String xRequestId, ApiCallback _callback) throws ApiException {
        if (account == null) {
            throw new ApiException("Missing the required parameter 'account' when calling getAccessToken(Async)");
        }
        if (login == null) {
            throw new ApiException("Missing the required parameter 'login' when calling getAccessToken(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling getAccessToken(Async)");
        }
        Call localVarCall = this.getAccessTokenCall(account, login, body, acceptEncoding, xRequestId, _callback);
        return localVarCall;
    }

    public String getAccessToken(String account, String login, String body, String acceptEncoding, String xRequestId) throws ApiException {
        ApiResponse<String> localVarResp = this.getAccessTokenWithHttpInfo(account, login, body, acceptEncoding, xRequestId);
        return localVarResp.getData();
    }

    public String getAccessToken(String account, String login, String body) throws ApiException {
        ApiResponse<String> localVarResp = this.getAccessTokenWithHttpInfo(account, login, body, null, null);
        return localVarResp.getData();
    }

    public ApiResponse<String> getAccessTokenWithHttpInfo(String account, String login, String body, String acceptEncoding, String xRequestId) throws ApiException {
        Call localVarCall = this.getAccessTokenValidateBeforeCall(account, login, body, acceptEncoding, xRequestId, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public ApiResponse<String> getAccessTokenWithHttpInfo(String account, String login, String body) throws ApiException {
        Call localVarCall = this.getAccessTokenValidateBeforeCall(account, login, body, null, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAccessTokenAsync(String account, String login, String body, String acceptEncoding, String xRequestId, ApiCallback<String> _callback) throws ApiException {
        Call localVarCall = this.getAccessTokenValidateBeforeCall(account, login, body, acceptEncoding, xRequestId, _callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAccessTokenViaAWSCall(String serviceId, String account, String login, String body, String acceptEncoding, String xRequestId, ApiCallback _callback) throws ApiException {
        String localVarPostBody = body;
        String localVarPath = "/authn-iam/{service_id}/{account}/{login}/authenticate".replaceAll("\\{service_id\\}", this.localVarApiClient.escapeString(serviceId.toString())).replaceAll("\\{account\\}", this.localVarApiClient.escapeString(account.toString())).replaceAll("\\{login\\}", this.localVarApiClient.escapeString(login.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (xRequestId != null) {
            localVarHeaderParams.put("X-Request-Id", this.localVarApiClient.parameterToString(xRequestId));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"text/plain"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAccessTokenViaAWSValidateBeforeCall(String serviceId, String account, String login, String body, String acceptEncoding, String xRequestId, ApiCallback _callback) throws ApiException {
        if (serviceId == null) {
            throw new ApiException("Missing the required parameter 'serviceId' when calling getAccessTokenViaAWS(Async)");
        }
        if (account == null) {
            throw new ApiException("Missing the required parameter 'account' when calling getAccessTokenViaAWS(Async)");
        }
        if (login == null) {
            throw new ApiException("Missing the required parameter 'login' when calling getAccessTokenViaAWS(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling getAccessTokenViaAWS(Async)");
        }
        Call localVarCall = this.getAccessTokenViaAWSCall(serviceId, account, login, body, acceptEncoding, xRequestId, _callback);
        return localVarCall;
    }

    public String getAccessTokenViaAWS(String serviceId, String account, String login, String body, String acceptEncoding, String xRequestId) throws ApiException {
        ApiResponse<String> localVarResp = this.getAccessTokenViaAWSWithHttpInfo(serviceId, account, login, body, acceptEncoding, xRequestId);
        return localVarResp.getData();
    }

    public String getAccessTokenViaAWS(String serviceId, String account, String login, String body) throws ApiException {
        ApiResponse<String> localVarResp = this.getAccessTokenViaAWSWithHttpInfo(serviceId, account, login, body, null, null);
        return localVarResp.getData();
    }

    public ApiResponse<String> getAccessTokenViaAWSWithHttpInfo(String serviceId, String account, String login, String body, String acceptEncoding, String xRequestId) throws ApiException {
        Call localVarCall = this.getAccessTokenViaAWSValidateBeforeCall(serviceId, account, login, body, acceptEncoding, xRequestId, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public ApiResponse<String> getAccessTokenViaAWSWithHttpInfo(String serviceId, String account, String login, String body) throws ApiException {
        Call localVarCall = this.getAccessTokenViaAWSValidateBeforeCall(serviceId, account, login, body, null, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAccessTokenViaAWSAsync(String serviceId, String account, String login, String body, String acceptEncoding, String xRequestId, ApiCallback<String> _callback) throws ApiException {
        Call localVarCall = this.getAccessTokenViaAWSValidateBeforeCall(serviceId, account, login, body, acceptEncoding, xRequestId, _callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAccessTokenViaAzureCall(String serviceId, String account, String login, String acceptEncoding, String xRequestId, String jwt, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/authn-azure/{service_id}/{account}/{login}/authenticate".replaceAll("\\{service_id\\}", this.localVarApiClient.escapeString(serviceId.toString())).replaceAll("\\{account\\}", this.localVarApiClient.escapeString(account.toString())).replaceAll("\\{login\\}", this.localVarApiClient.escapeString(login.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (xRequestId != null) {
            localVarHeaderParams.put("X-Request-Id", this.localVarApiClient.parameterToString(xRequestId));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (jwt != null) {
            localVarFormParams.put("jwt", jwt);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"text/plain"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAccessTokenViaAzureValidateBeforeCall(String serviceId, String account, String login, String acceptEncoding, String xRequestId, String jwt, ApiCallback _callback) throws ApiException {
        if (serviceId == null) {
            throw new ApiException("Missing the required parameter 'serviceId' when calling getAccessTokenViaAzure(Async)");
        }
        if (account == null) {
            throw new ApiException("Missing the required parameter 'account' when calling getAccessTokenViaAzure(Async)");
        }
        if (login == null) {
            throw new ApiException("Missing the required parameter 'login' when calling getAccessTokenViaAzure(Async)");
        }
        Call localVarCall = this.getAccessTokenViaAzureCall(serviceId, account, login, acceptEncoding, xRequestId, jwt, _callback);
        return localVarCall;
    }

    public String getAccessTokenViaAzure(String serviceId, String account, String login, String acceptEncoding, String xRequestId, String jwt) throws ApiException {
        ApiResponse<String> localVarResp = this.getAccessTokenViaAzureWithHttpInfo(serviceId, account, login, acceptEncoding, xRequestId, jwt);
        return localVarResp.getData();
    }

    public String getAccessTokenViaAzure(String serviceId, String account, String login) throws ApiException {
        ApiResponse<String> localVarResp = this.getAccessTokenViaAzureWithHttpInfo(serviceId, account, login, null, null, null);
        return localVarResp.getData();
    }

    public ApiResponse<String> getAccessTokenViaAzureWithHttpInfo(String serviceId, String account, String login, String acceptEncoding, String xRequestId, String jwt) throws ApiException {
        Call localVarCall = this.getAccessTokenViaAzureValidateBeforeCall(serviceId, account, login, acceptEncoding, xRequestId, jwt, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public ApiResponse<String> getAccessTokenViaAzureWithHttpInfo(String serviceId, String account, String login) throws ApiException {
        Call localVarCall = this.getAccessTokenViaAzureValidateBeforeCall(serviceId, account, login, null, null, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAccessTokenViaAzureAsync(String serviceId, String account, String login, String acceptEncoding, String xRequestId, String jwt, ApiCallback<String> _callback) throws ApiException {
        Call localVarCall = this.getAccessTokenViaAzureValidateBeforeCall(serviceId, account, login, acceptEncoding, xRequestId, jwt, _callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAccessTokenViaGCPCall(String account, String acceptEncoding, String xRequestId, String jwt, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/authn-gcp/{account}/authenticate".replaceAll("\\{account\\}", this.localVarApiClient.escapeString(account.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (xRequestId != null) {
            localVarHeaderParams.put("X-Request-Id", this.localVarApiClient.parameterToString(xRequestId));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (jwt != null) {
            localVarFormParams.put("jwt", jwt);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"text/plain"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAccessTokenViaGCPValidateBeforeCall(String account, String acceptEncoding, String xRequestId, String jwt, ApiCallback _callback) throws ApiException {
        if (account == null) {
            throw new ApiException("Missing the required parameter 'account' when calling getAccessTokenViaGCP(Async)");
        }
        Call localVarCall = this.getAccessTokenViaGCPCall(account, acceptEncoding, xRequestId, jwt, _callback);
        return localVarCall;
    }

    public String getAccessTokenViaGCP(String account, String acceptEncoding, String xRequestId, String jwt) throws ApiException {
        ApiResponse<String> localVarResp = this.getAccessTokenViaGCPWithHttpInfo(account, acceptEncoding, xRequestId, jwt);
        return localVarResp.getData();
    }

    public String getAccessTokenViaGCP(String account) throws ApiException {
        ApiResponse<String> localVarResp = this.getAccessTokenViaGCPWithHttpInfo(account, null, null, null);
        return localVarResp.getData();
    }

    public ApiResponse<String> getAccessTokenViaGCPWithHttpInfo(String account, String acceptEncoding, String xRequestId, String jwt) throws ApiException {
        Call localVarCall = this.getAccessTokenViaGCPValidateBeforeCall(account, acceptEncoding, xRequestId, jwt, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public ApiResponse<String> getAccessTokenViaGCPWithHttpInfo(String account) throws ApiException {
        Call localVarCall = this.getAccessTokenViaGCPValidateBeforeCall(account, null, null, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAccessTokenViaGCPAsync(String account, String acceptEncoding, String xRequestId, String jwt, ApiCallback<String> _callback) throws ApiException {
        Call localVarCall = this.getAccessTokenViaGCPValidateBeforeCall(account, acceptEncoding, xRequestId, jwt, _callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAccessTokenViaJWTCall(String account, String serviceId, String xRequestId, String jwt, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/authn-jwt/{service_id}/{account}/authenticate".replaceAll("\\{account\\}", this.localVarApiClient.escapeString(account.toString())).replaceAll("\\{service_id\\}", this.localVarApiClient.escapeString(serviceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xRequestId != null) {
            localVarHeaderParams.put("X-Request-Id", this.localVarApiClient.parameterToString(xRequestId));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (jwt != null) {
            localVarFormParams.put("jwt", jwt);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"text/plain"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAccessTokenViaJWTValidateBeforeCall(String account, String serviceId, String xRequestId, String jwt, ApiCallback _callback) throws ApiException {
        if (account == null) {
            throw new ApiException("Missing the required parameter 'account' when calling getAccessTokenViaJWT(Async)");
        }
        if (serviceId == null) {
            throw new ApiException("Missing the required parameter 'serviceId' when calling getAccessTokenViaJWT(Async)");
        }
        Call localVarCall = this.getAccessTokenViaJWTCall(account, serviceId, xRequestId, jwt, _callback);
        return localVarCall;
    }

    public String getAccessTokenViaJWT(String account, String serviceId, String xRequestId, String jwt) throws ApiException {
        ApiResponse<String> localVarResp = this.getAccessTokenViaJWTWithHttpInfo(account, serviceId, xRequestId, jwt);
        return localVarResp.getData();
    }

    public String getAccessTokenViaJWT(String account, String serviceId) throws ApiException {
        ApiResponse<String> localVarResp = this.getAccessTokenViaJWTWithHttpInfo(account, serviceId, null, null);
        return localVarResp.getData();
    }

    public ApiResponse<String> getAccessTokenViaJWTWithHttpInfo(String account, String serviceId, String xRequestId, String jwt) throws ApiException {
        Call localVarCall = this.getAccessTokenViaJWTValidateBeforeCall(account, serviceId, xRequestId, jwt, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public ApiResponse<String> getAccessTokenViaJWTWithHttpInfo(String account, String serviceId) throws ApiException {
        Call localVarCall = this.getAccessTokenViaJWTValidateBeforeCall(account, serviceId, null, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAccessTokenViaJWTAsync(String account, String serviceId, String xRequestId, String jwt, ApiCallback<String> _callback) throws ApiException {
        Call localVarCall = this.getAccessTokenViaJWTValidateBeforeCall(account, serviceId, xRequestId, jwt, _callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAccessTokenViaKubernetesCall(String serviceId, String account, String login, String acceptEncoding, String xRequestId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/authn-k8s/{service_id}/{account}/{login}/authenticate".replaceAll("\\{service_id\\}", this.localVarApiClient.escapeString(serviceId.toString())).replaceAll("\\{account\\}", this.localVarApiClient.escapeString(account.toString())).replaceAll("\\{login\\}", this.localVarApiClient.escapeString(login.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (xRequestId != null) {
            localVarHeaderParams.put("X-Request-Id", this.localVarApiClient.parameterToString(xRequestId));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"conjurKubernetesMutualTls"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAccessTokenViaKubernetesValidateBeforeCall(String serviceId, String account, String login, String acceptEncoding, String xRequestId, ApiCallback _callback) throws ApiException {
        if (serviceId == null) {
            throw new ApiException("Missing the required parameter 'serviceId' when calling getAccessTokenViaKubernetes(Async)");
        }
        if (account == null) {
            throw new ApiException("Missing the required parameter 'account' when calling getAccessTokenViaKubernetes(Async)");
        }
        if (login == null) {
            throw new ApiException("Missing the required parameter 'login' when calling getAccessTokenViaKubernetes(Async)");
        }
        Call localVarCall = this.getAccessTokenViaKubernetesCall(serviceId, account, login, acceptEncoding, xRequestId, _callback);
        return localVarCall;
    }

    public String getAccessTokenViaKubernetes(String serviceId, String account, String login, String acceptEncoding, String xRequestId) throws ApiException {
        ApiResponse<String> localVarResp = this.getAccessTokenViaKubernetesWithHttpInfo(serviceId, account, login, acceptEncoding, xRequestId);
        return localVarResp.getData();
    }

    public String getAccessTokenViaKubernetes(String serviceId, String account, String login) throws ApiException {
        ApiResponse<String> localVarResp = this.getAccessTokenViaKubernetesWithHttpInfo(serviceId, account, login, null, null);
        return localVarResp.getData();
    }

    public ApiResponse<String> getAccessTokenViaKubernetesWithHttpInfo(String serviceId, String account, String login, String acceptEncoding, String xRequestId) throws ApiException {
        Call localVarCall = this.getAccessTokenViaKubernetesValidateBeforeCall(serviceId, account, login, acceptEncoding, xRequestId, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public ApiResponse<String> getAccessTokenViaKubernetesWithHttpInfo(String serviceId, String account, String login) throws ApiException {
        Call localVarCall = this.getAccessTokenViaKubernetesValidateBeforeCall(serviceId, account, login, null, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAccessTokenViaKubernetesAsync(String serviceId, String account, String login, String acceptEncoding, String xRequestId, ApiCallback<String> _callback) throws ApiException {
        Call localVarCall = this.getAccessTokenViaKubernetesValidateBeforeCall(serviceId, account, login, acceptEncoding, xRequestId, _callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAccessTokenViaLDAPCall(String serviceId, String account, String login, String acceptEncoding, String xRequestId, String body, ApiCallback _callback) throws ApiException {
        String localVarPostBody = body;
        String localVarPath = "/authn-ldap/{service_id}/{account}/{login}/authenticate".replaceAll("\\{service_id\\}", this.localVarApiClient.escapeString(serviceId.toString())).replaceAll("\\{account\\}", this.localVarApiClient.escapeString(account.toString())).replaceAll("\\{login\\}", this.localVarApiClient.escapeString(login.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (xRequestId != null) {
            localVarHeaderParams.put("X-Request-Id", this.localVarApiClient.parameterToString(xRequestId));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"text/plain"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAccessTokenViaLDAPValidateBeforeCall(String serviceId, String account, String login, String acceptEncoding, String xRequestId, String body, ApiCallback _callback) throws ApiException {
        if (serviceId == null) {
            throw new ApiException("Missing the required parameter 'serviceId' when calling getAccessTokenViaLDAP(Async)");
        }
        if (account == null) {
            throw new ApiException("Missing the required parameter 'account' when calling getAccessTokenViaLDAP(Async)");
        }
        if (login == null) {
            throw new ApiException("Missing the required parameter 'login' when calling getAccessTokenViaLDAP(Async)");
        }
        Call localVarCall = this.getAccessTokenViaLDAPCall(serviceId, account, login, acceptEncoding, xRequestId, body, _callback);
        return localVarCall;
    }

    public String getAccessTokenViaLDAP(String serviceId, String account, String login, String acceptEncoding, String xRequestId, String body) throws ApiException {
        ApiResponse<String> localVarResp = this.getAccessTokenViaLDAPWithHttpInfo(serviceId, account, login, acceptEncoding, xRequestId, body);
        return localVarResp.getData();
    }

    public String getAccessTokenViaLDAP(String serviceId, String account, String login) throws ApiException {
        ApiResponse<String> localVarResp = this.getAccessTokenViaLDAPWithHttpInfo(serviceId, account, login, null, null, null);
        return localVarResp.getData();
    }

    public ApiResponse<String> getAccessTokenViaLDAPWithHttpInfo(String serviceId, String account, String login, String acceptEncoding, String xRequestId, String body) throws ApiException {
        Call localVarCall = this.getAccessTokenViaLDAPValidateBeforeCall(serviceId, account, login, acceptEncoding, xRequestId, body, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public ApiResponse<String> getAccessTokenViaLDAPWithHttpInfo(String serviceId, String account, String login) throws ApiException {
        Call localVarCall = this.getAccessTokenViaLDAPValidateBeforeCall(serviceId, account, login, null, null, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAccessTokenViaLDAPAsync(String serviceId, String account, String login, String acceptEncoding, String xRequestId, String body, ApiCallback<String> _callback) throws ApiException {
        Call localVarCall = this.getAccessTokenViaLDAPValidateBeforeCall(serviceId, account, login, acceptEncoding, xRequestId, body, _callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAccessTokenViaOIDCCall(String serviceId, String account, String xRequestId, String idToken, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/authn-oidc/{service_id}/{account}/authenticate".replaceAll("\\{service_id\\}", this.localVarApiClient.escapeString(serviceId.toString())).replaceAll("\\{account\\}", this.localVarApiClient.escapeString(account.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xRequestId != null) {
            localVarHeaderParams.put("X-Request-Id", this.localVarApiClient.parameterToString(xRequestId));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idToken != null) {
            localVarFormParams.put("id_token", idToken);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"text/plain"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAccessTokenViaOIDCValidateBeforeCall(String serviceId, String account, String xRequestId, String idToken, ApiCallback _callback) throws ApiException {
        if (serviceId == null) {
            throw new ApiException("Missing the required parameter 'serviceId' when calling getAccessTokenViaOIDC(Async)");
        }
        if (account == null) {
            throw new ApiException("Missing the required parameter 'account' when calling getAccessTokenViaOIDC(Async)");
        }
        Call localVarCall = this.getAccessTokenViaOIDCCall(serviceId, account, xRequestId, idToken, _callback);
        return localVarCall;
    }

    public String getAccessTokenViaOIDC(String serviceId, String account, String xRequestId, String idToken) throws ApiException {
        ApiResponse<String> localVarResp = this.getAccessTokenViaOIDCWithHttpInfo(serviceId, account, xRequestId, idToken);
        return localVarResp.getData();
    }

    public String getAccessTokenViaOIDC(String serviceId, String account) throws ApiException {
        ApiResponse<String> localVarResp = this.getAccessTokenViaOIDCWithHttpInfo(serviceId, account, null, null);
        return localVarResp.getData();
    }

    public ApiResponse<String> getAccessTokenViaOIDCWithHttpInfo(String serviceId, String account, String xRequestId, String idToken) throws ApiException {
        Call localVarCall = this.getAccessTokenViaOIDCValidateBeforeCall(serviceId, account, xRequestId, idToken, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public ApiResponse<String> getAccessTokenViaOIDCWithHttpInfo(String serviceId, String account) throws ApiException {
        Call localVarCall = this.getAccessTokenViaOIDCValidateBeforeCall(serviceId, account, null, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAccessTokenViaOIDCAsync(String serviceId, String account, String xRequestId, String idToken, ApiCallback<String> _callback) throws ApiException {
        Call localVarCall = this.getAccessTokenViaOIDCValidateBeforeCall(serviceId, account, xRequestId, idToken, _callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call k8sInjectClientCertCall(String serviceId, String body, String hostIdPrefix, String xRequestId, ApiCallback _callback) throws ApiException {
        String localVarPostBody = body;
        String localVarPath = "/authn-k8s/{service_id}/inject_client_cert".replaceAll("\\{service_id\\}", this.localVarApiClient.escapeString(serviceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (hostIdPrefix != null) {
            localVarHeaderParams.put("Host-Id-Prefix", this.localVarApiClient.parameterToString(hostIdPrefix));
        }
        if (xRequestId != null) {
            localVarHeaderParams.put("X-Request-Id", this.localVarApiClient.parameterToString(xRequestId));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"text/plain"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth", "conjurAuth", "conjurKubernetesMutualTls"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call k8sInjectClientCertValidateBeforeCall(String serviceId, String body, String hostIdPrefix, String xRequestId, ApiCallback _callback) throws ApiException {
        if (serviceId == null) {
            throw new ApiException("Missing the required parameter 'serviceId' when calling k8sInjectClientCert(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling k8sInjectClientCert(Async)");
        }
        Call localVarCall = this.k8sInjectClientCertCall(serviceId, body, hostIdPrefix, xRequestId, _callback);
        return localVarCall;
    }

    public void k8sInjectClientCert(String serviceId, String body, String hostIdPrefix, String xRequestId) throws ApiException {
        this.k8sInjectClientCertWithHttpInfo(serviceId, body, hostIdPrefix, xRequestId);
    }

    public void k8sInjectClientCert(String serviceId, String body) throws ApiException {
        this.k8sInjectClientCertWithHttpInfo(serviceId, body, null, null);
    }

    public ApiResponse<Void> k8sInjectClientCertWithHttpInfo(String serviceId, String body, String hostIdPrefix, String xRequestId) throws ApiException {
        Call localVarCall = this.k8sInjectClientCertValidateBeforeCall(serviceId, body, hostIdPrefix, xRequestId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public ApiResponse<Void> k8sInjectClientCertWithHttpInfo(String serviceId, String body) throws ApiException {
        Call localVarCall = this.k8sInjectClientCertValidateBeforeCall(serviceId, body, null, null, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call k8sInjectClientCertAsync(String serviceId, String body, String hostIdPrefix, String xRequestId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.k8sInjectClientCertValidateBeforeCall(serviceId, body, hostIdPrefix, xRequestId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call rotateApiKeyCall(String account, String role, String xRequestId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/authn/{account}/api_key".replaceAll("\\{account\\}", this.localVarApiClient.escapeString(account.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (role != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("role", role));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xRequestId != null) {
            localVarHeaderParams.put("X-Request-Id", this.localVarApiClient.parameterToString(xRequestId));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth", "conjurAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call rotateApiKeyValidateBeforeCall(String account, String role, String xRequestId, ApiCallback _callback) throws ApiException {
        if (account == null) {
            throw new ApiException("Missing the required parameter 'account' when calling rotateApiKey(Async)");
        }
        Call localVarCall = this.rotateApiKeyCall(account, role, xRequestId, _callback);
        return localVarCall;
    }

    public String rotateApiKey(String account, String role, String xRequestId) throws ApiException {
        ApiResponse<String> localVarResp = this.rotateApiKeyWithHttpInfo(account, role, xRequestId);
        return localVarResp.getData();
    }

    public String rotateApiKey(String account) throws ApiException {
        ApiResponse<String> localVarResp = this.rotateApiKeyWithHttpInfo(account, null, null);
        return localVarResp.getData();
    }

    public ApiResponse<String> rotateApiKeyWithHttpInfo(String account, String role, String xRequestId) throws ApiException {
        Call localVarCall = this.rotateApiKeyValidateBeforeCall(account, role, xRequestId, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public ApiResponse<String> rotateApiKeyWithHttpInfo(String account) throws ApiException {
        Call localVarCall = this.rotateApiKeyValidateBeforeCall(account, null, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call rotateApiKeyAsync(String account, String role, String xRequestId, ApiCallback<String> _callback) throws ApiException {
        Call localVarCall = this.rotateApiKeyValidateBeforeCall(account, role, xRequestId, _callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

