/*
 * Decompiled with CFR 0.152.
 */
package com.cyberark.conjur.sdk.endpoint;

import com.cyberark.conjur.sdk.ApiCallback;
import com.cyberark.conjur.sdk.ApiClient;
import com.cyberark.conjur.sdk.ApiException;
import com.cyberark.conjur.sdk.ApiResponse;
import com.cyberark.conjur.sdk.Configuration;
import com.cyberark.conjur.sdk.Pair;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class SecretsApi {
    private ApiClient localVarApiClient;

    public SecretsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SecretsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call createSecretCall(String account, String kind, String identifier, String expirations, String xRequestId, String body, ApiCallback _callback) throws ApiException {
        String localVarPostBody = body;
        String localVarPath = "/secrets/{account}/{kind}/{identifier}".replaceAll("\\{account\\}", this.localVarApiClient.escapeString(account.toString())).replaceAll("\\{kind\\}", this.localVarApiClient.escapeString(kind.toString())).replaceAll("\\{identifier\\}", this.localVarApiClient.escapeString(identifier.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (expirations != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("expirations", expirations));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xRequestId != null) {
            localVarHeaderParams.put("X-Request-Id", this.localVarApiClient.parameterToString(xRequestId));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/octet-stream"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"conjurAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createSecretValidateBeforeCall(String account, String kind, String identifier, String expirations, String xRequestId, String body, ApiCallback _callback) throws ApiException {
        if (account == null) {
            throw new ApiException("Missing the required parameter 'account' when calling createSecret(Async)");
        }
        if (kind == null) {
            throw new ApiException("Missing the required parameter 'kind' when calling createSecret(Async)");
        }
        if (identifier == null) {
            throw new ApiException("Missing the required parameter 'identifier' when calling createSecret(Async)");
        }
        Call localVarCall = this.createSecretCall(account, kind, identifier, expirations, xRequestId, body, _callback);
        return localVarCall;
    }

    public void createSecret(String account, String kind, String identifier, String expirations, String xRequestId, String body) throws ApiException {
        this.createSecretWithHttpInfo(account, kind, identifier, expirations, xRequestId, body);
    }

    public void createSecret(String account, String kind, String identifier) throws ApiException {
        this.createSecretWithHttpInfo(account, kind, identifier, null, null, null);
    }

    public ApiResponse<Void> createSecretWithHttpInfo(String account, String kind, String identifier, String expirations, String xRequestId, String body) throws ApiException {
        Call localVarCall = this.createSecretValidateBeforeCall(account, kind, identifier, expirations, xRequestId, body, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public ApiResponse<Void> createSecretWithHttpInfo(String account, String kind, String identifier) throws ApiException {
        Call localVarCall = this.createSecretValidateBeforeCall(account, kind, identifier, null, null, null, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call createSecretAsync(String account, String kind, String identifier, String expirations, String xRequestId, String body, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.createSecretValidateBeforeCall(account, kind, identifier, expirations, xRequestId, body, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getSecretCall(String account, String kind, String identifier, Integer version, String xRequestId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/secrets/{account}/{kind}/{identifier}".replaceAll("\\{account\\}", this.localVarApiClient.escapeString(account.toString())).replaceAll("\\{kind\\}", this.localVarApiClient.escapeString(kind.toString())).replaceAll("\\{identifier\\}", this.localVarApiClient.escapeString(identifier.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (version != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("version", version));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xRequestId != null) {
            localVarHeaderParams.put("X-Request-Id", this.localVarApiClient.parameterToString(xRequestId));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"conjurAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSecretValidateBeforeCall(String account, String kind, String identifier, Integer version, String xRequestId, ApiCallback _callback) throws ApiException {
        if (account == null) {
            throw new ApiException("Missing the required parameter 'account' when calling getSecret(Async)");
        }
        if (kind == null) {
            throw new ApiException("Missing the required parameter 'kind' when calling getSecret(Async)");
        }
        if (identifier == null) {
            throw new ApiException("Missing the required parameter 'identifier' when calling getSecret(Async)");
        }
        Call localVarCall = this.getSecretCall(account, kind, identifier, version, xRequestId, _callback);
        return localVarCall;
    }

    public String getSecret(String account, String kind, String identifier, Integer version, String xRequestId) throws ApiException {
        ApiResponse<String> localVarResp = this.getSecretWithHttpInfo(account, kind, identifier, version, xRequestId);
        return localVarResp.getData();
    }

    public String getSecret(String account, String kind, String identifier) throws ApiException {
        ApiResponse<String> localVarResp = this.getSecretWithHttpInfo(account, kind, identifier, null, null);
        return localVarResp.getData();
    }

    public ApiResponse<String> getSecretWithHttpInfo(String account, String kind, String identifier, Integer version, String xRequestId) throws ApiException {
        Call localVarCall = this.getSecretValidateBeforeCall(account, kind, identifier, version, xRequestId, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public ApiResponse<String> getSecretWithHttpInfo(String account, String kind, String identifier) throws ApiException {
        Call localVarCall = this.getSecretValidateBeforeCall(account, kind, identifier, null, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getSecretAsync(String account, String kind, String identifier, Integer version, String xRequestId, ApiCallback<String> _callback) throws ApiException {
        Call localVarCall = this.getSecretValidateBeforeCall(account, kind, identifier, version, xRequestId, _callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getSecretsCall(String variableIds, String acceptEncoding, String xRequestId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/secrets";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (variableIds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("variable_ids", variableIds));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (xRequestId != null) {
            localVarHeaderParams.put("X-Request-Id", this.localVarApiClient.parameterToString(xRequestId));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"conjurAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSecretsValidateBeforeCall(String variableIds, String acceptEncoding, String xRequestId, ApiCallback _callback) throws ApiException {
        if (variableIds == null) {
            throw new ApiException("Missing the required parameter 'variableIds' when calling getSecrets(Async)");
        }
        Call localVarCall = this.getSecretsCall(variableIds, acceptEncoding, xRequestId, _callback);
        return localVarCall;
    }

    public Object getSecrets(String variableIds, String acceptEncoding, String xRequestId) throws ApiException {
        ApiResponse<Object> localVarResp = this.getSecretsWithHttpInfo(variableIds, acceptEncoding, xRequestId);
        return localVarResp.getData();
    }

    public Object getSecrets(String variableIds) throws ApiException {
        ApiResponse<Object> localVarResp = this.getSecretsWithHttpInfo(variableIds, null, null);
        return localVarResp.getData();
    }

    public ApiResponse<Object> getSecretsWithHttpInfo(String variableIds, String acceptEncoding, String xRequestId) throws ApiException {
        Call localVarCall = this.getSecretsValidateBeforeCall(variableIds, acceptEncoding, xRequestId, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public ApiResponse<Object> getSecretsWithHttpInfo(String variableIds) throws ApiException {
        Call localVarCall = this.getSecretsValidateBeforeCall(variableIds, null, null, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getSecretsAsync(String variableIds, String acceptEncoding, String xRequestId, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.getSecretsValidateBeforeCall(variableIds, acceptEncoding, xRequestId, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

